/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.htmlviewer;

import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.ApplicationProject;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.LocalTask;
import csbase.client.remote.srvproxies.HttpProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import tecgraf.javautils.gui.GUIUtils;

public class HtmlViewer
extends ApplicationProject {
    private final String FILE_TYPE = "HTML";
    private JEditorPane htmlPane = null;
    private JScrollPane htmlScrolledPane = null;
    private ApplicationFrame mainFrame = null;
    private JButton openButton = null;
    private JButton backButton = null;
    private JButton forwardButton = null;
    private JTextField urlText = null;
    private Vector<URL> history = new Vector();
    private int histPnt = -1;

    private void actionOpen() {
        try {
            ClientProjectFile newFile = this.browseFileOpen("HTML");
            this.openFile(newFile);
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog(this.mainFrame, this.getString("HTML_VIEWER_TITLE"), this.getString("HTML_VIEWER_ERROR"), e);
        }
    }

    private void clearURL() {
        this.htmlPane.setText("");
        this.urlText.setText("");
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu(this.getString("HTML_VIEWER_MENU_FILE"));
        JMenuItem openItem = fileMenu.add(this.getString("HTML_VIEWER_FILE_OPEN"));
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlViewer.this.actionOpen();
            }
        });
        openItem.setIcon(ApplicationImages.ICON_OPEN_16);
        fileMenu.addSeparator();
        fileMenu.add(new ApplicationExitAction(this));
        return fileMenu;
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = new JMenu(this.getString("HTML_VIEWER_MENU_HELP"));
        helpMenu.add(new ApplicationAboutAction(this));
        return helpMenu;
    }

    private ApplicationFrame createMainFrame() {
        ApplicationFrame mainFrame = this.getApplicationFrame();
        mainFrame.setJMenuBar(this.createMenuBar());
        Container cp = mainFrame.getContentPane();
        cp.add((Component)this.createNorthPanel(), "North");
        cp.add((Component)this.createViewer(), "Center");
        return mainFrame;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(new JPanel());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    private JPanel createNorthPanel() {
        JPanel np = new JPanel(new BorderLayout());
        np.add((Component)this.createToolBar(), "North");
        np.add((Component)this.createURLPanel(), "Center");
        return np;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar(this.getName());
        this.openButton = new JButton(ApplicationImages.ICON_OPEN_16);
        this.openButton.setToolTipText(this.getString("HTML_VIEWER_FILE_OPEN"));
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlViewer.this.actionOpen();
            }
        });
        this.backButton = new JButton(ApplicationImages.ICON_BACK_16);
        this.backButton.setToolTipText(this.getString("HTML_VIEWER_BACK"));
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                HtmlViewer.this.goBack();
            }
        });
        this.forwardButton = new JButton(ApplicationImages.ICON_FORWARD_16);
        this.forwardButton.setToolTipText(this.getString("HTML_VIEWER_FORWARD"));
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                HtmlViewer.this.goForward();
            }
        });
        toolBar.add(this.openButton);
        toolBar.add(new JToolBar.Separator());
        toolBar.add(this.backButton);
        toolBar.add(this.forwardButton);
        return toolBar;
    }

    private JPanel createURLPanel() {
        this.urlText = new JTextField(120);
        this.urlText.setEditable(false);
        JComponent[][] components = new JComponent[][]{{new JLabel(this.getString("HTML_VIEWER_URL")), this.urlText}};
        JPanel up = GUIUtils.createBasicGridPanel((JComponent[][])components);
        return up;
    }

    private JComponent createViewer() {
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.setContentType("text/html");
        this.htmlPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                    HtmlViewer.this.setCurrentURL(e.getURL(), true);
                } else {
                    try {
                        pane.setPage(e.getURL());
                        HtmlViewer.this.setCurrentURL(e.getURL(), true);
                    }
                    catch (Throwable t) {
                        StandardErrorDialogs.showErrorDialog(HtmlViewer.this.mainFrame, HtmlViewer.this.getString("HTML_VIEWER_TITLE"), HtmlViewer.this.getString("HTML_VIEWER_ERROR"), t);
                    }
                }
            }
        });
        this.htmlScrolledPane = new JScrollPane(this.htmlPane);
        this.htmlScrolledPane.setVerticalScrollBarPolicy(22);
        return this.htmlScrolledPane;
    }

    private void createWidgets() {
        this.mainFrame = this.createMainFrame();
        this.mainFrame.setTitle(this.getString("HTML_VIEWER_TITLE"));
    }

    protected void goBack() {
        try {
            --this.histPnt;
            if (this.histPnt >= 0 || this.histPnt < this.history.size()) {
                URL url = this.history.get(this.histPnt);
                this.htmlPane.setPage(url);
                this.setCurrentURL(url, false);
            }
        }
        catch (Exception e) {
            this.showErrorURL(null, e.getMessage());
        }
    }

    protected void goForward() {
        try {
            ++this.histPnt;
            if (this.histPnt >= 0 || this.histPnt < this.history.size()) {
                URL url = this.history.get(this.histPnt);
                this.htmlPane.setPage(url);
                this.setCurrentURL(url, false);
            }
        }
        catch (Exception e) {
            this.showErrorURL(null, e.getMessage());
        }
    }

    @Override
    public void killApplication() {
    }

    private URL mountURL(String addr) {
        URL url = null;
        try {
            url = new URL(addr);
        }
        catch (Exception e) {
            url = null;
        }
        return url;
    }

    private void openFile(ClientProjectFile newFile) {
        if (newFile == null) {
            return;
        }
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        HttpProxy.setTexts(this.getString("HTML_VIEWER_PROXY_TITLE"), this.getString("HTML_VIEWER_PROXY_FAILURE"), this.getString("HTML_VIEWER_PROXY_SUCCESS"));
        String addr = HttpProxy.getDownloadURL(project.getId(), newFile.getPath());
        this.showURL(addr);
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if (value == null) {
            return;
        }
        if (name.equals("PROJECT_FILE")) {
            ClientProjectFile file = (ClientProjectFile)value;
            this.openFile(file);
        }
    }

    private void setCurrentURL(URL url, boolean count) {
        if (url == null) {
            this.clearURL();
            return;
        }
        if (count) {
            this.history.add(url);
            ++this.histPnt;
        }
        this.urlText.setText(url.toString());
        this.backButton.setEnabled(this.histPnt > 0);
        this.forwardButton.setEnabled(this.histPnt < this.history.size() - 1);
    }

    private void showDialog() {
        this.mainFrame.setSize(new Dimension(800, 600));
        this.mainFrame.center(DesktopFrame.getInstance().getDesktopFrame());
        this.mainFrame.setVisible(true);
    }

    private void showErrorURL(String addr, String msg) {
        String addStr = addr == null ? "???" : addr;
        String errorMsg = msg == null ? "" : msg;
        this.htmlPane.setText("<html><table height=100% width=100%><tr valign=center height=100% width=100%><td><p>" + this.getString("HTML_VIEWER_CANNOT_FIND") + "</p><ul><i><font color=#ff0000>" + addStr + "</font></i></ul><p>" + this.getString("HTML_VIEWER_CONTACT") + "</p><br><hr><br> <pre>" + errorMsg + "</pre></td></tr></table></html>");
        this.urlText.setText(this.getString("HTML_VIEWER_ERROR"));
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
    }

    private void showURL(String addr) {
        final String address = addr;
        if (address == null) {
            this.showErrorURL(address, "No address specified!");
            return;
        }
        try {
            final URL url = this.mountURL(address);
            if (url == null) {
                this.showErrorURL(address, "No URL could be mounted!");
                return;
            }
            LocalTask<Void> task = new LocalTask<Void>(){

                @Override
                protected void handleError(Exception error) {
                    HtmlViewer.this.showErrorURL(address, error.getMessage());
                }

                public void performTask() throws Exception {
                    HtmlViewer.this.htmlPane.setPage(url);
                    HtmlViewer.this.setCurrentURL(url, true);
                }
            };
            task.execute(this.mainFrame, this.getString("HTML_VIEWER_WAIT_TITLE"), this.getString("HTML_VIEWER_WAIT_MESSAGE"));
        }
        catch (Exception e) {
            this.showErrorURL(address, e.getMessage());
        }
    }

    @Override
    public boolean userCanKillApplication() {
        return true;
    }

    public HtmlViewer(String id) {
        super(id);
        this.createWidgets();
        this.showDialog();
    }
}

