/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import javax.swing.filechooser.FileFilter;

public class Filter
extends FileFilter {
    private Collection<String> extensions;
    private String description;
    protected boolean acceptNoExtension = true;

    public Filter(String extension, String description) {
        this(extension, description, true);
    }

    public Filter(Collection<String> extensions, String description) {
        this(extensions, description, true);
    }

    public Filter(String extension, String description, boolean acceptNoExtension) {
        this(Collections.singletonList(extension), description, acceptNoExtension);
    }

    public Filter(Collection<String> extensions, String description, boolean acceptNoExtension) {
        this.extensions = extensions;
        this.description = description;
        this.acceptNoExtension = acceptNoExtension;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        return this.isAccept(f);
    }

    public boolean isAccept(File file) {
        String ext = null;
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i == -1 && this.acceptNoExtension) {
            return true;
        }
        return i > 0 && i < fileName.length() - 1 && this.extensions.contains(ext = fileName.substring(i + 1).toLowerCase());
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

