/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui.log.actions;

import csbase.client.ClientLocalFile;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.actions.core.AbstractLogFileAction;
import csbase.logic.ClientProjectFile;
import java.awt.Component;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.JComponent;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ExportLogAction
extends AbstractLogFileAction {
    private ClientLocalFile lastSelectedDir;

    public ExportLogAction(LogPanel logPanel) {
        super(logPanel, ApplicationImages.ICON_EXPORT_16);
    }

    @Override
    public void actionDone(JComponent component) throws Exception {
        String message;
        String title = LNG.get((String)"ExportLogAction.chooser.title");
        ArrayList<String> fileCodes = new ArrayList<String>();
        fileCodes.add("TEXT");
        fileCodes.add("LOG");
        final ClientLocalFile localFile = ClientLocalFileChooserUtil.browseSingleFileInSaveMode(this.getLogPanel().getOwner(), fileCodes, "LOG", title, true, this.lastSelectedDir);
        if (localFile == null) {
            return;
        }
        this.lastSelectedDir = localFile.getParent();
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                ExportLogAction.this.exportAsStream(localFile);
            }
        };
        Window window = this.getLogPanel().getOwner();
        boolean result = task.execute(window, title, message = LNG.get((String)"ExportLogAction.export.log"));
        if (result) {
            message = LNG.get((String)"ExportLogAction.export.log.success", (Object[])new Object[]{localFile.getStringPath()});
            StandardDialogs.showInfoDialog((Component)window, (String)title, (Object)message);
        }
    }

    private void exportAsStream(ClientLocalFile localFile) throws Exception {
        int bufferSize = 49152;
        ClientProjectFile remoteFile = this.getLogPanel().getFile();
        if (remoteFile == null || !remoteFile.exists()) {
            return;
        }
        InputStream prjStream = remoteFile.getInputStream();
        BufferedInputStream in = new BufferedInputStream(prjStream);
        OutputStream fileStream = localFile.getOutputStream();
        BufferedOutputStream out = new BufferedOutputStream(fileStream);
        byte[] buffer = new byte[49152];
        int len = 0;
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
        in.close();
    }
}

