/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.AttributesPermission;
import csbase.logic.Permission;
import csbase.logic.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import tecgraf.javautils.core.io.FileUtils;

public class AccessSGAPathPermission
extends AttributesPermission {
    public static final String SGA_ATT = "sga=";
    public static final String ALLOW_ATT = "permitir=";
    public static final String DENY_ATT = "excluir=";
    public static final String PATH_ATT = "caminho=";

    public AccessSGAPathPermission() {
    }

    public AccessSGAPathPermission(String name, String description, String[] attributes) {
        super(name, description, attributes);
    }

    public static boolean canReadPath(User user, String sga, String path) {
        if (user == null) {
            throw new IllegalArgumentException("user n\u00e3o pode ser nulo.");
        }
        if (user.isAdmin()) {
            return true;
        }
        List<AccessSGAPathPermission> permissions = AccessSGAPathPermission.getAllAccessSGAPathPermissions(user);
        if (permissions.isEmpty()) {
            return false;
        }
        for (AccessSGAPathPermission p : permissions) {
            Pattern denyPatt;
            Matcher m;
            Pattern sgaPatt = AccessSGAPathPermission.createSGAPattern(p.getAttributes());
            if (sgaPatt == null || sga == null || !(m = sgaPatt.matcher(sga)).matches() || (denyPatt = AccessSGAPathPermission.createDenyPattern(p.getAttributes())) != null && path != null && (m = denyPatt.matcher(path)).matches()) continue;
            Pattern allowPatt = AccessSGAPathPermission.createAllowPattern(p.getAttributes());
            if (allowPatt != null && path != null && (m = allowPatt.matcher(path)).matches()) {
                return true;
            }
            Pattern pathPatt = AccessSGAPathPermission.createPathPattern(p.getAttributes());
            if (pathPatt == null || path == null || !(m = pathPatt.matcher(path)).matches()) continue;
            return true;
        }
        return false;
    }

    private static List<AccessSGAPathPermission> getAllAccessSGAPathPermissions(User user) {
        ArrayList<AccessSGAPathPermission> permissions = new ArrayList<AccessSGAPathPermission>();
        try {
            for (Object permissionId : user.getAllPermissionIds()) {
                Permission permission = Permission.getPermission(permissionId);
                if (!permission.getClass().equals(AccessSGAPathPermission.class)) continue;
                permissions.add((AccessSGAPathPermission)permission);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return permissions;
    }

    private static Pattern createSGAPattern(String[] values) {
        StringBuilder builder = new StringBuilder();
        boolean hasPatt = false;
        for (String value : values) {
            String regex;
            if (!AccessSGAPathPermission.isSGAAtt(value) || (regex = AccessSGAPathPermission.getValue(value)) == null || !AccessSGAPathPermission.isPatternValid(regex)) continue;
            if (hasPatt) {
                builder.append("|");
            }
            builder.append(regex);
            hasPatt = true;
        }
        if (!hasPatt) {
            return null;
        }
        return Pattern.compile(builder.toString());
    }

    private static Pattern createDenyPattern(String[] values) {
        StringBuilder builder = new StringBuilder();
        boolean hasPatt = false;
        for (String value : values) {
            String regex;
            if (!AccessSGAPathPermission.isDenyAtt(value) || (regex = AccessSGAPathPermission.getValue(value)) == null || !AccessSGAPathPermission.isPatternValid(regex)) continue;
            if (hasPatt) {
                builder.append("|");
            }
            builder.append(regex);
            hasPatt = true;
        }
        if (!hasPatt) {
            return null;
        }
        return Pattern.compile(builder.toString());
    }

    private static Pattern createAllowPattern(String[] values) {
        StringBuilder builder = new StringBuilder();
        boolean hasPatt = false;
        for (String value : values) {
            String regex;
            if (!AccessSGAPathPermission.isAllowAtt(value) || (regex = AccessSGAPathPermission.getValue(value)) == null || !AccessSGAPathPermission.isPatternValid(regex)) continue;
            if (hasPatt) {
                builder.append("|");
            }
            builder.append(regex);
            hasPatt = true;
        }
        if (!hasPatt) {
            return null;
        }
        return Pattern.compile(builder.toString());
    }

    private static Pattern createPathPattern(String[] values) {
        StringBuilder builder = new StringBuilder();
        boolean hasPatt = false;
        for (String value : values) {
            String regex;
            if (!AccessSGAPathPermission.isPathAtt(value) || (regex = AccessSGAPathPermission.buildRegex(AccessSGAPathPermission.getValue(value))) == null || !AccessSGAPathPermission.isPatternValid(regex)) continue;
            if (hasPatt) {
                builder.append("|");
            }
            builder.append(regex);
            hasPatt = true;
        }
        if (!hasPatt) {
            return null;
        }
        return Pattern.compile(builder.toString());
    }

    private static boolean isPatternValid(String regex) {
        try {
            Pattern.compile(regex);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    private static String buildRegex(String value) {
        boolean isAbsolute = FileUtils.isAbsolutePath((String)value);
        String[] splited = FileUtils.splitPath((String)value, (char)'/');
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < splited.length; ++i) {
            String[] subArray = Arrays.copyOfRange(splited, 0, i + 1);
            String subPath = isAbsolute ? FileUtils.joinPath((boolean)true, (char)'/', (String[])subArray) : FileUtils.joinPath((String[])subArray);
            b.append(subPath);
            if (i < splited.length - 1) {
                b.append("|");
                continue;
            }
            b.append("|");
            b.append(subPath);
            b.append("/.*");
        }
        return String.format("(%s)", b.toString());
    }

    private static String getValue(String att) {
        int index = att.indexOf("=");
        if (index == -1) {
            return null;
        }
        return att.substring(index + 1);
    }

    private static boolean isSGAAtt(String att) {
        return att.startsWith(SGA_ATT);
    }

    private static boolean isAllowAtt(String att) {
        return att.startsWith(ALLOW_ATT);
    }

    private static boolean isDenyAtt(String att) {
        return att.startsWith(DENY_ATT);
    }

    private static boolean isPathAtt(String att) {
        return att.startsWith(PATH_ATT);
    }
}

