/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.exception.project.FileLockedException;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;
import csbase.logic.ProjectFileType;
import csbase.logic.RemoteFileInputStream;
import csbase.logic.RemoteFileOutputStream;
import csbase.logic.SyncRemoteFileChannel;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.remote.ClientRemoteLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Arrays;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;

public class ClientAlgorithmFile
implements ClientFile,
Serializable,
Comparable<ClientAlgorithmFile> {
    private transient SyncRemoteFileChannel channel;
    private boolean isDirectory;
    private String name;
    private String[] path;
    private int numberOfChannelOpens;
    private ClientAlgorithmFile parent;
    private final AlgorithmInfo algorithmInfo;
    private final AlgorithmVersionId versionId;
    private final String platformName;
    private boolean updated;
    private long size;
    private boolean opened;
    private AlgorithmFileType treeFileType;

    public ClientAlgorithmFile(AlgorithmInfo algorithmInfo, AlgorithmVersionId versionId, String name, String[] path, AlgorithmFileType treeFileType, boolean isDirectory) {
        this(algorithmInfo, versionId, "", name, path, 0L, null, treeFileType, isDirectory);
    }

    public ClientAlgorithmFile(AlgorithmInfo algorithmInfo, AlgorithmVersionId versionId, String platformName, String name, String[] path, boolean isDirectory) {
        this(algorithmInfo, versionId, platformName, name, path, 0L, null, AlgorithmFileType.EXECUTABLE, isDirectory);
    }

    public ClientAlgorithmFile(AlgorithmInfo algorithmInfo, AlgorithmVersionId versionId, String platformName, String name, String[] path, long size, ClientAlgorithmFile parent, AlgorithmFileType treeFileType, boolean isDirectory) {
        this.algorithmInfo = algorithmInfo;
        this.versionId = versionId;
        this.platformName = platformName;
        this.name = name;
        this.path = path;
        this.parent = parent;
        this.treeFileType = treeFileType;
        this.isDirectory = isDirectory;
        this.size = size;
        this.channel = null;
        this.numberOfChannelOpens = 0;
        this.opened = false;
        this.updated = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.path[this.path.length - 1] = name;
    }

    @Override
    public String getStringPath() {
        String[] pathArray = this.getPath();
        if (pathArray == null || pathArray.length <= 0) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < pathArray.length - 1; ++i) {
            path.append(pathArray[i]);
            path.append('/');
        }
        return path.append(pathArray[pathArray.length - 1]).toString();
    }

    @Override
    public String[] getPath() {
        return (String[])this.path.clone();
    }

    @Override
    public String getType() {
        String fileExtension = FileUtils.getFileExtension((String)this.getName());
        ProjectFileType pft = ProjectFileType.getProjectFileTypeFromExtension(fileExtension, false);
        if (pft == null) {
            return "UNKNOWN";
        }
        return pft.getCode();
    }

    @Override
    public ClientAlgorithmFile getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        int parentIdx = this.path.length - 2;
        if (parentIdx < 0 || this.treeFileType != AlgorithmFileType.EXECUTABLE) {
            return null;
        }
        String parentName = this.path[parentIdx];
        String[] parentPath = Arrays.copyOfRange(this.path, 0, parentIdx);
        this.parent = new ClientAlgorithmFile(this.algorithmInfo, this.versionId, this.platformName, parentName, parentPath, true);
        return this.parent;
    }

    public void setParent(ClientAlgorithmFile parent) {
        this.parent = parent;
    }

    @Override
    public ClientFile[] getChildren() throws Exception {
        return null;
    }

    public void updateInfo() throws RemoteException {
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long getModificationDate() {
        return 0L;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    @Override
    public boolean exists() throws RemoteException {
        return this.existsFile(this.algorithmInfo, this.versionId, this.getPath());
    }

    private boolean existsFile(AlgorithmInfo info, AlgorithmVersionId algoVersion, String[] path) throws RemoteException {
        if (this.isExecutableFile()) {
            return ClientRemoteLocator.algorithmService.execFileExists(info.getId(), algoVersion, this.platformName, Arrays.toString(path));
        }
        if (this.isConfigurationFile()) {
            return ClientRemoteLocator.algorithmService.configFileExists(info.getId(), algoVersion, Arrays.toString(path));
        }
        return ClientRemoteLocator.algorithmService.docFileExists(info.getId(), algoVersion, Arrays.toString(path));
    }

    public static String[] splitPath(String path) {
        int i;
        String[] pathArray = path.split("/");
        for (i = 0; i < pathArray.length && pathArray[i].equals(""); ++i) {
        }
        if (i > 0) {
            String[] newPath = new String[pathArray.length - i];
            System.arraycopy(pathArray, i, newPath, 0, newPath.length);
            pathArray = newPath;
        }
        return pathArray;
    }

    public void truncate(long newSize) throws IOException {
        try {
            this.channel.setSize(newSize);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private SyncRemoteFileChannel openChannel(boolean readOnly) throws RemoteException {
        RemoteFileChannelInfo info = this.getChannel(readOnly);
        if (info == null) {
            return null;
        }
        SyncRemoteFileChannel srfc = new SyncRemoteFileChannel(info.getIdentifier(), info.isWritable(), info.getHost(), info.getPort(), info.getKey());
        try {
            srfc.open(readOnly);
            return srfc;
        }
        catch (Exception e) {
            this.channel = null;
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private RemoteFileChannelInfo getChannel(boolean readOnly) throws RemoteException {
        if (this.isExecutableFile()) {
            return ClientRemoteLocator.algorithmService.openExecFileChannel(this.algorithmInfo.getId(), this.versionId, this.platformName, this.getStringPath(), readOnly);
        }
        if (this.isConfigurationFile()) {
            return ClientRemoteLocator.algorithmService.openConfFileChannel(this.algorithmInfo.getId(), this.versionId, this.getStringPath(), readOnly);
        }
        if (this.isDocumentationFile()) {
            return ClientRemoteLocator.algorithmService.openDocFileChannel(this.algorithmInfo.getId(), this.versionId, this.getStringPath(), readOnly);
        }
        if (this.isReleaseNotesFile()) {
            return ClientRemoteLocator.algorithmService.openReleaseNotesFileChannel(this.algorithmInfo.getId(), this.versionId, this.getStringPath(), readOnly);
        }
        return null;
    }

    @Override
    public void open(boolean readOnly) throws RemoteException {
        this.updateInfo();
        if (!this.opened) {
            this.channel = this.openChannel(readOnly);
            this.numberOfChannelOpens = 1;
            this.opened = true;
        } else {
            ++this.numberOfChannelOpens;
        }
    }

    @Override
    public long position() {
        return this.channel.getPosition();
    }

    @Override
    public void position(long newPosition) throws IOException {
        try {
            this.channel.setPosition(newPosition);
        }
        catch (FailureException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public int read(byte[] dst, long position) throws IOException {
        try {
            int length = (int)Math.min((long)dst.length, this.channel.getSize() - position);
            return this.channel.syncRead(dst, 0, length, position);
        }
        catch (FailureException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public int read(byte[] target, int offset, int length, long position) throws IOException {
        try {
            length = (int)Math.min((long)length, this.channel.getSize() - position);
            return this.channel.read(target, offset, length, position);
        }
        catch (FailureException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void write(byte[] src, long position) throws IOException, FileLockedException {
        try {
            this.channel.syncWrite(src, 0, src.length, position);
        }
        catch (tecgraf.ftc.common.exception.FileLockedException e) {
            throw new FileLockedException(this.getName(), this.isDirectory());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void write(byte[] src, int off, int len, long position) throws IOException, FileLockedException {
        try {
            this.channel.syncWrite(src, off, len, position);
        }
        catch (tecgraf.ftc.common.exception.FileLockedException e) {
            throw new FileLockedException(this.getName(), this.isDirectory());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void close(boolean force) throws RemoteException, IOException {
        if (this.opened && --this.numberOfChannelOpens == 0) {
            try {
                this.channel.close();
                this.channel = null;
                this.opened = false;
            }
            catch (FailureException e) {
                if (force) {
                    this.channel = null;
                    this.opened = false;
                }
                throw new RemoteException(e.getMessage(), e);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ClientAlgorithmFile other = (ClientAlgorithmFile)o;
        return this.algorithmInfo.equals(other.getInfo()) && this.versionId.equals(other.getAlgorithmVersion()) && Arrays.equals(this.path, other.path);
    }

    public AlgorithmInfo getInfo() {
        return this.algorithmInfo;
    }

    public AlgorithmVersionId getAlgorithmVersion() {
        return this.versionId;
    }

    public String getPlatformName() {
        if (this.isExecutableFile()) {
            return this.platformName;
        }
        return null;
    }

    public int hashCode() {
        int hash = this.algorithmInfo.hashCode() + this.versionId.hashCode();
        for (String part : this.path) {
            hash += part.hashCode();
        }
        return hash;
    }

    @Override
    public int compareTo(ClientAlgorithmFile other) {
        return this.name.compareTo(other.name);
    }

    public static boolean hasDirectories(ClientAlgorithmFile[] projectFiles) {
        for (int i = 0; i < projectFiles.length; ++i) {
            if (!projectFiles[i].isDirectory()) continue;
            return true;
        }
        return false;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        SyncRemoteFileChannel srfc = this.openChannel(true);
        String id = this.getStringPath();
        return new RemoteFileInputStream(id.getBytes(), srfc);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        SyncRemoteFileChannel srfc = this.openChannel(false);
        String id = this.getStringPath();
        return new RemoteFileOutputStream(id.getBytes(), srfc);
    }

    @Override
    public ClientFileType getClientFileType() {
        return ClientFileType.REMOTE;
    }

    public AlgorithmFileType getTreeFileType() {
        return this.treeFileType;
    }

    private boolean isExecutableFile() {
        return this.treeFileType == AlgorithmFileType.EXECUTABLE;
    }

    private boolean isConfigurationFile() {
        return this.treeFileType == AlgorithmFileType.CONFIGURATION;
    }

    private boolean isDocumentationFile() {
        return this.treeFileType == AlgorithmFileType.DOCUMENTATION;
    }

    private boolean isReleaseNotesFile() {
        return this.treeFileType == AlgorithmFileType.RELEASE_NOTES;
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    public static enum AlgorithmFileType {
        EXECUTABLE,
        CONFIGURATION,
        DOCUMENTATION,
        RELEASE_NOTES;

    }
}

