/**
 * $Id: SGADriver.java 172594 2016-04-12 15:11:18Z fpina $
 */

package csbase.sga.ssh;

import java.util.Map;
import java.util.Properties;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.monitor.SGAInfo;

/**
 * @author Tecgraf
 */
public interface SGADriver {
  void init(Properties properties);

  /**
   * Build the command to submit a job in the execution environment.
   *
   * @param script script to execute
   * @param extraParam extra parameters to the execution environment
   *
   * @return the command to submit the job
   */
  String buildSubmitJobCommand(String script, Map<String, String> extraParam);

  /**
   * Parse the output of the command to submit a job in the execution
   * environment.
   *
   * @param output the output to parse
   *
   * @return the {@link JobData} representing the job
   */
  JobData parseJobSubmissionOutput(String output);

  /**
   * Build the command to check the information of a job.
   *
   * @param jobData the {@link JobData} representing the job
   *
   * @return the command to check the job
   */
  String buildCheckJobCommand(JobData jobData);

  /**
   * Parse the output of the command to check one job in the execution environment.
   *
   * @param jobData the {@link JobData} representing the job
   * @param output the output to parse
   *
   * @return the corresponding {@link JobInfo}
   */
  JobInfo parseCheckJobOutput(JobData jobData, String output);

  /**
   * Build the command to check the information of a list of jobs in the
   * execution environment.
   *
   * @return the command to check all jobs
   */
  String buildCheckJobListCommand(JobData[] jobDataList);

  /**
   * Parse the output of the command to check a list of jobs in the execution
   * environment.
   *
   * @param jobDataList the array of {@link JobData} representing the jobs
   * @param output the output to parse
   *
   * @return a map with {@link JobData} and the corresponding {@link JobInfo}
   */
  Map<JobData, JobInfo> parseCheckJobListOutput(JobData[] jobDataList, String output);

  /**
   * Build the command to kill a job in the execution environment.
   *
   * @param jobData the {@link JobData} representing the job
   *
   * @return the command to kill the job
   */
  String buildKillJobCommand(JobData jobData);

  /**
   * Build the command to check the environment state.
   *
   * @return the command to check the environment.
   */
  String buildCheckEnvironmentCommand();

  /**
   * Parse the output of the command to check the environment.
   *
   * @param output the output to parse
   *
   * @return the {@link SGAInfo} containing the environment state.
   */
  SGAInfo parseCheckEnvironmentOutput(String output);
}
