/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.jacorb.orb.etf.ConnectionBase;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;

public abstract class StreamConnectionBase
extends ConnectionBase {
    protected InputStream in_stream = null;
    protected OutputStream out_stream = null;

    protected StreamConnectionBase() {
    }

    protected StreamConnectionBase(StreamConnectionBase other) {
        super(other);
        this.in_stream = other.in_stream;
        this.out_stream = other.out_stream;
    }

    public int read(BufferHolder data, int offset, int min_length, int max_length, long time_out) {
        int read;
        int n;
        for (read = 0; read < min_length; read += n) {
            n = 0;
            try {
                n = this.in_stream.read(data.value, offset + read, max_length - read);
            }
            catch (InterruptedIOException e) {
                int soTimeout = this.getTimeout();
                if (soTimeout != 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Socket timeout (timeout period: " + soTimeout + ")");
                    }
                    throw new TIMEOUT();
                }
                throw new TRANSIENT("Interrupted I/O: " + e);
            }
            catch (IOException se) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Transport to " + this.connection_info + ": stream closed " + se.getMessage());
                }
                throw this.handleCommFailure(se);
            }
            if (n >= 0) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Transport to " + this.connection_info + ": stream closed on read  < 0");
            }
            throw new COMM_FAILURE("read() did not return any data");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("read {} bytes from {}", (Object)read, (Object)this.connection_info);
        }
        return read;
    }

    public void write(boolean is_first, boolean is_last, byte[] data, int offset, int length, long time_out) {
        try {
            this.out_stream.write(data, offset, length);
            if (this.b_out != null) {
                this.b_out.write(data, offset, length);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("wrote {} bytes to {}", (Object)length, (Object)this.connection_info);
            }
        }
        catch (IOException ex) {
            throw this.handleCommFailure(ex);
        }
    }

    public void flush() {
        try {
            if (this.b_out != null) {
                if (this.logger.isInfoEnabled()) {
                    byte[] buffer = this.b_out.toByteArray();
                    this.logger.info("sendMessages(): " + ObjectUtil.bufToString(buffer, 0, buffer.length));
                }
                this.b_out.reset();
            }
            this.out_stream.flush();
        }
        catch (IOException ex) {
            throw this.handleCommFailure(ex);
        }
    }

    public boolean is_data_available() {
        try {
            return this.in_stream.available() > 0;
        }
        catch (IOException ex) {
            throw this.handleCommFailure(ex);
        }
    }

    public abstract boolean isSSL();
}

