/*
 * Detalhes da ltima alterao:
 * 
 * $Author$ $Date$ $Revision$
 */
package tecgraf.ftc_1_2.server.states;

import tecgraf.ftc_1_2.server.Session;

/**
 * Representa o estado relativo a uma operao num servidor de arquivos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface State {
  /**
   * Chamado quando um cliente est tentando enviar dados para o estado.
   * 
   * @param session A sesso de execuo da operao.
   * 
   * @return {@code true} caso a operao tenha sido executada com sucesso, ou
   *         {@code false}, caso contrrio.
   */
  boolean read(Session session);

  /**
   * Chamado quando um cliente est tentando receber dados do estado.
   * 
   * @param session A sesso de execuo da operao.
   * 
   * @return {@code true} caso a operao tenha sido executada com sucesso, ou
   *         {@code false}, caso contrrio.
   */
  boolean write(Session session);
}
