/*
 * Detalhes da ltima alterao:
 * 
 * $Author$ $Date$ $Revision$
 */
package tecgraf.ftc_1_2.server.states.v1_1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

import tecgraf.ftc_1_2.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_2.server.Session;
import tecgraf.ftc_1_2.server.states.State;

/**
 * Operao de obteno da posio atual do arquivo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class GetPositionState implements State {
  /**
   * Representa os estados internos desta operao.
   * 
   * @author Tecgraf/PUC-Rio
   */
  private enum InternalState {
    /**
     * O estado inicial.
     */
    INITIAL,
    /**
     * Estado que indica que a posio do arquivo j foi lida.
     */
    POSITION_READ,
    /**
     * Estado que indica que a posio do arquivo j foi enviada.
     */
    POSITION_WRITTEN;
  }

  /**
   * O estado atual da operao.
   */
  private InternalState currentState;

  /**
   * A posio do arquivo.
   */
  private long position;

  /**
   * Objeto responsvel por registrar as atividades do servidor.
   */
  private final static Logger logger = Logger.getLogger("tecgraf.ftc");

  /**
   * Cria a operao de obteno da posio atual do arquivo.
   */
  public GetPositionState() {
    this.currentState = InternalState.INITIAL;

    if (logger.isLoggable(Level.FINER))
      logger.finer("Estado de obteno de posio.");
  }

  /**
   * {@inheritDoc}
   */
  public boolean read(Session session) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  public boolean write(Session session) {
    ByteBuffer buffer = session.getBuffer();
    SocketChannel channel = session.getChannel();
    switch (this.currentState) {
      case INITIAL:
        //TODO: retornar codigo de retorno ok.
        FileChannel fileChannel = session.getFileChannel();
        try {
          this.position = fileChannel.position();
        }
        catch (IOException e) {
          this.position = -1;
          e.printStackTrace();
        }
        this.currentState = InternalState.POSITION_READ;
      case POSITION_READ:

        if (logger.isLoggable(Level.FINER))
          logger.finer("Enviando a posio do arquivo " + this.position);

        buffer.limit(PrimitiveTypeSize.LONG.getSize());
        buffer.putLong(this.position);
        buffer.flip();
        try {
          if (channel.write(buffer) > 0)
            session.markLastActivity();
        }
        catch (IOException e) {
          e.printStackTrace();
          return false;
        }
        buffer.clear();
        this.currentState = InternalState.POSITION_WRITTEN;
        session.setCurrentState(new GetOperationState());
      default:
        return true;
    }
  }
}
