/*
 * Detalhes da ltima alterao:
 * 
 * $Author$ $Date$ $Revision$
 */
package tecgraf.ftc_1_4.client;

import java.io.FileNotFoundException;

import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.FailureException;
import tecgraf.ftc_1_4.common.exception.InvalidProtocolVersionException;
import tecgraf.ftc_1_4.common.exception.MaxClientsReachedException;
import tecgraf.ftc_1_4.common.exception.PermissionException;

/**
 * Representa um canal de acesso a um arquivo remoto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface IRemoteDataChannel extends IDataChannel {
  /**
   * Solicita a abertura do arquivo.
   * 
   * 
   * @throws PermissionException Caso o usurio no tenha permisso para
   *         realizar o modo de abertura solicitado.
   * @throws FileNotFoundException Caso o arquivo no exista.
   * @throws FailureException Caso ocorra alguma falha no procedimento.
   * @throws MaxClientsReachedException Caso o servidor no possa mais receber
   *         clientes.
   * @throws InvalidProtocolVersionException Caso o servidor no suporte a
   *         verso do protocolo utilizada pelo cliente.
   */
  void open() throws PermissionException, FileNotFoundException,
    FailureException, MaxClientsReachedException,
    InvalidProtocolVersionException;

  /**
   * Operao que faz um poll no servidor com o intuito de manter a conexao
   * ativa
   * 
   * @throws FailureException Caso ocorra alguma falha na operao.
   */
  void keepAlive() throws FailureException;

}
