package tecgraf.ftc_1_4.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

import tecgraf.ftc_1_4.common.exception.DataChannelException;

/**
 * Classe wrapper para utilizar um IDataChannel como InputStream
 * 
 * @author Tecgraf
 */

public class DataChannelInputStream extends InputStream {

  /** Canal de dados que sera utilizado como fonte dos dados */
  private IDataChannel channel;

  /**
   * Construtor
   * 
   * @param channel canal de dados
   */
  public DataChannelInputStream(IDataChannel channel) {
    super();

    if (channel == null) {
      throw new NullPointerException();
    }

    this.channel = channel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void close() throws IOException {
    channel.close();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int read() throws IOException {
    byte array[] = { 0 };
    int ret = read(array);
    if (ret == 1) {
      return array[0];
    }
    return -1;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int read(byte[] b) throws IOException {
    return read(b, 0, b.length);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int read(byte[] b, int off, int len) throws IOException {
    try {
      ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
      return channel.read(buffer);
    }
    catch (DataChannelException e) {
      throw new IOException(e);
    }
  }

}
