package tecgraf.ftc_1_4.common;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

import tecgraf.ftc_1_4.common.exception.DataChannelException;

/**
 * Classe wrapper para utilizar um IDataChannel como OutputStream
 * 
 * @author Tecgraf
 */
public class DataChannelOutputStream extends OutputStream {

  /** Canal de dados que sera utilizado como destino dos dados */
  private IDataChannel channel;

  /**
   * @param channel
   */
  public DataChannelOutputStream(IDataChannel channel) {
    super();

    if (channel == null) {
      throw new NullPointerException();
    }

    this.channel = channel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void close() throws IOException {
    getChannel().close();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(int b) throws IOException {
    byte newb = (byte) b;
    write(new byte[] { newb });
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(byte[] b) throws IOException {
    write(b, 0, b.length);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(byte[] b, int off, int len) throws IOException {
    try {
      ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
      getChannel().write(buffer);
    }
    catch (DataChannelException e) {
      throw new IOException(e);
    }
  }

  /**
   * @return O canal associado a essa OutputStream
   */
  public IDataChannel getChannel() {
    return channel;
  }

}
