/*
 * Detalhes da ltima alterao:
 * 
 * $Author$ $Date$ $Revision$
 */
package tecgraf.ftc_1_4.common.logic;

/**
 * Representa os cdigos de erros que podem ser gerados por operaes (
 * {@link Operation}).
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum ErrorCode {
  /**
   * Indica que uma operao foi realizada com sucesso.
   */
  OK((byte) 0),
  /**
   * Indica que uma operao falhou.
   */
  FAILURE((byte) -1),
  /**
   * Indica que uma chave invlida foi utilizada.
   */
  INVALID_KEY((byte) -2),
  /**
   * Indica que um arquivo solicitado no existe.
   */
  FILE_NOT_FOUND((byte) -3),
  /**
   * Indica falta de permisso para a realizao de uma operao.
   */
  NO_PERMISSION((byte) -4),
  /**
   * Indica que no  possvel escrever num arquivo porque o arquivo possui um
   * <i>lock</i> associado.
   */
  FILE_LOCKED((byte) -5),
  /**
   * Indica que o numero maximo de clientes no servidor foi atingido.
   */
  MAX_CLIENTS_REACHED((byte) -6),
  /**
   * Indica que o arquivo no esta aberto.
   */
  FILE_NOT_OPEN((byte) -7),
  /**
   * Indica que no  possvel escrever num arquivo porque este esta aberto
   * somente para leitura.
   */
  READ_ONLY((byte) -8),
  /**
   * Indica que a verso do protocolo utilizada pelo cliente nao  suportada
   * pelo servidor
   */
  INVALID_VERSION((byte) -9),
  /**
   * Indica final de arquivo
   */
  END_OF_FILE((byte) -10),
  /**
   * Indica operao nao suportada.
   */
  UNSUPPORTED_OPERATION((byte) -11),
  /**
   * Indica rrro desconhecido.
   */
  UNKNOWN_ERROR((byte) -12),
  /**
   * Indica rrro desconhecido.
   */
  INVALID_PROTOCOL_MESSAGE((byte) -13);

  /**
   * O cdigo do cdigo de erro.
   */
  private byte code;

  /**
   * Cria um cdigo de erro com um cdigo associado.
   * 
   * @param code O cdigo do cdigo de erro.
   */
  private ErrorCode(byte code) {
    this.code = code;
  }

  /**
   * Obtm o cdigo do cdigo de erro.
   * 
   * @return O cdigo do cdigo de erro.
   */
  public byte getCode() {
    return this.code;
  }

  /**
   * Obtm um cdigo de erro a partir de seu cdigo.
   * 
   * @param code O cdigo.
   * 
   * @return O cdigo de erro, ou {@code null}, caso o cdigo no corresponda a
   *         nenhum cdigo de erro.
   */
  public static ErrorCode valueOf(byte code) {
    for (ErrorCode errorCode : ErrorCode.values()) {
      if (errorCode.code == code) {
        return errorCode;
      }
    }
    return null;
  }
}
