package tecgraf.ftc_1_4.common.logic;

/**
 * Classe que representa uma mensagem de retorno enviada para o cliente
 */
public class ResultMessage {

  /**
   * Constante enviada para o cliente que informa sucesso
   */
  static public final byte SUCCESS = 0x00;

  /**
   * Constante enviada para o cliente que informa falha
   */
  static public final byte FAILURE = 0x01;

  /**
   * Informa se a mensagem de retorno  sucesso ou falha 
   */
  public Boolean success = false;
  
  /**
   * Cdigo de erro
   */
  public ErrorCode code = ErrorCode.FAILURE;
  
  /**
   * Mensagem de erro quando existir
   */
  public String message = null;

  @Override
  public String toString() {
    StringBuilder resultMessage = new StringBuilder();
    if (success)
      resultMessage.append("SUCCESS");
    else {
      resultMessage.append("FAILURE code: ");
      resultMessage.append(code);
      if (message != null) {
        resultMessage.append(" message: ");
        resultMessage.append(message);
      }
    }

    return resultMessage.toString();
  }
}
