/*
 * $Id$
 */
package tecgraf.ftc_1_4.server;

import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.FailureException;
import tecgraf.ftc_1_4.common.exception.PermissionException;

/**
 * O dono do servidor de arquivos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface DataChannelProvider {
  /**
   * Cria um canal para um arquivo.
   * 
   * @param requester O responsvel pela requisio do canal.
   * @param fileId O identificador do arquivo.
   * @param readOnly Indica se o canal ser somente para leitura ou no.
   * 
   * @return O canal para o arquivo, ou {@code null}, caso o arquivo no exista.
   * 
   * @throws PermissionException Caso o usurio no tenha permisso para obter o
   *         arquivo solicitado.
   * @throws FailureException Caso ocorra alguma falha no procedimento.
   */
  IDataChannel createFileChannel(Object requester, byte[] fileId,
    boolean readOnly) throws PermissionException, FailureException;

  /**
   * Verifica se o arquivo possui um <i>lock</i> que impede a escrita.
   * 
   * @param requester O responsvel pela requisio do canal.
   * @param fileId O identificador do arquivo.
   * 
   * @return {@code true} caso exista um <i>lock</i> associado ao arquivo, ou
   *         {@code false}, caso contrrio.
   */
  boolean isLocked(Object requester, byte[] fileId);

  /**
   * Indica que um canal para um arquivo foi fechado.
   * 
   * @param requester O responsvel pela requisio do canal.
   * @param fileId O identificador do arquivo.
   * @param reason A razo do fechamento do arquivo.
   */
  void fileChannelClosed(Object requester, byte[] fileId,
    ChannelClosedReason reason);
}
