package tecgraf.ftc_1_4.server;

import static tecgraf.ftc_1_4.server.ErrorMessages.SOME_ERROR_OCCURRED;
import static tecgraf.ftc_1_4.server.ErrorMessages.SOME_ERROR_OCCURRED_FILE_ID;
import static tecgraf.ftc_1_4.server.ErrorMessages.hexString;

/**
 * Classe que implementa um handler padrao de excees para o servidor de
 * arquivos
 * 
 * @author Tecgraf
 */
public class DefaultFileServerExceptionHandler implements
  FileServerExceptionHandler {

  /**
   * {@inheritDoc}
   */
  @Override
  public void exceptionRaised(Exception e, byte[] fileId) {
    System.err.println(String.format(SOME_ERROR_OCCURRED_FILE_ID, hexString(fileId)));
    e.printStackTrace();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void exceptionRaised(Exception e) {
    System.err.println(SOME_ERROR_OCCURRED);
    e.printStackTrace();
  }
}
