package tecgraf.ftc_1_4.server;

import java.util.Formatter;

public class ErrorMessages {

  private static final String SUFFIX_RESULT_BUFFERED =  "result (%s) written into buffer to connection %s";
  private static final String SUFFIX_RESULT_SENT =  "result (%s) sent successfully to %s";
  private static final String SUFFIX_RECEIVED =  "received successfully from %s";

  /* states error messages */
  public static final String CLOSE_DATA_CHANNEL_RESULT_BUFFERED = "Close data channel " + SUFFIX_RESULT_BUFFERED;
  public static final String CLOSE_DATA_CHANNEL_RESULT_SENT_SUCCESSFULLY = "Close data channel " + SUFFIX_RESULT_SENT;
  public static final String VERSION_HANDSHAKE_RESULT_BUFFERED = "Version handshake " + SUFFIX_RESULT_BUFFERED;
  public static final String VERSION_HANDSHAKE_RESULT_SENT = "Version handshake " + SUFFIX_RESULT_SENT;
  public static final String OPERATION_VALIDATE_RESULT_BUFFERED = "Validate key " + SUFFIX_RESULT_BUFFERED;
  public static final String OPERATION_VALIDATE_RESULT_SENT = "Validate key " + SUFFIX_RESULT_SENT;
  public static final String OPERATION_KEY_SIZE_RECEIVED = "Access key received from connection %s is %d bytes length";
  public static final String OPERATION_OPEN_OLD_FILE_ID_LENGTH_RECEIVED = "File id length %d " + SUFFIX_RECEIVED;
  public static final String OPERATION_OPEN_OLD_FILE_ID_ARRAY_RECEIVED = "File id array %s " + SUFFIX_RECEIVED;
  public static final String OPERATION_OPEN_RESULT_BUFFERED = "Open operation " + SUFFIX_RESULT_BUFFERED;
  public static final String OPERATION_OPEN_RESULT_SENT_SUCCESSFULLY = "Open operation " + SUFFIX_RESULT_SENT;
  public static final String OPERATION_READ_START_POSITION = "Read operation of connection %s starts at position %d";
  public static final String OPERATION_READ_COUNT_REQUESTED = "Read operation of connection %s requested %d bytes";
  public static final String OPERATION_READ_RESULT_BUFFERED = "Read operation " + SUFFIX_RESULT_BUFFERED;
  public static final String OPERATION_READ_RESULT_SENT = "Read operation " + SUFFIX_RESULT_SENT;
  public static final String OPERATION_READ_CHUNK_SIZE = "Read operation using chunk size of %d bytes to send data to connection %s";
  public static final String OPERATION_READ_USING_TRANSFER_TO = "Read operation using transferTo for connection %s";
  public static final String OPERATION_READ_STATS = "Read operation statistics of connection %s: %d bytes written, %d bytes sent and %d total expected";
  public static final String OPERATION_WRITE_RESULT_BUFFERED = "Write operation " + SUFFIX_RESULT_BUFFERED;
  public static final String OPERATION_WRITE_RESULT_SENT = "Write operation " + SUFFIX_RESULT_SENT;
  public static final String OPERATION_WRITE_STATS = "Write operation statistics of connection %s: %d bytes read, %d bytes received and %d total expected";
  public static final String OPERATION_WRITE_USING_TRANSFER_FROM = "Write operation using transferFrom for connection %s";
  public static final String OPERATION_GET_SIZE_RESULT_BUFFERED = "Get size operation " + SUFFIX_RESULT_BUFFERED;
  public static final String OPERATION_GET_SIZE_RESULT_SENT = "Get size operation " + SUFFIX_RESULT_SENT;
  public static final String OPERATION_SET_SIZE_RECEIVED = "Set size operation (value: %d) " + SUFFIX_RECEIVED;
  public static final String OPERATION_SET_SIZE_RESULT_BUFFERED = "Set size operation " + SUFFIX_RESULT_BUFFERED;
  public static final String OPERATION_SET_SIZE_RESULT_SENT = "Set size operation " + SUFFIX_RESULT_SENT;
  public static final String OPERATION_GET_POSITION_RESULT_BUFFERED = "Get position operation " + SUFFIX_RESULT_BUFFERED;
  public static final String OPERATION_GET_POSITION_RESULT_SENT = "Get position operation " + SUFFIX_RESULT_SENT;
  public static final String OPERATION_SET_POSITION_RECEIVED = "Set position operation (value: %d) " + SUFFIX_RECEIVED;
  public static final String OPERATION_SET_POSITION_RESULT_BUFFERED = "Set position operation " + SUFFIX_RESULT_BUFFERED;
  public static final String OPERATION_SET_POSITION_RESULT_SENT = "Set position operation " + SUFFIX_RESULT_SENT;
  public static final String OPERATION_KEEP_ALIVE_RESULT_BUFFERED = "Keep alive operation " + SUFFIX_RESULT_BUFFERED;
  public static final String OPERATION_KEEP_ALIVE_RESULT_SENT = "Keep alive operation " + SUFFIX_RESULT_SENT;

  public static final String FAILED_TO_READ_DATA_CHANNEL_POSITION = "Failed to retrieve data channel position (connection %s) for fileId %s";
  public static final String FAILED_TO_SET_DATA_CHANNEL_POSITION = "Failed to change data channel position (connection %s) for fileId %s";
  public static final String FAILED_TO_READ_DATA_CHANNEL_SIZE = "Failed to retrieve data channel size (connection %s) for fileId %s";
  public static final String FAILED_TO_SET_DATA_CHANNEL_SIZE = "Failed to change data channel size (connection %s) for fileId %s";
  public static final String DATA_CHANNEL_DOESNT_SUPPORT_GET_POSITION = "GET_POSITION operation requested by %s is not supported on data channel for fileId %s";
  public static final String DATA_CHANNEL_DOESNT_SUPPORT_SET_POSITION = "SET_POSITION operation requested by %s is not supported on data channel for fileId %s";
  public static final String DATA_CHANNEL_DOESNT_SUPPORT_GET_SIZE = "GET_SIZE operation requested by %s is not supported on data channel for fileId %s";
  public static final String DATA_CHANNEL_DOESNT_SUPPORT_SET_SIZE = "SET_SIZE operation requested by %s is not supported on data channel for fileId %s";
  public static final String INVALID_PROTOCOL_OPERATION = "Invalid operation with code %d requested by %s";
  public static final String PROTOCOL_OPERATION_REQUESTED = "Operation %s requested by %s";
  public static final String DATA_CHANNEL_SUPPORTED_OPERATIONS = "Channel opened by %s has support to the following operations %s";
  public static final String INVALID_PROTOCOL_MESSAGE_RECEIVED = "Invalid protocol message received from connection %s";
  public static final String CONNECTION_IS_USING_PROTOCOL_VERSION = "Client connected %s is using FTC %s protocol";
  public static final String UNSUPPORTED_PROTOCOL_VERSION = "Client connected %s is using an unsupported version (%s) of FTC protocol";
  public static final String REQUEST_NOT_FOUND = "No pending request found at %d timestamp (connection %s) for access key %s";
  public static final String REQUEST_RETRIEVED = "Channel request retrieved at %d timestamp (connection %s) for access key %s";

  /* file server and session error messages */
  public static final String REQUEST_DISCARDED = "Channel request discarded at %d timestamp for access key %s and fileId %s";
  public static final String REQUEST_REGISTERED = "Channel request registered at %d timestamp for access key %s and fileId %s";
  public static final String SERVER_SHUTTING_DOWN_STARTED = "FTC server is shutting down and will close all connections";
  public static final String SERVER_SHUTTING_DOWN_COMPLETED = "FTC server shutdown completed";
  public static final String FAILED_TO_CLOSE_THE_SERVER_SOCKET_SELECTOR = "Failed attempting to close the server socket selector";
  public static final String FAILED_TO_REGISTER_SERVER_SOCKET_SELECTOR = "Failed attempting to register the server socket selector";
  public static final String FAILED_TO_SELECT_FOR_IO_OPERATIONS = "Failed attempting to select sockets ready for I/O operations";
  public static final String REQUEST_DISCARDED_DUE_TO_TIMEOUT = "Channel request for access key %s will be discarded due to timeout of %d miliseconds";
  public static final String CONNECTION_CLOSED_DUE_TO_CLIENT_TIMEOUT = "Connection to %s will be closed due to inactivity timeout of %d miliseconds";
  public static final String CONNECTION_CLOSED_DUE_TO_CHANNEL_ERROR = "Connection to %s will be closed due to channel error in %s";
  public static final String SERVER_STARTUP_COMPLETED = "FTC server listening at %s:%d";
  public static final String FAILED_ACCEPTING_CONNECTION = "Failed accepting connection%s";
  public static final String SERVER_REACHED_MAXIMUM_OF_CLIENTS = "Refusing connection from %s because server reached the maximum of %d clients";
  public static final String CLIENT_CONNECTED_SUCCESSFULLY = "Client connected %s (%d of %d allowed)";
  public static final String NO_RESOURCES_AVAILABLE = "No resources available";
  public static final String DISCARDING_CLIENT_AFTER_FAILURE = "Discarding connection of client %s after server failure";
  public static final String FAILED_DISCARDING_CONNECTION_AFTER_FAILURE = "Failed to close connection %s after server failure";
  public static final String FAILED_DISCARDING_CONNECTION_AFTER_FAILURE_FILE_ID = FAILED_DISCARDING_CONNECTION_AFTER_FAILURE + " for fileId %s";
  public static final String UNEXPECTED_EXCEPTION_DURING_STATE_READ_OPERATION = "Unexpected exception during read operation of %s state (connection %s)";
  public static final String UNEXPECTED_EXCEPTION_DURING_STATE_READ_OPERATION_FILE_ID = UNEXPECTED_EXCEPTION_DURING_STATE_READ_OPERATION + " for fileId %s";
  public static final String UNEXPECTED_EXCEPTION_DURING_STATE_WRITE_OPERATION = "Unexpected exception during write operation of %s state (connection %s)";
  public static final String UNEXPECTED_EXCEPTION_DURING_STATE_WRITE_OPERATION_FILE_ID = UNEXPECTED_EXCEPTION_DURING_STATE_WRITE_OPERATION + " for fileId %s";

  /* default data provider and default exception handler error examples */
  public static final String SOME_ERROR_OCCURRED = "An exception was raised from FTC server";
  public static final String SOME_ERROR_OCCURRED_FILE_ID = SOME_ERROR_OCCURRED + " while providing the fileId %s";
  public static final String FILE_CHANNEL_WAS_CLOSED_FILE_ID = "File channel related to requester %s and id %s was closed with reason %s";

  /* exception and protocol error messages */
  public static final String NO_DATA_CHANNEL_PROVIDED = "No data channel was provided by server for requested fileId";
  public static final String EXCEED_MAXIMUM_LENGTH = "%s length %d exceed the maximum of %d bytes";

  public static String hexString(byte[] byteArray) {
    Formatter formatter = new Formatter();
    for (byte b : byteArray) {
      formatter.format("%02x", b);
    }
    return formatter.toString();
  }
}
