/**
 * $Id$
 */
package tecgraf.ftc_1_4.server;

import java.util.logging.Level;

/**
 * Interface que representa configuraes utilizadas no FileServer.
 * 
 * @author Tecgraf
 */
public interface FileServerConfig {

  /**
   * Retorna O nome do host para o servidor de arquivos.
   * 
   * @return hostName
   */
  String getHostName();

  /**
   * @param hostName O nome do host para o servidor de arquivos.
   */
  void setHostName(String hostName);

  /**
   * Retorna a porta para o servidor de arquivos.
   * 
   * @return port A porta para o servidor de arquivos.
   */
  int getPort();

  /**
   * @param port A porta para o servidor de arquivos. Caso seja {@literal 0},
   *          uma porta disponvel ser obtida.
   */
  void setPort(int port);

  /**
   * Retorna Tempo maximo de espera do metodo select em milisegundos.
   * 
   * @return selectTimeout
   */
  long getSelectTimeout();

  /**
   * @param selectTimeout Tempo maximo de espera do metodo select em
   *          milisegundos.
   */
  void setSelectTimeout(long selectTimeout);

  /**
   * Retorna o timeout para o consumo de uma requisio. Aps a criao de um
   * canal o cliente tem X milisegundos para se conectar ao servidor, apos esse
   * tempo a requisio  removida.
   * 
   * @return selectTimeout
   */
  long getChannelRequestTimeout();

  /**
   * Define o timeout para o consumo de uma requisio. Aps a criao de um
   * canal o cliente tem X milisegundos para se conectar ao servidor, apos esse
   * tempo a requisio  removida.
   * 
   * @param value Tempo maximo que o servidor espera para remover uma channel
   *          nao consumido em milisegundos
   */
  void setChannelRequestTimeout(long value);

  /**
   * Retorna o timeout para conexes com o cliente (em milisegundos)
   * 
   * @return clientTimeout timeout em milisegundos
   */
  long getClientTimeout();

  /**
   * Define o timeout das conexes com o cliente (em milisegundos).
   * 
   * @param clientTimeout timeout em milisegundos
   */
  void setClientTimeout(long clientTimeout);

  /**
   * Retorna O numero maximo de clientes
   * 
   * @return maxClients
   */
  int getMaxClients();

  /**
   * @param maxClients O numero maximo de clientes
   */
  void setMaxClients(int maxClients);

  /**
   * Retorna o nmero maximo de requisicoes por canal que o cdigo cliente da
   * biblioteca pode criar sem que as requisioes sejam consumidas.
   * 
   * @return Numero maximo de requisies.
   */
  int getMaxChannelRequests();

  /**
   * Define o nmero maximo de requisicoes por canal que o cdigo cliente da
   * biblioteca pode criar sem que as requisioes sejam consumidas.
   * 
   * @param maxChannelRequests Nmero maximo de requisioes.
   */
  void setMaxChannelRequests(int maxChannelRequests);

  /**
   * Retorna Tamanho do espao de memoria utilizado na comunicaao com cada
   * cliente.
   * 
   * @return clientBufferSize
   */
  int getClientBufferSize();

  /**
   * @param clientBufferSize Define o tamanho do espao de memoria utilizado na
   *          comunicaao com cada cliente.
   */
  void setClientBufferSize(int clientBufferSize);

  /**
   * Retora o valor da politica de aceitao de novos clientes. True para
   * aceitar o numero maximo de clientes e false para aceitar um cliente por
   * vez.
   * 
   * @return boolean
   */
  boolean acceptMaxPossible();

  /**
   * Define a politica de aceitao de novos clientes. True para aceitar o
   * numero maximo de clientes e false para aceitar um cliente por vez.
   * 
   * @param value
   */
  void setAcceptMaxPossible(boolean value);

  /**
   * Retorna True se o servidor deve executar em modo de teste.
   * 
   * @return testMode
   */
  boolean isTestMode();

  /**
   * Define se o servidor deve executar em modo de teste.
   * 
   * @param testMode
   */
  void setTestMode(boolean testMode);

  /**
   * Define o nvel de logging. O FTC utiliza java.util.logging.
   * 
   * @param loglevel
   */
  @Deprecated
  void setLoglevel(Level loglevel);

  /**
   * Define o nome do arquivo de saida que sera gravado o log. O FTC utiliza
   * java.util.logging.
   * 
   * @param logFileName Nome do arquivo de log
   */
  @Deprecated
  void setOutputLogFilename(String logFileName);

  /**
   * @return O nivel de logging. O FTC utiliza java.util.logging.
   */
  @Deprecated
  Level getLoglevel();

  /**
   * @return O nome do arquivo de saida que sera gravado o log.
   */
  @Deprecated
  String getOutputLogFilename();

  /**
   * Retorna Tamanho dos chunks
   * 
   * @return Chunk size
   */
  int getChunkSize();

  /**
   * @param value Define o tamanho chunk.
   */
  void setChunkSize(int value);
}
