package tecgraf.ftc_1_4.server.states;

import java.io.IOException;

import tecgraf.ftc_1_4.common.exception.DataChannelException;
import tecgraf.ftc_1_4.server.Session;


/**
 * Representa o estado relativo a uma operao num servidor de arquivos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface State {
  /**
   * Chamado quando um cliente est tentando enviar dados para o estado.
   * 
   * @param session A sesso de execuo da operao.
   * 
   * @return {@code true} caso a operao tenha sido executada com sucesso, ou
   *         {@code false}, caso contrrio.
   * @throws IOException em caso de erro de leitura do socket ou escrita no buffer.
   * @throws DataChannelException em caso de outros erros da camada de abstrao do FTC.
   */
  boolean read(Session session) throws IOException, DataChannelException;

  /**
   * Chamado quando um cliente est tentando receber dados do estado.
   * 
   * @param session A sesso de execuo da operao.
   * 
   * @return {@code true} caso a operao tenha sido executada com sucesso, ou
   *         {@code false}, caso contrrio.
   * @throws IOException em caso de erro de escrita do socket ou leitura para o buffer.
   * @throws DataChannelException em caso de outros erros da camada de abstrao do FTC
   */
  boolean write(Session session) throws IOException, DataChannelException;

  /**
   * Indica se o estado esta interessado em eventos de escrita desse canal.
   * 
   * @return true se estiver interessado.
   */
  boolean isWriting();
}
