package tecgraf.ftc_1_4.server.states;

import java.nio.ByteBuffer;

import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;

public class StateUtil {
  public static void writeResultMessage(ByteBuffer buffer,
      ResultMessage rMessage) {
    buffer.clear();
    if (rMessage.success) {
      buffer.limit(PrimitiveTypeSize.BYTE.getSize());
      buffer.put(ResultMessage.SUCCESS);
    } else {
      if ((rMessage.message == null) || (rMessage.message.isEmpty())) {
        buffer.limit(PrimitiveTypeSize.BYTE.getSize()
            + PrimitiveTypeSize.BYTE.getSize()
            + PrimitiveTypeSize.SHORT.getSize());
        buffer.put(ResultMessage.FAILURE);
        buffer.put(rMessage.code.getCode());
        buffer.putShort((short) 0);
      } else {
        buffer.limit(PrimitiveTypeSize.BYTE.getSize()
            + PrimitiveTypeSize.BYTE.getSize()
            + PrimitiveTypeSize.SHORT.getSize() + rMessage.message.length());
        buffer.put(ResultMessage.FAILURE);
        buffer.put(rMessage.code.getCode());

        // char -> unsigned 16 bit
        char msg_len = rMessage.message.length() > 0xFFFF ? (char) 0xFFFF
            : (char) (rMessage.message.length() & 0xFFFF);
        buffer.putChar(msg_len);
        buffer.put(rMessage.message.getBytes(), 0, msg_len);
      }
    }
  }
}
