package tecgraf.ftc_1_4.server.states;

/**
 * Protocolos suportados por esta versao do servidor
 * 
 * @author Tecgraf
 */
public enum SupportedProtocols {

  V1_1((byte) 1),
  V1_2((byte) 2),
  // Nao existiu V1_3
  V1_4((byte) 4);

  /**
   * O cdigo do protocolo.
   */
  private byte code;

  /**
   * Cria um protocolo com um cdigo associado.
   * 
   * @param code O cdigo do protocolo.
   */
  private SupportedProtocols(byte code) {
    this.code = code;
  }

  /**
   * Obtm o cdigo do protocolo.
   * 
   * @return O cdigo do protocolo.
   */
  public byte getCode() {
    return this.code;
  }

  /**
   * Obtm um protocolo a partir de seu cdigo.
   * 
   * @param code O cdigo.
   * 
   * @return O protocolo, ou {@code null}, caso o cdigo no corresponda a
   *         nenhum protocolo.
   */
  public static SupportedProtocols valueOf(byte code) {
    for (SupportedProtocols protocol : SupportedProtocols.values()) {
      if (protocol.code == code) {
        return protocol;
      }
    }
    return null;
  }

}
