/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Formatter;
import tecgraf.ftc_1_4.client.IRemoteDataChannel;
import tecgraf.ftc_1_4.common.exception.DataChannelException;
import tecgraf.ftc_1_4.common.exception.FailureException;
import tecgraf.ftc_1_4.common.exception.FileLockedException;
import tecgraf.ftc_1_4.common.exception.InvalidProtocolVersionException;
import tecgraf.ftc_1_4.common.exception.MaxClientsReachedException;
import tecgraf.ftc_1_4.common.exception.PermissionException;
import tecgraf.ftc_1_4.common.exception.UnexpectedProtocolMessage;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.Operation;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.ErrorMessages;
import tecgraf.ftc_1_4.utils.ByteBufferUtils;

public final class RemoteDataChannel
implements IRemoteDataChannel {
    public static final int MAX_IDENTIFIER_SIZE = 65535;
    public static final int MAX_KEY_SIZE = 255;
    public static final int MIN_BUFFER_SIZE = 65535;
    private static final String REMOTE_DATA_CHANNEL_CLOSED = "Remote file data channel closed";
    private static final String FAILED_TO_CLOSE_REMOTE_DATA_CHANNEL = "Failed to close remote file data channel";
    private static final String READ_ONLY_DATA_CHANNEL = "Remote data channel is read-only";
    private static final String NO_PERMISSION_ON_DATA_CHANNEL = "Remote data channel access denied (reason: %s)";
    private static final String DATA_CHANNEL_ALREADY_OPENED = "Remote data channel is already opened";
    private static final String DATA_CHANNEL_ALREADY_LOCKED = "Remote data channel is already locked";
    private static final String UNABLE_TO_RESOLVE_REMOTE_ADDRESS = "Unable to resolve remote address %s";
    private static final String INVALID_ERROR_CODE = "Invalid error code %d returned by server";
    private static final String INVALID_ACCESS_KEY_ERROR_CODE = "Access denied due to invalid access key %s (reason: %s)";
    private static final String SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL = "Server failure %s (reason: %s)";
    private static final String SERVER_REPORTED_INVALID_VERSION = "Server reported invalid protocol version %s";
    private static final String EARLIER_EOS = "earlier end of stream";
    private static final String ILLEGAL_REMOTE_POSITION = "Remote position must be greater or equal to -1: ";
    private static final String ILLEGAL_NEGATIVE_NUMBER = "%s must be a non negative number: %d";
    private static final String ILLEGAL_NULL_VALUE = "%s must be not null";
    private String host;
    private int port;
    private byte[] key;
    private boolean writable;
    private SocketChannel channel;
    private ByteBuffer buffer;
    private int bufferSize = 0x100000;
    private ResultMessage lastResultMessage;
    private short operations = 0;

    public RemoteDataChannel(boolean writable, String host, int port, byte[] key) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Host must be a non empty string");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port number out of range 0 and 65535");
        }
        if (key == null || key.length == 0 || key.length > 255) {
            throw new IllegalArgumentException("Access key must be a non empty array with maximum length 255");
        }
        this.host = host;
        this.port = port;
        this.key = key;
        this.writable = writable;
    }

    @Override
    public void open() throws PermissionException, FileNotFoundException, FailureException, MaxClientsReachedException, InvalidProtocolVersionException {
        if (this.isOpen()) {
            throw new FailureException(DATA_CHANNEL_ALREADY_OPENED);
        }
        try {
            InetSocketAddress address = new InetSocketAddress(this.host, this.port);
            if (address.isUnresolved()) {
                throw new FailureException(String.format(UNABLE_TO_RESOLVE_REMOTE_ADDRESS, address));
            }
            this.channel = SocketChannel.open(address);
            this.channel.socket().setTcpNoDelay(true);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        this.buffer = ByteBuffer.allocate(this.bufferSize);
        this.protocolVersionHandshake();
        this.authenticate();
        ResultMessage retMesg = null;
        try {
            Operation operation = this.writable ? Operation.OPEN_READ_WRITE : Operation.OPEN_READ_ONLY;
            this.buffer.clear();
            ByteBufferUtils.writeByte(this.buffer, this.channel, operation.getCode());
            retMesg = this.readResultMessage();
            if (retMesg.success.booleanValue()) {
                this.operations = ByteBufferUtils.readShort(this.buffer, this.channel);
            }
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
        if (!retMesg.success.booleanValue()) {
            this.release();
            if (retMesg.code.equals((Object)ErrorCode.FILE_NOT_FOUND)) {
                throw new FileNotFoundException(retMesg.message);
            }
            if (retMesg.code.equals((Object)ErrorCode.NO_PERMISSION)) {
                throw new PermissionException(String.format(NO_PERMISSION_ON_DATA_CHANNEL, retMesg.message));
            }
            if (retMesg.code.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "opening data channel", retMesg.message));
            }
            throw new IllegalStateException(String.format(INVALID_ERROR_CODE, new Object[]{retMesg.code}));
        }
    }

    private String currentProtocolVersion() {
        StringBuilder builder = new StringBuilder();
        builder.append("Protocol ID:");
        builder.append(new Formatter().format("%X", 4609091));
        builder.append(1);
        builder.append(".");
        builder.append(4);
        builder.append(".");
        builder.append(0);
        return builder.toString();
    }

    private void protocolVersionHandshake() throws FailureException, PermissionException, MaxClientsReachedException, InvalidProtocolVersionException {
        long idAndVersion = 4609091L;
        idAndVersion <<= 32;
        int major = 1;
        int minor = 4;
        int patch = 0;
        idAndVersion |= (long)(major << 16 | minor << 8 | patch);
        ResultMessage retMesg = null;
        try {
            this.buffer.clear();
            ByteBufferUtils.writeLong(this.buffer, this.channel, idAndVersion);
            retMesg = this.readResultMessage();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
        if (!retMesg.success.booleanValue()) {
            this.release();
            if (retMesg.code.equals((Object)ErrorCode.INVALID_VERSION)) {
                throw new InvalidProtocolVersionException(String.format(SERVER_REPORTED_INVALID_VERSION, this.currentProtocolVersion()));
            }
            if (retMesg.code.equals((Object)ErrorCode.MAX_CLIENTS_REACHED)) {
                throw new MaxClientsReachedException(String.format(NO_PERMISSION_ON_DATA_CHANNEL, "max clients reached"));
            }
            if (retMesg.code.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "negotiating protocol version", retMesg.message));
            }
            throw new IllegalStateException(String.format(INVALID_ERROR_CODE, new Object[]{retMesg.code}));
        }
    }

    private void authenticate() throws FailureException, PermissionException, MaxClientsReachedException {
        ResultMessage retMesg = null;
        try {
            this.buffer.clear();
            ByteBufferUtils.writeBytesByteSize(this.buffer, this.channel, this.key);
            retMesg = this.readResultMessage();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
        if (!retMesg.success.booleanValue()) {
            this.release();
            if (retMesg.code.equals((Object)ErrorCode.INVALID_KEY)) {
                throw new PermissionException(String.format(INVALID_ACCESS_KEY_ERROR_CODE, ErrorMessages.hexString(this.key), retMesg.message));
            }
            if (retMesg.code.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "validating the access key", retMesg.message));
            }
            throw new IllegalStateException(String.format(INVALID_ERROR_CODE, new Object[]{retMesg.code}));
        }
    }

    @Override
    public boolean isOpen() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.checkIsOpen();
        ResultMessage retMesg = null;
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.CLOSE.getCode());
            retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                throw new IOException(FAILED_TO_CLOSE_REMOTE_DATA_CHANNEL);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (UnexpectedProtocolMessage e) {
            throw new IOException(e);
        }
        finally {
            this.release();
        }
    }

    private ResultMessage readResultMessage() throws IOException, UnexpectedProtocolMessage {
        this.lastResultMessage = new ResultMessage();
        this.buffer.clear();
        this.buffer.limit(PrimitiveTypeSize.BYTE.getSize());
        do {
            if (this.channel.read(this.buffer) != -1) continue;
            throw new IOException(REMOTE_DATA_CHANNEL_CLOSED);
        } while (this.buffer.hasRemaining());
        this.buffer.flip();
        byte result = this.buffer.get();
        this.buffer.clear();
        if (result != 1 && result != 0) {
            throw new UnexpectedProtocolMessage(String.format(INVALID_ERROR_CODE, result));
        }
        this.lastResultMessage.success = result == 0;
        if (this.lastResultMessage.success.booleanValue()) {
            return this.lastResultMessage;
        }
        this.buffer.limit(PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.SHORT.getSize());
        do {
            if (this.channel.read(this.buffer) != -1) continue;
            throw new IOException(REMOTE_DATA_CHANNEL_CLOSED);
        } while (this.buffer.hasRemaining());
        this.buffer.flip();
        byte code = this.buffer.get();
        char msgSize = this.buffer.getChar();
        this.buffer.clear();
        ErrorCode errorCode = ErrorCode.valueOf(code);
        ErrorCode errorCode2 = this.lastResultMessage.code = errorCode == null ? ErrorCode.UNKNOWN_ERROR : errorCode;
        if (msgSize <= '\u0000') {
            this.lastResultMessage.message = "";
            return this.lastResultMessage;
        }
        this.buffer.limit(msgSize);
        do {
            if (this.channel.read(this.buffer) != -1) continue;
            throw new IOException(REMOTE_DATA_CHANNEL_CLOSED);
        } while (this.buffer.hasRemaining());
        this.buffer.flip();
        byte[] msgArray = new byte[msgSize];
        this.buffer.get(msgArray);
        this.buffer.clear();
        this.lastResultMessage.message = new String(msgArray);
        return this.lastResultMessage;
    }

    private void release() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.buffer = null;
            this.channel = null;
        }
    }

    @Override
    public void setSize(long size) throws PermissionException, FailureException {
        this.checkIsOpen();
        if (size < 0L) {
            throw new IllegalArgumentException(String.format(ILLEGAL_NEGATIVE_NUMBER, "Size", size));
        }
        if (!this.writable) {
            throw new PermissionException(READ_ONLY_DATA_CHANNEL);
        }
        this.buffer.put(Operation.SET_SIZE.getCode());
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), size);
            ResultMessage retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                switch (retMesg.code) {
                    case UNSUPPORTED_OPERATION: {
                        throw new UnsupportedOperationException();
                    }
                    case READ_ONLY: {
                        throw new PermissionException(READ_ONLY_DATA_CHANNEL);
                    }
                }
                throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "setting size", retMesg.message));
            }
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
    }

    @Override
    public long getPosition() throws FailureException {
        this.checkIsOpen();
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.GET_POSITION.getCode());
            ResultMessage retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                switch (retMesg.code) {
                    case UNSUPPORTED_OPERATION: {
                        throw new UnsupportedOperationException();
                    }
                }
                throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "getting position", retMesg.message));
            }
            long pos = ByteBufferUtils.readLong(this.buffer, this.channel);
            return pos;
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
    }

    @Override
    public void setPosition(long position) throws FailureException {
        this.checkIsOpen();
        if (position < 0L) {
            throw new IllegalArgumentException(ILLEGAL_REMOTE_POSITION + position);
        }
        try {
            this.buffer.put(Operation.SET_POSITION.getCode());
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), position);
            ResultMessage retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                switch (retMesg.code) {
                    case UNSUPPORTED_OPERATION: {
                        throw new UnsupportedOperationException();
                    }
                }
                throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "setting position", retMesg.message));
            }
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
    }

    @Override
    public long getSize() throws FailureException {
        this.checkIsOpen();
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.GET_SIZE.getCode());
            ResultMessage retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                switch (retMesg.code) {
                    case UNSUPPORTED_OPERATION: {
                        throw new UnsupportedOperationException();
                    }
                }
                throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "getting size", retMesg.message));
            }
            long size = ByteBufferUtils.readLong(this.buffer, this.channel);
            return size;
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
    }

    @Override
    public int read(ByteBuffer dest) throws FailureException {
        return this.read(dest, -1L);
    }

    @Override
    public int read(ByteBuffer dest, long remotePosition) throws FailureException {
        this.checkIsOpen();
        if (dest == null) {
            throw new IllegalArgumentException(String.format(ILLEGAL_NULL_VALUE, "Destination byte buffer"));
        }
        if (remotePosition < -1L) {
            throw new IllegalArgumentException(ILLEGAL_REMOTE_POSITION + remotePosition);
        }
        this.buffer.put(Operation.READ.getCode());
        this.buffer.putLong(remotePosition);
        this.buffer.putLong(dest.remaining());
        this.buffer.flip();
        try {
            this.channel.write(this.buffer);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        finally {
            this.buffer.clear();
        }
        int originalLimit = dest.limit();
        int totalBytesRead = 0;
        while (dest.hasRemaining()) {
            try {
                int missingBytes;
                ResultMessage retMesg = this.readResultMessage();
                if (!retMesg.success.booleanValue()) {
                    switch (retMesg.code) {
                        case END_OF_FILE: {
                            if (totalBytesRead == 0) {
                                return -1;
                            }
                            return totalBytesRead;
                        }
                        case UNSUPPORTED_OPERATION: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "reading data", retMesg.message));
                }
                int preChunkSize = ByteBufferUtils.readInt(this.buffer, this.channel);
                long chunkSize = (long)preChunkSize & 0xFFFFFFFFL;
                int limit = chunkSize < (long)(missingBytes = originalLimit - dest.position()) ? (int)chunkSize : missingBytes;
                dest.limit(dest.position() + limit);
                int bytesRead = 0;
                int readCount = 0;
                while ((long)bytesRead < chunkSize) {
                    readCount = this.channel.read(dest);
                    if (readCount < 0) {
                        throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "reading data", EARLIER_EOS));
                    }
                    bytesRead += readCount;
                }
                dest.limit(originalLimit);
                totalBytesRead += bytesRead;
            }
            catch (IOException e) {
                this.release();
                throw new FailureException(e);
            }
            catch (UnexpectedProtocolMessage e) {
                this.release();
                throw new FailureException(e);
            }
        }
        return totalBytesRead;
    }

    @Override
    public int write(ByteBuffer source) throws PermissionException, FailureException, FileLockedException {
        return this.write(source, -1L);
    }

    @Override
    public int write(ByteBuffer source, long remotePosition) throws PermissionException, FailureException, FileLockedException {
        this.checkIsOpen();
        if (source == null) {
            throw new IllegalArgumentException(String.format(ILLEGAL_NULL_VALUE, "Source byte buffer"));
        }
        if (!this.writable) {
            throw new PermissionException(READ_ONLY_DATA_CHANNEL);
        }
        if (remotePosition < -1L) {
            throw new IllegalArgumentException(ILLEGAL_REMOTE_POSITION + remotePosition);
        }
        this.buffer.put(Operation.WRITE.getCode());
        this.buffer.putLong(remotePosition);
        ResultMessage retMesg = null;
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), source.remaining());
            retMesg = this.readResultMessage();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
        if (!retMesg.success.booleanValue()) {
            switch (retMesg.code) {
                case UNSUPPORTED_OPERATION: {
                    throw new UnsupportedOperationException();
                }
                case FILE_LOCKED: {
                    throw new FileLockedException(DATA_CHANNEL_ALREADY_LOCKED);
                }
                case READ_ONLY: {
                    throw new PermissionException(READ_ONLY_DATA_CHANNEL);
                }
            }
            throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "writing data", retMesg.message));
        }
        try {
            return this.channel.write(source);
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
    }

    @Override
    public long transferTo(long remotePosition, long count, WritableByteChannel dest) throws FailureException, IOException {
        this.checkIsOpen();
        if (dest == null) {
            throw new IllegalArgumentException(String.format(ILLEGAL_NULL_VALUE, "Destination byte channel"));
        }
        if (remotePosition < -1L) {
            throw new IllegalArgumentException(ILLEGAL_REMOTE_POSITION + remotePosition);
        }
        if (count < 0L) {
            throw new IllegalArgumentException(String.format(ILLEGAL_NEGATIVE_NUMBER, "Count", count));
        }
        this.buffer.put(Operation.READ.getCode());
        this.buffer.putLong(remotePosition);
        this.buffer.putLong(count);
        this.buffer.flip();
        try {
            this.channel.write(this.buffer);
        }
        catch (IOException e) {
            this.release();
            throw e;
        }
        this.buffer.clear();
        long bytesWrittenTotal = 0L;
        long currentChunkSize = 0L;
        int chunkReadBytes = 0;
        int bytesRead = 0;
        while (bytesWrittenTotal < count) {
            try {
                ResultMessage retMesg = this.readResultMessage();
                if (!retMesg.success.booleanValue()) {
                    switch (retMesg.code) {
                        case END_OF_FILE: {
                            if (bytesWrittenTotal == 0L) {
                                return -1L;
                            }
                            return bytesWrittenTotal;
                        }
                        case UNSUPPORTED_OPERATION: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "reading data", retMesg.message));
                }
                int preChunkSize = ByteBufferUtils.readInt(this.buffer, this.channel);
                currentChunkSize = (long)preChunkSize & 0xFFFFFFFFL;
            }
            catch (IOException e) {
                this.release();
                throw new FailureException(e);
            }
            catch (UnexpectedProtocolMessage e) {
                this.release();
                throw new FailureException(e);
            }
            chunkReadBytes = 0;
            while ((long)chunkReadBytes < currentChunkSize) {
                this.buffer.clear();
                this.buffer.limit((int)(currentChunkSize - (long)chunkReadBytes));
                try {
                    bytesRead = this.channel.read(this.buffer);
                    if (bytesRead < 0) {
                        throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "reading data", EARLIER_EOS));
                    }
                    this.buffer.flip();
                    dest.write(this.buffer);
                }
                catch (IOException e) {
                    this.buffer.clear();
                    throw new FailureException(e);
                }
                bytesWrittenTotal += (long)bytesRead;
                chunkReadBytes += bytesRead;
            }
            this.buffer.clear();
        }
        this.buffer.clear();
        return bytesWrittenTotal;
    }

    @Override
    public long transferFrom(ReadableByteChannel source, long remotePosition, long count) throws IOException, DataChannelException {
        this.checkIsOpen();
        if (!this.writable) {
            throw new PermissionException(READ_ONLY_DATA_CHANNEL);
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format(ILLEGAL_NULL_VALUE, "Source byte channel"));
        }
        if (remotePosition < -1L) {
            throw new IllegalArgumentException(ILLEGAL_REMOTE_POSITION + remotePosition);
        }
        if (count < 0L) {
            throw new IllegalArgumentException(String.format(ILLEGAL_NEGATIVE_NUMBER, "Count", count));
        }
        this.buffer.put(Operation.WRITE.getCode());
        this.buffer.putLong(remotePosition);
        ResultMessage retMesg = null;
        try {
            ByteBufferUtils.writeLong(this.buffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), count);
            retMesg = this.readResultMessage();
        }
        catch (IOException e) {
            this.buffer.clear();
            throw e;
        }
        if (!retMesg.success.booleanValue()) {
            switch (retMesg.code) {
                case FILE_LOCKED: {
                    throw new FileLockedException(DATA_CHANNEL_ALREADY_LOCKED);
                }
                case READ_ONLY: {
                    throw new PermissionException(READ_ONLY_DATA_CHANNEL);
                }
            }
            throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "writing data", retMesg.message));
        }
        long bytesReadTotal = 0L;
        while (bytesReadTotal < count) {
            this.buffer.clear();
            if ((long)this.buffer.limit() > count - bytesReadTotal) {
                this.buffer.limit((int)(count - bytesReadTotal));
            }
            try {
                int bytesRead = source.read(this.buffer);
                if (bytesRead == -1) break;
                bytesReadTotal += (long)bytesRead;
                this.buffer.flip();
                while (this.buffer.hasRemaining()) {
                    if (this.channel.write(this.buffer) >= 0) continue;
                    this.buffer.clear();
                    throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "writing data", EARLIER_EOS));
                }
            }
            catch (IOException e) {
                this.buffer.clear();
                throw e;
            }
        }
        this.buffer.clear();
        return bytesReadTotal;
    }

    @Override
    public void keepAlive() throws FailureException {
        this.checkIsOpen();
        try {
            ByteBufferUtils.writeByte(this.buffer, this.channel, Operation.KEEP_ALIVE.getCode());
            ResultMessage retMesg = this.readResultMessage();
            if (!retMesg.success.booleanValue()) {
                throw new FailureException(String.format(SERVER_FAILURE_OPERATION_ON_DATA_CHANNEL, "sending keep-alive", retMesg.message));
            }
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        catch (UnexpectedProtocolMessage e) {
            this.release();
            throw new FailureException(e);
        }
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize > 65535) {
            this.bufferSize = bufferSize;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public short supportedOperations() {
        return this.operations;
    }

    @Override
    public long remaining() throws IOException, DataChannelException {
        return this.getSize() - this.getPosition();
    }

    @Override
    public long skip(long bytes) throws IOException, DataChannelException {
        this.setPosition(this.getPosition() + bytes);
        return bytes;
    }

    public ResultMessage getLastResultMessage() {
        return this.lastResultMessage;
    }

    private void checkIsOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException(REMOTE_DATA_CHANNEL_CLOSED);
        }
    }
}

