/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.common;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.DataChannelException;

public class DataChannelOutputStream
extends OutputStream {
    private IDataChannel channel;

    public DataChannelOutputStream(IDataChannel channel) {
        if (channel == null) {
            throw new NullPointerException();
        }
        this.channel = channel;
    }

    @Override
    public void close() throws IOException {
        this.getChannel().close();
    }

    @Override
    public void write(int b) throws IOException {
        byte newb = (byte)b;
        this.write(new byte[]{newb});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
            this.getChannel().write(buffer);
        }
        catch (DataChannelException e) {
            throw new IOException(e);
        }
    }

    public IDataChannel getChannel() {
        return this.channel;
    }
}

