/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.DataChannelException;

public class FileDataChannel
implements IDataChannel {
    private FileChannel channel;
    private final short supportedOps = (short)255;

    public FileDataChannel(FileChannel channel) {
        if (channel == null) {
            throw new NullPointerException();
        }
        this.channel = channel;
    }

    @Override
    public short supportedOperations() {
        return 255;
    }

    @Override
    public boolean isOpen() {
        return this.getChannel().isOpen();
    }

    @Override
    public void close() throws IOException {
        this.getChannel().close();
    }

    @Override
    public long remaining() throws IOException, DataChannelException {
        long remaining = this.channel.size() - this.channel.position();
        if (remaining == 0L) {
            return -1L;
        }
        return remaining;
    }

    @Override
    public long skip(long bytes) throws IOException, DataChannelException {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Bytes to skip must be a non negative number: " + bytes);
        }
        long originalPosition = this.channel.position();
        long newPosition = this.channel.position() + bytes;
        if (newPosition > this.channel.size()) {
            newPosition = this.channel.size();
        }
        this.channel.position(newPosition);
        return newPosition - originalPosition;
    }

    @Override
    public long getSize() throws IOException {
        return this.getChannel().size();
    }

    @Override
    public void setSize(long size) throws IOException {
        if (size > this.getChannel().size()) {
            ByteBuffer src = ByteBuffer.wrap(new byte[]{0});
            long currentPosition = this.getChannel().position();
            this.getChannel().position(size - 1L);
            this.getChannel().write(src);
            this.getChannel().position(currentPosition);
        } else {
            this.getChannel().truncate(size);
        }
    }

    @Override
    public long getPosition() throws IOException {
        return this.getChannel().position();
    }

    @Override
    public void setPosition(long position) throws IOException {
        this.getChannel().position(position);
    }

    @Override
    public int read(ByteBuffer target) throws IOException {
        return this.getChannel().read(target);
    }

    @Override
    public int read(ByteBuffer target, long position) throws IOException {
        return this.getChannel().read(target, position);
    }

    @Override
    public int write(ByteBuffer source) throws IOException {
        return this.getChannel().write(source);
    }

    @Override
    public int write(ByteBuffer source, long position) throws IOException {
        return this.getChannel().write(source, position);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel output) throws IOException {
        long currentPos = this.channel.position();
        long readBytes = this.channel.transferTo(position, count, output);
        if (readBytes > 0L) {
            this.channel.position(currentPos + readBytes);
        }
        return readBytes;
    }

    @Override
    public long transferFrom(ReadableByteChannel source, long position, long count) throws IOException {
        if (this.channel.size() < position) {
            this.setSize(position + count - 1L);
        }
        long currentPos = this.channel.position();
        long readBytes = this.channel.transferFrom(source, position, count);
        if (readBytes > 0L) {
            this.channel.position(currentPos + readBytes);
        }
        return readBytes;
    }

    public FileChannel getChannel() {
        return this.channel;
    }
}

