/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.authentication.v1;

import ibase.rest.api.authentication.v1.AuthenticationApiService;
import ibase.rest.api.authentication.v1.NotFoundException;
import ibase.rest.api.authentication.v1.factories.AuthenticationApiServiceFactory;
import ibase.rest.model.authentication.v1.Token;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/authentication")
@Produces(value={"application/json;"})
@Api(description="the authentication API")
public class AuthenticationApi {
    private final AuthenticationApiService delegate = AuthenticationApiServiceFactory.getAuthenticationApi();

    @POST
    @Path(value="/facebook")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Generate an access token for facebook user access", notes="", response=Token.class, tags={"Authentication"})
    @ApiResponses(value={@ApiResponse(code=200, message="A JSON-encoded dictionary including an access token (accessToken), token type (tokenType), and user ID. The token type will always be \"bearer\".", response=Token.class), @ApiResponse(code=400, message="If the facebook access token was not provided (or is empty).", response=Token.class), @ApiResponse(code=401, message="Invalid facebook user token.", response=Token.class)})
    public Response authenticationFacebookPost(@ApiParam(value="the facebook user's token", required=true) @FormParam(value="accessToken") String accessToken, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.authenticationFacebookPost(accessToken, locale, securityContext);
    }

    @POST
    @Path(value="/newpassword/accept")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Replace the current password for a new one.", notes="", response=Token.class, tags={"Authentication"})
    @ApiResponses(value={@ApiResponse(code=200, message="A JSON-encoded dictionary including an access token (accessToken), token type (tokenType), and user ID. The token type will always be \"bearer\".", response=Token.class), @ApiResponse(code=400, message="If the user token was not provided (or is empty) or if there is no user with login provided", response=Token.class), @ApiResponse(code=401, message="Invalid user token.", response=Token.class)})
    public Response authenticationNewpasswordAcceptPost(@ApiParam(value="the user's token sent by the validation process.", required=true) @FormParam(value="userToken") String userToken, @ApiParam(value="The new password to be replaced.", required=true) @FormParam(value="password") String password, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.authenticationNewpasswordAcceptPost(userToken, password, locale, securityContext);
    }

    @POST
    @Path(value="/newpassword/validation")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="A token is created and sent by email, embedded in the url link used to validate the new password.", notes="", response=void.class, tags={"Authentication"})
    @ApiResponses(value={@ApiResponse(code=201, message="A token is created and sent by the email provided", response=void.class), @ApiResponse(code=400, message="If there is no user with login equals the email provided", response=void.class)})
    public Response authenticationNewpasswordValidationPost(@ApiParam(value="The email of the user (used also as the user login).", required=true) @FormParam(value="email") String email, @ApiParam(value="The base URL to be used for build the link sent by email for the validation process", required=true) @FormParam(value="baseURL") String baseURL, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.authenticationNewpasswordValidationPost(email, baseURL, locale, securityContext);
    }

    @POST
    @Path(value="/newuser/accept")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Generate an access token for new user access. The new user is also added to the system, as a guest.", notes="", response=Token.class, tags={"Authentication"})
    @ApiResponses(value={@ApiResponse(code=200, message="A JSON-encoded dictionary including an access token (accessToken), token type (tokenType), and user ID. The token type will always be \"bearer\".", response=Token.class), @ApiResponse(code=400, message="If the access token was not provided (or is empty) or if there is already an user with login provided", response=Token.class), @ApiResponse(code=401, message="Invalid user token.", response=Token.class)})
    public Response authenticationNewuserAcceptPost(@ApiParam(value="the user's token wich embeds the required information to create a new guest user.", required=true) @FormParam(value="userToken") String userToken, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.authenticationNewuserAcceptPost(userToken, locale, securityContext);
    }

    @POST
    @Path(value="/newuser/validation")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Create a token to be used to validate the email provided by the user. The token is sent by email, embedded in the url link used to validate the access.", notes="", response=void.class, tags={"Authentication"})
    @ApiResponses(value={@ApiResponse(code=201, message="A token is created and sent by the email provided", response=void.class), @ApiResponse(code=400, message="If there is already an user with login equals the email provided", response=void.class)})
    public Response authenticationNewuserValidationPost(@ApiParam(value="The name of the user", required=true) @FormParam(value="name") String name, @ApiParam(value="The email of the user. The email is used as the user login.", required=true) @FormParam(value="email") String email, @ApiParam(value="The password of the user.", required=true) @FormParam(value="password") String password, @ApiParam(value="The base URL to be used for build the link sent by email for the validation process", required=true) @FormParam(value="baseURL") String baseURL, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.authenticationNewuserValidationPost(name, email, password, baseURL, locale, securityContext);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Generate an access token for login and password", notes="", response=Token.class, tags={"Authentication"})
    @ApiResponses(value={@ApiResponse(code=200, message="A JSON-encoded dictionary including an access token (accessToken), token type (tokenType), and user ID. The token type will always be \"bearer\".", response=Token.class), @ApiResponse(code=400, message="If login or password are not provided (or are empty values).", response=Token.class), @ApiResponse(code=401, message="Invalid login/password", response=Token.class)})
    public Response authenticationPost(@ApiParam(value="the user's login", required=true) @FormParam(value="login") String login, @ApiParam(value="the user's password", required=true) @FormParam(value="password") String password, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.authenticationPost(login, password, locale, securityContext);
    }
}

