/*
 * Decompiled with CFR 0.152.
 */
package ibase.dao.api.job.v1;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import com.mongodb.event.ServerClosedEvent;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerOpeningEvent;
import ibase.common.ServiceUtil;
import ibase.dao.api.job.v1.MongoJobDAO;
import ibase.rest.api.drmaa2.v1.adapter.JobDAO;
import ibase.rest.api.drmaa2.v1.factories.Drmaa2DAOFactory;
import java.util.Arrays;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class MongoJobDaoFactory
implements Drmaa2DAOFactory {
    public static final String RESOURCE_BUNDLE = "language.MongoJobDaoFactory";
    private static final Logger logger = Logger.getLogger("MongoJobDaoFactory");
    public static final String MONGO_HOST_KEY = "MongoJobDaoFactory.host";
    public static final String MONGO_HOST_DEFAULT = "localhost";
    public static final String MONGO_PORT_KEY = "MongoJobDaoFactory.port";
    public static final int MONGO_PORT_DEFAULT = 27017;
    public static final String MONGO_DB_KEY = "MongoJobDaoFactory.database";
    public static final String MONGO_DB_DEFAULT = "csbase";
    public static final String MONGO_LOCALE_KEY = "MongoJobDaoFactory.locale";
    public static final String MONGO_LOCALE_DEFAULT = "pt_BR";
    public static final String MONGO_DB_USER = "MongoJobDaoFactory.user";
    public static final String MONGO_DB_PASSWORD = "MongoJobDaoFactory.password";
    private String host;
    private Integer port;
    private String database;
    private String user;
    private String password;
    private ResourceBundle bundle;
    private MongoClient mongoClient;
    private MongoDatabase mongoDatabase;
    private MongoStatusListener mongoStatusListener;
    private boolean connected = false;
    private static JobDAO jobDAO;

    public JobDAO getJobDAO() {
        if (!this.connected) {
            this.connectMongo(this.host, this.port, this.database, this.user, this.password);
        }
        if (!this.isAvailable()) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.bundle).message("mongo.not.available", new String[]{this.host, String.valueOf(this.port), this.database, this.user});
            logger.severe(message);
            throw new RuntimeException(message);
        }
        if (jobDAO == null) {
            jobDAO = new MongoJobDAO(this.mongoDatabase);
        }
        return jobDAO;
    }

    public void setProperties(Properties properties) {
        String locale = (String)properties.get(MONGO_LOCALE_KEY);
        if (locale == null) {
            locale = MONGO_LOCALE_DEFAULT;
        }
        this.bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, ServiceUtil.getLocale((String)locale), this.getClass().getClassLoader());
        this.host = (String)properties.get(MONGO_HOST_KEY);
        if (this.host == null) {
            this.host = MONGO_HOST_DEFAULT;
        }
        String mongoPortString = (String)properties.get(MONGO_PORT_KEY);
        this.port = Integer.parseInt(mongoPortString);
        if (this.port == null) {
            this.port = 27017;
        }
        this.database = (String)properties.get(MONGO_DB_KEY);
        if (this.database == null) {
            this.database = MONGO_DB_DEFAULT;
        }
        this.user = (String)properties.get(MONGO_DB_USER);
        if (this.user == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.bundle).message("property.not.defined", new String[]{MONGO_DB_USER});
            logger.severe(message);
            throw new IllegalStateException(message);
        }
        this.password = (String)properties.get(MONGO_DB_PASSWORD);
        if (this.password == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.bundle).message("property.not.defined", new String[]{MONGO_DB_PASSWORD});
            logger.severe(message);
            throw new IllegalStateException(message);
        }
        this.connectMongo(this.host, this.port, this.database, this.user, this.password);
        if (!this.isAvailable()) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.bundle).message("mongo.not.available", new String[]{this.host, String.valueOf(this.port), this.database, this.user});
            logger.severe(message);
            throw new RuntimeException(message);
        }
    }

    private void connectMongo(String host, Integer port, String database, String user, String password) {
        if (this.connected) {
            return;
        }
        MongoClientOptions.Builder optionsBuilder = new MongoClientOptions.Builder();
        this.mongoStatusListener = new MongoStatusListener();
        optionsBuilder.addServerListener((ServerListener)this.mongoStatusListener);
        MongoCredential credential = MongoCredential.createCredential((String)user, (String)database, (char[])password.toCharArray());
        this.mongoClient = new MongoClient(new ServerAddress(host, port.intValue()), Arrays.asList(credential), optionsBuilder.build());
        this.mongoDatabase = this.mongoClient.getDatabase(database);
        String message = ServiceUtil.getTranslator((ResourceBundle)this.bundle).message("mongo.successfully.connected", new String[]{host, String.valueOf(port), database, user});
        logger.info(message);
        this.connected = true;
    }

    public boolean isAvailable() {
        return this.mongoStatusListener.isAvailable();
    }

    class MongoStatusListener
    implements ServerListener {
        private boolean available = false;

        MongoStatusListener() {
        }

        public boolean isAvailable() {
            return this.available;
        }

        public void serverOpening(ServerOpeningEvent event) {
            this.available = true;
        }

        public void serverClosed(ServerClosedEvent event) {
        }

        public void serverDescriptionChanged(ServerDescriptionChangedEvent event) {
            if (event.getNewDescription().isOk()) {
                this.available = true;
            } else if (event.getNewDescription().getException() != null) {
                logger.severe("exception: " + event.getNewDescription().getException().getMessage());
                this.available = false;
            }
        }
    }
}

