/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.adapter.monitor.v1;

import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import ibase.rest.adapter.monitor.v1.FilterByJsonRequirements;
import ibase.rest.api.monitor.v1.adapter.ResourcesServiceAdapter;
import ibase.rest.model.monitor.v1.Resource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;

public class CSBaseResourcesServiceAdapter
implements ResourcesServiceAdapter {
    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public List<Resource> getExecutionResources(String algorithmId, String versionId) {
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        AlgorithmServiceInterface algorithmService = ClientRemoteLocator.algorithmService;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            Set requirements = new HashSet();
            if (algorithmId != null && versionId != null && !versionId.isEmpty() && !algorithmId.isEmpty()) {
                AlgorithmVersionId algoVersionId = AlgorithmVersionId.create((String)versionId);
                AlgorithmConfigurator configurator = algorithmService.createAlgorithmConfigurator(algorithmId, algoVersionId);
                requirements = configurator.getRequirements();
            }
            Vector sgaNames = sgaService.getAllSGANames();
            for (String sgaName : sgaNames) {
                SGASet sga = sgaService.getSGASet(sgaName);
                Resource resource = this.buildResource(sga);
                if (sga == null || !sga.hasRequirements(requirements) || !sga.mayExecuteCommand()) continue;
                resources.add(resource);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resources;
    }

    public List<Resource> getExecutionResources(String requirements) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        try {
            Vector sgaNames = sgaService.getAllSGANames();
            List<SGASet> sgas = new ArrayList<SGASet>();
            for (String sgaName : sgaNames) {
                SGASet sga2 = sgaService.getSGASet(sgaName);
                if (!sga2.mayExecuteCommand()) continue;
                sgas.add(sga2);
            }
            FilterByJsonRequirements filter = new FilterByJsonRequirements(requirements);
            sgas = filter.filter(sgas);
            sgas.stream().forEach(sga -> resources.add(this.buildResource((SGASet)sga)));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resources;
    }

    private Resource buildResource(SGASet sga) {
        Resource resource = new Resource();
        resource.setName(sga.getName());
        return resource;
    }
}

