/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.adapter.monitor.v1;

import csbase.logic.SGASet;
import csbase.logic.sga.filter.SGACriteria;
import csbase.logic.sga.filter.SGACriteriaAnd;
import csbase.logic.sga.filter.SGACriteriaByAvailability;
import csbase.logic.sga.filter.SGACriteriaByMinCPUs;
import csbase.logic.sga.filter.SGACriteriaByMinFreeRAMMem;
import csbase.logic.sga.filter.SGACriteriaByPlatform;
import csbase.logic.sga.filter.SGACriteriaByRequirements;
import csbase.logic.sga.filter.SGACriteriaOr;
import csbase.logic.sga.filter.SGAFilter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;

public class FilterByJsonRequirements {
    private static final String PLATFORMS_KEY = "csbase_platforms";
    private static final String CPU_AMMOUNT_KEY = "csbase_cpu";
    private static final String MEMORY_AMMOUNT_KEY = "csbase_memory";
    private Map<String, Object> requirements = new HashMap<String, Object>();

    public FilterByJsonRequirements(String requirements) {
        if (requirements == null) {
            return;
        }
        JsonObject object = FilterByJsonRequirements.jsonFromString(requirements);
        this.requirements = FilterByJsonRequirements.jsonToMap(object);
    }

    private static JsonObject jsonFromString(String jsonObjectStr) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonObjectStr));
        JsonObject object = jsonReader.readObject();
        jsonReader.close();
        return object;
    }

    public List<SGASet> filter(List<SGASet> servers) {
        SGACriteriaOr platformsCriteria = null;
        SGACriteriaByAvailability availabilityCriteria = null;
        SGACriteriaByMinCPUs minCPUsCriteria = null;
        SGACriteriaByMinFreeRAMMem minMemCriteria = null;
        SGACriteriaByRequirements aditionalCriteria = null;
        List platformsSet = (List)this.requirements.get(PLATFORMS_KEY);
        this.requirements.remove(PLATFORMS_KEY);
        if (platformsSet != null) {
            LinkedList<SGACriteriaByPlatform> criterias = new LinkedList<SGACriteriaByPlatform>();
            for (JsonString platform : platformsSet) {
                criterias.add(new SGACriteriaByPlatform(platform.getString()));
            }
            platformsCriteria = new SGACriteriaOr(criterias);
        }
        JsonNumber minCPU = (JsonNumber)this.requirements.get(CPU_AMMOUNT_KEY);
        this.requirements.remove(CPU_AMMOUNT_KEY);
        if (minCPU != null) {
            minCPUsCriteria = new SGACriteriaByMinCPUs((float)minCPU.longValue());
        }
        JsonNumber minMem = (JsonNumber)this.requirements.get(MEMORY_AMMOUNT_KEY);
        this.requirements.remove(MEMORY_AMMOUNT_KEY);
        if (minMem != null) {
            minMemCriteria = new SGACriteriaByMinFreeRAMMem((double)minMem.longValue());
        }
        availabilityCriteria = new SGACriteriaByAvailability();
        HashSet<String> aditionalRequirements = new HashSet<String>();
        for (String key : this.requirements.keySet()) {
            JsonValue value = (JsonValue)this.requirements.get(key);
            JsonValue.ValueType type = value.getValueType();
            switch (type) {
                case TRUE: {
                    aditionalRequirements.add(key);
                    break;
                }
            }
        }
        if (aditionalRequirements != null && !aditionalRequirements.isEmpty()) {
            aditionalCriteria = new SGACriteriaByRequirements(aditionalRequirements);
        }
        LinkedList<Object> criteriasToMeet = new LinkedList<Object>();
        if (platformsCriteria != null) {
            criteriasToMeet.add(platformsCriteria);
        }
        if (availabilityCriteria != null) {
            criteriasToMeet.add(availabilityCriteria);
        }
        if (minCPUsCriteria != null) {
            criteriasToMeet.add(minCPUsCriteria);
        }
        if (minMemCriteria != null) {
            criteriasToMeet.add(minMemCriteria);
        }
        if (aditionalCriteria != null) {
            criteriasToMeet.add(aditionalCriteria);
        }
        SGACriteriaAnd finalCriteria = new SGACriteriaAnd(criteriasToMeet);
        return new SGAFilter((SGACriteria)finalCriteria).filter(servers);
    }

    private static Map<String, Object> jsonToMap(JsonObject json) {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != JsonObject.NULL) {
            retMap = FilterByJsonRequirements.toMap(json);
        }
        return retMap;
    }

    private static Map<String, Object> toMap(JsonObject object) throws JsonException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : object.keySet()) {
            List<Object> value = object.get((Object)key);
            if (value instanceof JsonArray) {
                value = FilterByJsonRequirements.toList((JsonArray)value);
            } else if (value instanceof JsonObject) {
                value = FilterByJsonRequirements.toMap((JsonObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    private static List<Object> toList(JsonArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JsonArray) {
                value = FilterByJsonRequirements.toList((JsonArray)value);
            } else if (value instanceof JsonObject) {
                value = FilterByJsonRequirements.toMap((JsonObject)value);
            }
            list.add(value);
        }
        return list;
    }
}

