/*
 * Decompiled with CFR 0.152.
 */
package ibase.common;

import ibase.common.CorsServletFilter;
import ibase.exception.InitException;
import java.net.URI;
import java.util.EnumSet;
import java.util.Properties;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class RestServer {
    private HttpServer httpServer;
    private Properties properties;

    public RestServer(Properties properties, ResourceConfig config) {
        this.properties = properties;
    }

    private static URI getBaseURI(int port) {
        return UriBuilder.fromUri((String)"http://0.0.0.0").port(port).path("/").build(new Object[0]);
    }

    private void start(ResourceConfig config) {
        try {
            int port = Integer.getInteger(this.properties.getProperty("service.port"));
            this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)RestServer.getBaseURI(port));
            WebappContext context = new WebappContext("WebappContext", "/v1");
            ServletContainer container = new ServletContainer(config);
            ServletRegistration registration = context.addServlet("ServletContainer", (Servlet)container);
            registration.addMapping(new String[]{"/*"});
            FilterRegistration corsFilter = context.addFilter("CorsFilter", (Filter)new CorsServletFilter());
            corsFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
            context.deploy(this.httpServer);
            CLStaticHttpHandler staticHttpHandler = new CLStaticHttpHandler(RestServer.class.getClassLoader(), new String[]{"swagger-ui/", "docs/"});
            this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/docs"});
        }
        catch (Exception e) {
            throw new InitException(e);
        }
    }
}

