/*
 * Decompiled with CFR 0.152.
 */
package ibase.common;

import java.lang.annotation.Annotation;
import java.util.Locale;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public interface ServiceAdapter {
    public static final ThreadLocal<ServiceLocator> serviceLocatorThreadLocal = new ThreadLocal();
    public static final ThreadLocal<String> authenticationThreadLocal = new ThreadLocal();
    public static final ThreadLocal<String> uriThreadLocal = new ThreadLocal();
    public static final ThreadLocal<String> userThreadLocal = new ThreadLocal();

    public void setLocale(Locale var1);

    public static String getCurrenUser() {
        return userThreadLocal.get();
    }

    public static void setCurrentUser(String userId) {
        userThreadLocal.set(userId);
    }

    public static <T extends ServiceAdapter> T getInstance(Class<T> serviceClass, String localeString) {
        ServiceAdapter service = (ServiceAdapter)ServiceLocatorUtilities.findOrCreateService((ServiceLocator)serviceLocatorThreadLocal.get(), serviceClass, (Annotation[])new Annotation[0]);
        Locale locale = Locale.getDefault();
        if (localeString != null) {
            locale = new Locale(localeString);
        }
        service.setLocale(locale);
        return (T)service;
    }

    public static void setServiceLocator(ServiceLocator serviceLocator) {
        serviceLocatorThreadLocal.set(serviceLocator);
    }

    public static String getAutheticationHeader() {
        return authenticationThreadLocal.get();
    }

    public static void setAuthorizationHeader(String authorizationHeader) {
        authenticationThreadLocal.set(authorizationHeader);
    }

    public static String getURI() {
        return uriThreadLocal.get();
    }

    public static void setURI(String baseUri) {
        uriThreadLocal.set(baseUri);
    }

    public static void clean() {
        ServiceAdapter.setServiceLocator(null);
    }
}

