/*
 * Decompiled with CFR 0.152.
 */
package ibase.common;

import ibase.common.RestErrorMessage;
import io.jsonwebtoken.impl.Base64Codec;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;

public class ServiceUtil {
    public static String encodeToBase64(String id) {
        if ("".equals(id)) {
            return "";
        }
        Base64Codec coded = new Base64Codec();
        return coded.encode(id);
    }

    public static String decodeFromBase64(String id) {
        if ("".equals(id)) {
            return "";
        }
        Base64Codec coded = new Base64Codec();
        return coded.decodeToString(id);
    }

    public static Translator getTranslator(String localeString, String resourceBundle) {
        Locale locale = null;
        if (localeString != null) {
            locale = new Locale(localeString);
        }
        locale = locale == null ? Locale.getDefault() : locale;
        return new Translator(locale, resourceBundle);
    }

    public static Response buildException(Response.Status status, Logger logger, String message) {
        logger.severe(message);
        return Response.status((Response.Status)status).entity((Object)new RestErrorMessage(message)).type("application/json").build();
    }

    public static Response buildException(Response.Status status, Logger logger, Exception exception) {
        if (Response.Status.INTERNAL_SERVER_ERROR.equals((Object)status)) {
            logger.log(Level.SEVERE, "INTERNAL_SERVER_ERROR", exception);
        }
        return Response.status((Response.Status)status).entity((Object)new RestErrorMessage(exception.getMessage())).type("application/json").build();
    }

    public static class Translator {
        private ResourceBundle bundle;

        Translator(Locale locale, String text) {
            this.bundle = ResourceBundle.getBundle(text, locale);
        }

        public String message(String key, String ... args) {
            try {
                return MessageFormat.format(this.bundle.getString(key), args);
            }
            catch (MissingResourceException e) {
                return "<<" + key + ">>";
            }
        }
    }
}

