/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.imagepanel;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private Image image;
    private int preferredWidth = 0;
    private HorAlign horAlign = HorAlign.CENTER;
    private VerAlign verAlign = VerAlign.CENTER;

    public ImagePanel setImage(Image image) {
        this.image = image;
        this.preferredWidth = image == null ? 0 : 200;
        this.repaint();
        return this;
    }

    public Image getImage() {
        return this.image;
    }

    public HorAlign getHorAlign() {
        return this.horAlign;
    }

    public ImagePanel setHorAlign(HorAlign horAlign) {
        this.horAlign = horAlign;
        this.repaint();
        return this;
    }

    public VerAlign getVerAlign() {
        return this.verAlign;
    }

    public ImagePanel setVerAlign(VerAlign verAlign) {
        this.verAlign = verAlign;
        this.repaint();
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return super.getPreferredSize();
        }
        int w = Math.round(this.preferredWidth);
        return this.getDimensionOnWidth(w);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.image == null) {
            return super.getMinimumSize();
        }
        int w = (int)Math.round((double)this.preferredWidth * 0.7);
        return this.getDimensionOnWidth(w);
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.image == null) {
            return super.getMaximumSize();
        }
        int w = (int)Math.round((double)this.preferredWidth * 1.3);
        return this.getDimensionOnWidth(w);
    }

    private Dimension getDimensionOnWidth(int w) {
        if (this.image == null) {
            return new Dimension(w, w);
        }
        double ratio = (double)this.image.getWidth(null) / (double)this.image.getHeight(null);
        int h = (int)Math.round((double)w / ratio);
        return new Dimension(w, h);
    }

    public double getScaleFactor(int iMasterSize, int iTargetSize) {
        double dScale = 1.0;
        dScale = iMasterSize > iTargetSize ? (double)iTargetSize / (double)iMasterSize : (double)iTargetSize / (double)iMasterSize;
        return dScale;
    }

    public double getScaleFactorToFit(Dimension original, Dimension toFit) {
        double dScale = 1.0;
        if (original != null && toFit != null) {
            double dScaleWidth = this.getScaleFactor(original.width, toFit.width);
            double dScaleHeight = this.getScaleFactor(original.height, toFit.height);
            dScale = Math.min(dScaleHeight, dScaleWidth);
        }
        return dScale;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int imgW = this.image.getWidth(null);
        int imgH = this.image.getHeight(null);
        Dimension original = new Dimension(imgW, imgH);
        double scaleFactor = Math.min(1.0, this.getScaleFactorToFit(original, this.getSize()));
        int scaleWidth = (int)Math.round((double)imgW * scaleFactor);
        int scaleHeight = (int)Math.round((double)imgH * scaleFactor);
        Image scaled = this.image.getScaledInstance(scaleWidth, scaleHeight, 4);
        int width = this.getWidth() - 1;
        int height = this.getHeight() - 1;
        double ha = this.getHorFactor();
        double va = this.getVerFactor();
        int x = (int)Math.round((double)(width - scaled.getWidth(this)) * ha);
        int y = (int)Math.round((double)(height - scaled.getHeight(this)) * va);
        g.drawImage(scaled, x, y, this);
    }

    private double getHorFactor() {
        switch (this.horAlign) {
            case WEST: {
                return 0.0;
            }
            case CENTER: {
                return 0.5;
            }
            case EAST: {
                return 1.0;
            }
        }
        throw new IllegalStateException("Invalid hor alignment");
    }

    private double getVerFactor() {
        switch (this.verAlign) {
            case NORTH: {
                return 0.0;
            }
            case CENTER: {
                return 0.5;
            }
            case SOUTH: {
                return 1.0;
            }
        }
        throw new IllegalStateException("Invalid ver alignment");
    }

    public static enum VerAlign {
        CENTER,
        SOUTH,
        NORTH;

    }

    public static enum HorAlign {
        CENTER,
        WEST,
        EAST;

    }
}

