/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TextTool {
    public static final String NORTH = "n ";
    public static final String SOUTH = "s ";
    public static final String EAST = "e";
    public static final String WEST = "w";
    public static final String NORTH_EAST = "ne";
    public static final String NORTH_WEST = "nw";
    public static final String SOUTH_EAST = "se";
    public static final String SOUTH_WEST = "sw";
    public static final String CENTER = "c";
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_CENTER = "center";
    public static final String ALIGN_RIGHT = "right";
    public static final String WRAP_NONE = "none";
    public static final String WRAP_WORD = "word";
    public static final String WRAP_CHAR = "char";
    private static Set<Character> WHITESPACE = new HashSet<Character>();
    private int TAB_SIZE = 45;
    private List<String> lines = new ArrayList<String>();
    private List<Integer> widths = new ArrayList<Integer>();
    private int maxNumLines;
    private int maxWidth;
    private int ascent;
    private int descent;
    private int height;
    private FontMetrics metrics;
    private AffineTransform oT;
    private AffineTransform cT;
    private AffineTransform backupTransform;
    private StringBuilder wrapText = new StringBuilder();

    public void setTransforms(AffineTransform oT, AffineTransform cT) {
        this.oT = oT;
        this.cT = cT;
    }

    private void saveTransform(Graphics2D g2d) {
        this.backupTransform = g2d.getTransform();
    }

    private void restoreTransform(Graphics2D g2d) {
        g2d.setTransform(this.backupTransform);
    }

    private void setup(Graphics2D g2d, String text, float maxHeight) {
        this.initMetrics(g2d);
        String[] tempLines = text.split("\n", -1);
        this.lines.clear();
        this.widths.clear();
        this.maxWidth = 0;
        int numLines = tempLines.length;
        if (maxHeight >= 0.0f) {
            this.maxNumLines = (int)Math.floor(maxHeight / (float)this.height);
            numLines = Math.min(numLines, this.maxNumLines);
        }
        for (int i = 0; i < numLines; ++i) {
            this.lines.add(tempLines[i]);
            int width = this.calculateLineWidth(tempLines[i]);
            this.widths.add(width);
            this.maxWidth = Math.max(this.maxWidth, width);
        }
    }

    private void initMetrics(Graphics2D g2d) {
        if (this.oT != null) {
            g2d.setTransform(this.oT);
        }
        this.metrics = g2d.getFontMetrics();
        this.ascent = this.metrics.getAscent();
        this.descent = this.metrics.getDescent();
        this.height = this.metrics.getHeight();
    }

    private int calculateLineWidth(String line) {
        String[] tokens = line.split("\t");
        if (tokens.length == 1) {
            return this.metrics.stringWidth(tokens[0]);
        }
        int lineWidth = 0;
        for (String str : tokens) {
            int tempWidth = this.metrics.stringWidth(str);
            if (tempWidth < this.TAB_SIZE) {
                lineWidth += this.TAB_SIZE;
                continue;
            }
            lineWidth += (tempWidth / this.TAB_SIZE + 1) * this.TAB_SIZE;
        }
        return lineWidth;
    }

    private void adjustBasePoint(Point2D base, String ref, Rectangle2D bbox) {
        float dx = 0.0f;
        float dy = 0.0f;
        switch (ref.charAt(0)) {
            case 'n': {
                dy = this.ascent;
                switch (ref.charAt(1)) {
                    case 'e': {
                        dx = -this.maxWidth;
                        break;
                    }
                    case ' ': {
                        dx = (float)(-this.maxWidth) / 2.0f;
                    }
                }
                break;
            }
            case 's': {
                dy = -this.descent - this.height * (this.lines.size() - 1);
                switch (ref.charAt(1)) {
                    case 'e': {
                        dx = -this.maxWidth;
                        break;
                    }
                    case ' ': {
                        dx = (float)(-this.maxWidth) / 2.0f;
                    }
                }
                break;
            }
            case 'c': {
                dx = (float)(-this.maxWidth) / 2.0f;
                dy = (float)this.ascent / 2.0f - (float)(this.height * (this.lines.size() - 1)) / 2.0f;
                break;
            }
            case 'e': {
                dx = -this.maxWidth;
                dy = (float)this.ascent / 2.0f - (float)(this.height * (this.lines.size() - 1)) / 2.0f;
                break;
            }
            case 'w': {
                dy = (float)this.ascent / 2.0f - (float)(this.height * (this.lines.size() - 1)) / 2.0f;
            }
        }
        base.setLocation(base.getX() + (double)dx, base.getY() + (double)dy);
        if (bbox != null) {
            bbox.setRect(base.getX(), base.getY() - (double)this.ascent, this.maxWidth, this.lines.size() * this.height);
        }
    }

    private void adjustLinePoint(Point2D pt, Point2D base, int lineIndex, String alignment) {
        float dx = 0.0f;
        float dy = this.height * lineIndex;
        if (alignment == ALIGN_LEFT) {
            dx = 0.0f;
        } else if (alignment == ALIGN_CENTER) {
            dx = (float)(this.maxWidth - this.widths.get(lineIndex)) / 2.0f;
        } else if (alignment == ALIGN_RIGHT) {
            dx = this.maxWidth - this.widths.get(lineIndex);
        }
        pt.setLocation(base.getX() + (double)dx, base.getY() + (double)dy);
    }

    public void getBBox(Graphics2D g2d, String text, Point2D p, String ref, Rectangle2D bbox) {
        if (g2d == null) {
            throw new IllegalArgumentException("g2d == null");
        }
        if (p == null) {
            throw new IllegalArgumentException("p == null");
        }
        if (ref == null || ref.isEmpty()) {
            throw new IllegalArgumentException("ref est\u00e1 vazia");
        }
        if (bbox == null) {
            throw new IllegalArgumentException("bbox == null");
        }
        this.saveTransform(g2d);
        this.setup(g2d, text, -1.0f);
        Point2D base = this.getPoint(p);
        this.adjustBasePoint(base, ref, bbox);
        this.adjustBoundingBox(bbox, this.oT);
        this.restoreTransform(g2d);
    }

    private Point2D getPoint(Point2D p) {
        Point2D.Float pt = new Point2D.Float();
        pt.setLocation(p);
        if (this.cT != null) {
            this.cT.transform(pt, pt);
        }
        return pt;
    }

    private void adjustBoundingBox(Rectangle2D bbox, AffineTransform aT) {
        if (aT == null) {
            return;
        }
        double x = bbox.getX();
        double y = bbox.getY();
        Point2D.Float upperLeft = new Point2D.Float();
        Point2D.Float lowerRight = new Point2D.Float();
        ((Point2D)upperLeft).setLocation(x, y);
        ((Point2D)lowerRight).setLocation(bbox.getWidth() - x, bbox.getHeight() - y);
        aT.transform(upperLeft, upperLeft);
        aT.transform(lowerRight, lowerRight);
        bbox.setFrameFromDiagonal(upperLeft, lowerRight);
    }

    public void draw(Graphics2D g2d, String text, Point2D p, String ref) {
        this.draw(g2d, text, p, ref, ALIGN_LEFT);
    }

    public void draw(Graphics2D g2d, String text, Point2D p, String ref, String alignment) {
        if (g2d == null) {
            throw new IllegalArgumentException("g2d == null");
        }
        if (p == null) {
            throw new IllegalArgumentException("p == null");
        }
        if (ref == null || ref.isEmpty()) {
            throw new IllegalArgumentException("ref est\u00e1 vazia");
        }
        this.saveTransform(g2d);
        this.setup(g2d, text, -1.0f);
        Point2D base = this.getPoint(p);
        this.adjustBasePoint(base, ref, null);
        Point2D pt = this.getPoint(p);
        for (int lineIndex = 0; lineIndex < this.lines.size(); ++lineIndex) {
            this.adjustLinePoint(pt, base, lineIndex, alignment);
            this.drawTabbedString(g2d, this.lines.get(lineIndex), pt);
        }
        this.restoreTransform(g2d);
    }

    private void drawTabbedString(Graphics2D g2d, String text, Point2D startPoint) {
        String[] tokens = text.split("\t");
        float dx = (float)startPoint.getX();
        for (String str : tokens) {
            g2d.drawString(str, dx, (float)startPoint.getY());
            int tempWidth = this.metrics.stringWidth(str);
            if (tempWidth < this.TAB_SIZE) {
                dx += (float)this.TAB_SIZE;
                continue;
            }
            dx += (float)((tempWidth / this.TAB_SIZE + 1) * this.TAB_SIZE);
        }
    }

    private int findSplitPos(int lineIndex, int boxWidth, String wrap) {
        String line = this.lines.get(lineIndex);
        for (int pos = line.length() - 1; pos >= 0; --pos) {
            String firstPart;
            int width;
            char c;
            if (wrap == WRAP_WORD && !WHITESPACE.contains(Character.valueOf(c = line.charAt(pos))) || (width = this.calculateLineWidth(firstPart = line.substring(0, pos))) > boxWidth) continue;
            return pos;
        }
        if (wrap == WRAP_WORD) {
            return this.findSplitPos(lineIndex, boxWidth, WRAP_CHAR);
        }
        throw new RuntimeException("Erro em TextTool.findCharSplitPos.");
    }

    public String wrapText(Graphics2D g2d, String text, int boxWidth, String wrapStyle) {
        if (g2d == null) {
            throw new IllegalArgumentException("g2d == null");
        }
        if (boxWidth < 0) {
            throw new IllegalArgumentException("boxWidth < 0");
        }
        if (wrapStyle != WRAP_CHAR && wrapStyle != WRAP_WORD) {
            return text;
        }
        this.saveTransform(g2d);
        this.initMetrics(g2d);
        this.wrapText.setLength(0);
        int breakPos = 0;
        int startPos = 0;
        for (int pos = 1; pos <= text.length(); ++pos) {
            String newStr = text.substring(startPos, pos);
            char c = text.charAt(pos - 1);
            if (c != '\n' && !WHITESPACE.contains(Character.valueOf(c)) && wrapStyle == WRAP_WORD && pos < text.length()) continue;
            String accumulatedStr = this.wrapText.substring(breakPos);
            int newStrSize = this.calculateLineWidth(newStr);
            int totalSize = newStrSize + this.calculateLineWidth(accumulatedStr);
            if (totalSize > boxWidth) {
                if (this.wrapText.length() > 0) {
                    this.wrapText.append("\n");
                }
                breakPos = this.wrapText.length();
            }
            startPos = pos;
            this.wrapText.append(newStr);
            if (c != '\n') continue;
            breakPos = this.wrapText.length();
        }
        this.restoreTransform(g2d);
        return this.wrapText.toString();
    }

    private void splitLine(int lineIndex, int boxWidth, String wrap) {
        int splitPos = this.findSplitPos(lineIndex, boxWidth, wrap);
        String line = this.lines.get(lineIndex);
        String firstLine = line.substring(0, splitPos);
        String secondLine = line.substring(splitPos);
        this.lines.set(lineIndex, firstLine);
        this.lines.add(lineIndex + 1, secondLine);
        this.widths.set(lineIndex, this.calculateLineWidth(firstLine));
        this.widths.add(lineIndex + 1, this.calculateLineWidth(secondLine));
        if (this.lines.size() > this.maxNumLines) {
            this.lines.remove(this.lines.size() - 1);
            this.widths.remove(this.widths.size() - 1);
        }
    }

    private int adjustLines(Rectangle2D bbox, String wrap) {
        int boxWidth = (int)Math.floor(bbox.getWidth());
        int lastChar = 0;
        for (int lineIndex = 0; lineIndex < this.lines.size(); ++lineIndex) {
            if (this.widths.get(lineIndex) > boxWidth && wrap != WRAP_NONE) {
                this.splitLine(lineIndex, boxWidth, wrap);
                lastChar += this.lines.get(lineIndex).length();
                continue;
            }
            lastChar += this.lines.get(lineIndex).length() + 1;
        }
        return lastChar;
    }

    public int draw(Graphics2D g2d, String text, int pos, Rectangle2D bbox, String wrap, String alignment) {
        if (g2d == null) {
            throw new IllegalArgumentException("g2d == null");
        }
        if (pos < 0) {
            throw new IllegalArgumentException("pos < 0");
        }
        if (pos > text.length() - 1) {
            throw new IllegalArgumentException("pos > text.length() - 1");
        }
        if (bbox == null) {
            throw new IllegalArgumentException("bbox == null");
        }
        if (wrap != WRAP_CHAR && wrap != WRAP_WORD) {
            throw new IllegalArgumentException("wrap desconhecido");
        }
        this.saveTransform(g2d);
        this.adjustBoundingBox(bbox, this.cT);
        text = text.substring(pos);
        this.setup(g2d, text, (float)bbox.getHeight());
        int lastChar = this.adjustLines(bbox, wrap);
        Point2D.Float pt = new Point2D.Float();
        for (int lineIndex = 0; lineIndex < this.lines.size(); ++lineIndex) {
            String line = this.lines.get(lineIndex).trim();
            int width = this.widths.get(lineIndex);
            this.setLinePoint(bbox, lineIndex, width, alignment, pt);
            this.drawTabbedString(g2d, line, pt);
        }
        float drawnHeight = this.lines.size() * this.height;
        bbox.setRect(bbox.getX(), bbox.getY(), bbox.getWidth(), drawnHeight);
        this.adjustBoundingBox(bbox, this.oT);
        this.restoreTransform(g2d);
        return lastChar + pos;
    }

    public int getBBox(Graphics2D g2d, String text, int pos, Rectangle2D bbox, String wrap, String alignment) {
        if (g2d == null) {
            throw new IllegalArgumentException("g2d == null");
        }
        if (pos < 0) {
            throw new IllegalArgumentException("pos < 0");
        }
        if (bbox == null) {
            throw new IllegalArgumentException("bbox == null");
        }
        if (wrap == null || wrap.isEmpty()) {
            throw new IllegalArgumentException("wrap est\u00e1 vazia");
        }
        if (alignment == null || alignment.isEmpty()) {
            throw new IllegalArgumentException("alignment est\u00e1 vazia");
        }
        this.saveTransform(g2d);
        this.adjustBoundingBox(bbox, this.cT);
        text = text.substring(pos);
        this.setup(g2d, text, (float)bbox.getHeight());
        int lastChar = this.adjustLines(bbox, wrap);
        float drawnHeight = this.lines.size() * this.height;
        bbox.setRect(bbox.getX(), bbox.getY(), bbox.getWidth(), drawnHeight);
        this.adjustBoundingBox(bbox, this.oT);
        this.restoreTransform(g2d);
        return lastChar + pos;
    }

    private void setLinePoint(Rectangle2D bbox, int lineIndex, int lineWidth, String alignment, Point2D pt) {
        float baseX = (float)bbox.getX();
        float baseY = (float)bbox.getY() + (float)this.ascent;
        float dx = 0.0f;
        float dy = this.height * lineIndex;
        if (alignment == ALIGN_LEFT) {
            dx = 0.0f;
        } else if (alignment == ALIGN_CENTER) {
            dx = (float)bbox.getWidth() / 2.0f - (float)(lineWidth / 2);
        } else if (alignment == ALIGN_RIGHT) {
            dx = (float)bbox.getWidth() - (float)lineWidth;
        }
        pt.setLocation(baseX + dx, baseY + dy);
    }

    public void setTabSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.TAB_SIZE = size;
    }

    int getMaxWidth() {
        return this.maxWidth;
    }

    static {
        WHITESPACE.add(Character.valueOf(' '));
        WHITESPACE.add(Character.valueOf('\t'));
        WHITESPACE.add(Character.valueOf('\n'));
        WHITESPACE.add(Character.valueOf('\f'));
        WHITESPACE.add(Character.valueOf('\r'));
    }
}

