/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.mvc.core.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.xml.ws.Holder;
import tecgraf.javautils.mvc.core.controller.ControllerException;
import tecgraf.javautils.mvc.core.controller.ControllerManager;
import tecgraf.javautils.mvc.core.controller.ControllerStatus;
import tecgraf.javautils.mvc.core.ui.IUi;
import tecgraf.javautils.mvc.core.ui.UiLibrary;

public abstract class Controller<U extends IUi> {
    private final int id;
    private Controller<?> parent;
    private List<Controller<?>> children;
    private U ui = null;
    private int buildCount = 0;
    private ControllerStatus controllerStatus;
    private UiLibrary controllerUiLibrary = null;
    private String description = "no description";
    private static final AtomicInteger currentId = new AtomicInteger(0);

    Controller() {
        ControllerManager.getInstance().addToRootControllers(this);
        this.id = currentId.incrementAndGet();
        this.children = new ArrayList();
        this.setControllerStatus(ControllerStatus.REGISTERED);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    void setUiLibrary(UiLibrary uiLibrary) {
        this.controllerUiLibrary = uiLibrary;
    }

    public final UiLibrary getUiLibrary() {
        return this.controllerUiLibrary;
    }

    final void setControllerStatus(ControllerStatus controllerStatus) {
        this.controllerStatus = controllerStatus;
    }

    public final ControllerStatus getControllerStatus() {
        return this.controllerStatus;
    }

    final void setParent(Controller<?> parent) {
        this.parent = parent;
        ControllerManager.getInstance().removeFromRootControllers(this);
    }

    public <E extends Controller> E createOrFindSingletonChild(Class<E> clss) {
        E c = ControllerManager.getInstance().find(clss);
        if (c == null) {
            c = this.createChild(clss);
        }
        return c;
    }

    public <E extends Controller> E createChild(Class<E> clss) {
        try {
            Controller c = (Controller)clss.newInstance();
            this.addChild(c);
            return (E)c;
        }
        catch (Exception e) {
            throw new ControllerException("Erro ao instanciar controlador " + clss.getName(), e);
        }
    }

    final void addChild(Controller<?> child) {
        ControllerManager.getInstance().lock();
        try {
            if (!this.children.contains(child)) {
                this.children.add(child);
                child.setParent(this);
            }
        }
        finally {
            ControllerManager.getInstance().unlock();
        }
    }

    final void removeChild(Controller child) {
        ControllerManager.getInstance().lock();
        try {
            this.children.remove(child);
        }
        finally {
            ControllerManager.getInstance().unlock();
        }
    }

    public final List<Controller<?>> getChildren() {
        ControllerManager.getInstance().lock();
        try {
            ArrayList list = new ArrayList(this.children);
            List<Controller<?>> list2 = Collections.unmodifiableList(list);
            return list2;
        }
        finally {
            ControllerManager.getInstance().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends Controller> E getDescendant(Class<E> clss) {
        ControllerManager.getInstance().lock();
        try {
            List<Controller<?>> list = this.getChildren();
            for (Controller<?> child : list) {
                if (!clss.isAssignableFrom(child.getClass())) continue;
                Controller controller = (Controller)clss.cast(child);
                return (E)controller;
            }
            for (Controller<?> child : list) {
                E c = child.getDescendant(clss);
                if (c == null) continue;
                E e = c;
                return e;
            }
            Iterator<Controller<?>> iterator = null;
            return (E)iterator;
        }
        finally {
            ControllerManager.getInstance().unlock();
        }
    }

    public final <E extends Controller> List<E> getDescendants(Class<E> clss) {
        ArrayList list = new ArrayList();
        ControllerManager.getInstance().fetchChildren(this, list, clss);
        return list;
    }

    private void recursiveFetchChildren(List<Controller> list) {
        ControllerManager.getInstance().lock();
        try {
            this.getChildren().forEach(child -> {
                list.add((Controller)child);
                child.recursiveFetchChildren(list);
            });
        }
        finally {
            ControllerManager.getInstance().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void free() {
        ControllerManager controllerManager = ControllerManager.getInstance();
        controllerManager.lock();
        try {
            ArrayList<Controller> list = new ArrayList<Controller>();
            list.add(this);
            this.recursiveFetchChildren(list);
            for (Controller c : list) {
                c.beforeFree();
            }
            for (Controller c : list) {
                c.setControllerStatus(ControllerStatus.UNREGISTERING);
            }
            if (this.parent != null) {
                this.parent.removeChild(this);
                this.parent = null;
            } else {
                controllerManager.removeFromRootControllers(this);
            }
            for (Controller c : list) {
                c.setControllerStatus(ControllerStatus.UNREGISTERED);
            }
            for (Controller c : list) {
                c.afterFree();
            }
        }
        finally {
            controllerManager.unlock();
        }
        String fmt = "Controller [%s] is released!";
        String msg = String.format("Controller [%s] is released!", this.toString());
        this.getLogger().info(msg);
    }

    public final int getDepth() {
        Controller<?> c = this;
        int depth = 0;
        while (c.getParent() != null) {
            ++depth;
            c = c.getParent();
        }
        return depth;
    }

    public final Controller<?> getParent() {
        return this.parent;
    }

    public final <E extends Controller> E getAscendent(Class<E> clss) {
        for (Controller<?> p = this.getParent(); p != null; p = p.getParent()) {
            if (!clss.isAssignableFrom(p.getClass())) continue;
            return (E)((Controller)clss.cast(p));
        }
        return null;
    }

    public final int getControllerId() {
        return this.id;
    }

    public final boolean isComponentInstancied() {
        return this.ui != null;
    }

    public final U getUi() {
        if (this.ui != null) {
            return this.ui;
        }
        ++this.buildCount;
        if (this.buildCount > 1) {
            String warning = "Loop inside controller build for " + this.getClass().getName() + ".";
            warning = warning + "Check if getComponent() is being caled inside buildComponent().";
            this.getLogger().warning(warning);
        }
        UiLibrary ctrlUiLibrary = this.getUiLibrary();
        boolean mockEnabled = ControllerManager.getInstance().isMockEnabled();
        try {
            UiLibrary threadUiLibrary;
            this.ui = mockEnabled ? this.buildUi(mockEnabled) : ((threadUiLibrary = UiLibrary.getUiLibraryForCurrentThread()) == null || threadUiLibrary.equals(ctrlUiLibrary) ? this.buildUiForUiLibrary(ctrlUiLibrary, mockEnabled) : this.buildUi(mockEnabled));
        }
        catch (Exception e) {
            String err = "Compoment building error inside : " + this.toString();
            this.getLogger().severe(err);
            throw new ControllerException("err", e);
        }
        if (this.ui == null) {
            throw new ControllerException("Invalid null component creation.");
        }
        UiLibrary uiLibrary = this.ui.getUiLibrary();
        if (uiLibrary != null && mockEnabled) {
            throw new ControllerException("Mock component created with Ui library definition!");
        }
        if (uiLibrary == null && !mockEnabled) {
            throw new ControllerException("Component created with null Ui library and it is not a mock!");
        }
        if (uiLibrary != null && !uiLibrary.equals(ctrlUiLibrary)) {
            throw new ControllerException("Component created with diferent Ui library from its controller!");
        }
        this.afterBuildComponent(this.ui);
        String fmt = "Component for [%s] controller built!";
        String msg = String.format("Component for [%s] controller built!", this.toString());
        this.getLogger().info(msg);
        return this.ui;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Controller that = (Controller)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    protected Logger getLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    protected final U buildUiForUiLibrary(UiLibrary threadUiLibrary, boolean mockEnabled) {
        CountDownLatch doneLatch = new CountDownLatch(1);
        Holder tmp = new Holder();
        threadUiLibrary.runWithProtection(() -> {
            try {
                tmp.value = this.buildUi(mockEnabled);
            }
            finally {
                doneLatch.countDown();
            }
        });
        try {
            doneLatch.await();
            return (U)((IUi)tmp.value);
        }
        catch (InterruptedException e) {
            throw new ControllerException("Component build exception", e);
        }
    }

    public final String toString() {
        int id = this.getControllerId();
        String className = this.getClass().getSimpleName();
        return String.format("%s::%010d", className, id);
    }

    protected abstract void afterBuildComponent(U var1);

    protected abstract void afterFree();

    protected abstract void beforeFree();

    public abstract U buildUi(boolean var1);
}

