/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.mvc.core.ui;

import javafx.application.Platform;
import javax.swing.SwingUtilities;
import tecgraf.javautils.mvc.core.ui.IUiLibrary;

public enum UiLibrary implements IUiLibrary
{
    FX{

        @Override
        public void runLater(Runnable runnable) {
            Platform.runLater((Runnable)runnable);
        }
    }
    ,
    SWING{

        @Override
        public void runLater(Runnable runnable) {
            SwingUtilities.invokeLater(runnable);
        }
    };


    @Override
    public void runWithProtection(Runnable runnable) {
        UiLibrary uiLibraryForCurrentThread = UiLibrary.getUiLibraryForCurrentThread();
        if (uiLibraryForCurrentThread != null && uiLibraryForCurrentThread.equals(this)) {
            runnable.run();
        } else {
            this.runLater(runnable);
        }
    }

    public static UiLibrary getUiLibraryForCurrentThread() {
        if (Platform.isFxApplicationThread()) {
            return FX;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return SWING;
        }
        return null;
    }
}

