/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.mvc.samples.fxwidgets;

import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import tecgraf.javautils.mvc.utils.window.common.IWindowUi;
import tecgraf.javautils.mvc.utils.window.common.WindowCallbacks;
import tecgraf.javautils.mvc.utils.window.fx.FxStageWindow;

public class FxWidgetsStage
extends FxStageWindow<Pane>
implements IWindowUi {
    public static final int SPACING = 5;
    private final VBox pane = new VBox();
    private final WindowCallbacks callbacks = new WindowCallbacks();
    private final int INSET = 10;

    public FxWidgetsStage(String cssPath) {
        if (cssPath != null) {
            this.addCss("file:" + cssPath);
        }
        MenuBar menuBar = new MenuBar();
        Menu menuFile = new Menu("File");
        menuFile.getItems().addAll((Object[])new MenuItem[]{new MenuItem("A"), new MenuItem("B")});
        Menu menuEdit = new Menu("Edit");
        menuEdit.getItems().addAll((Object[])new MenuItem[]{new MenuItem("C"), new MenuItem("D")});
        Menu menuView = new Menu("View");
        menuBar.getMenus().addAll((Object[])new Menu[]{menuFile, menuEdit, menuView});
        this.pane.getChildren().addAll((Object[])new Node[]{menuBar});
        VBox box = this.createVbox();
        this.pane.getChildren().addAll((Object[])new Node[]{box});
        this.callbacks.setRequestCloseCallback((ui, userData) -> System.exit(0));
        this.setTitle("FX Widgets");
        ObservableList children = box.getChildren();
        children.add((Object)this.createLabelPane());
        children.add((Object)this.createTextPane());
        children.add((Object)this.createTogglePane());
        children.add((Object)this.createRadioPane());
        children.add((Object)this.createComboPane());
        children.add((Object)this.createButtonPane());
        children.add((Object)this.createCheckPane());
        children.add((Object)this.createSliderPane());
        children.add((Object)this.createHiperlinkPane());
    }

    private Control createLabelPane() {
        Label labA = new Label("Campo de r\u00f3tulo");
        HBox box = this.createHbox();
        box.getChildren().add((Object)labA);
        TitledPane pane = new TitledPane("Labels", (Node)box);
        return pane;
    }

    private Control createTextPane() {
        TextField txtA = new TextField("ativo");
        TextField txtB = new TextField("ativo e n\u00e3o edit\u00e1vel");
        txtB.setEditable(false);
        TextField txtC = new TextField("inativo");
        txtC.setDisable(true);
        TextField txtD = new TextField("inativo e n\u00e3o edit\u00e1vel");
        txtD.setEditable(false);
        txtD.setDisable(true);
        TextField txtE = new TextField();
        txtE.setPromptText("Prompt...");
        PasswordField txtF = new PasswordField();
        txtF.setPromptText("Senha...");
        VBox box1 = this.createVbox();
        box1.getChildren().add((Object)txtA);
        box1.getChildren().add((Object)txtB);
        box1.getChildren().add((Object)txtC);
        VBox box2 = this.createVbox();
        box2.getChildren().add((Object)txtD);
        box2.getChildren().add((Object)txtE);
        box2.getChildren().add((Object)txtF);
        HBox box = this.createHbox();
        box.getChildren().add((Object)box1);
        box.getChildren().add((Object)box2);
        TitledPane pane = new TitledPane("Texts", (Node)box);
        return pane;
    }

    private HBox createTogglePane() {
        ToggleGroup radGrp = new ToggleGroup();
        ToggleButton elemA = new ToggleButton("Selected");
        elemA.setToggleGroup(radGrp);
        elemA.setSelected(true);
        ToggleButton elemB = new ToggleButton("Not Selected");
        elemB.setToggleGroup(radGrp);
        ToggleButton elemC = new ToggleButton("Disabled");
        elemC.setDisable(true);
        elemC.setToggleGroup(radGrp);
        HBox box = this.createHbox();
        box.getChildren().add((Object)elemA);
        box.getChildren().add((Object)elemB);
        box.getChildren().add((Object)elemC);
        return box;
    }

    private HBox createCheckPane() {
        CheckBox elemA = new CheckBox("Selected and Indeterminate");
        elemA.setSelected(true);
        elemA.setIndeterminate(true);
        CheckBox elemB = new CheckBox("Selected and Determinate");
        elemB.setSelected(true);
        elemB.setIndeterminate(false);
        elemB.setAllowIndeterminate(false);
        CheckBox elemC = new CheckBox("Unselected and Indeterminate");
        elemC.setSelected(false);
        elemC.setIndeterminate(true);
        CheckBox elemD = new CheckBox("Unselected and Determinate");
        elemD.setSelected(false);
        elemD.setIndeterminate(false);
        elemD.setAllowIndeterminate(false);
        CheckBox elemE = new CheckBox("Disabled and selected");
        elemE.setDisable(true);
        elemE.setSelected(true);
        CheckBox elemF = new CheckBox("Disabled and unselected");
        elemF.setDisable(true);
        elemF.setSelected(false);
        VBox box1 = this.createVbox();
        box1.getChildren().add((Object)elemA);
        box1.getChildren().add((Object)elemB);
        box1.getChildren().add((Object)elemC);
        VBox box2 = this.createVbox();
        box2.getChildren().add((Object)elemD);
        box2.getChildren().add((Object)elemE);
        box2.getChildren().add((Object)elemF);
        HBox box = this.createHbox();
        box.getChildren().add((Object)box1);
        box.getChildren().add((Object)box2);
        return box;
    }

    private HBox createComboPane() {
        ComboBox cmbA = new ComboBox();
        cmbA.getItems().addAll(new Object[]{"Option A", "Option B", "Option C"});
        cmbA.setValue((Object)"Option A");
        ComboBox cmbB = new ComboBox();
        cmbB.getItems().addAll(new Object[]{"Option A", "Option B", "Option C"});
        cmbB.setValue((Object)"Option A");
        cmbB.setDisable(true);
        HBox radBox = this.createHbox();
        radBox.getChildren().add((Object)cmbA);
        radBox.getChildren().add((Object)cmbB);
        return radBox;
    }

    private HBox createHiperlinkPane() {
        Hyperlink elemA = new Hyperlink();
        elemA.setText("http://www.enabled.com");
        Hyperlink elemB = new Hyperlink();
        elemB.setText("http://www.disabled.com");
        elemB.setDisable(true);
        HBox box = this.createHbox();
        box.getChildren().add((Object)elemA);
        box.getChildren().add((Object)elemB);
        return box;
    }

    private HBox createButtonPane() {
        Button cmbA = new Button("Enabled");
        cmbA.setTooltip(new Tooltip("This button is nice!"));
        Button cmbB = new Button("Disabled");
        cmbB.setDisable(true);
        cmbB.setTooltip(new Tooltip("This button is not nice!"));
        HBox box = this.createHbox();
        box.getChildren().add((Object)cmbA);
        box.getChildren().add((Object)cmbB);
        return box;
    }

    private HBox createRadioPane() {
        ToggleGroup radGrp = new ToggleGroup();
        RadioButton radA = new RadioButton("Selected");
        radA.setToggleGroup(radGrp);
        radA.setSelected(true);
        RadioButton radB = new RadioButton("Not Selected");
        radB.setToggleGroup(radGrp);
        RadioButton radC = new RadioButton("Disabled");
        radC.setToggleGroup(radGrp);
        radC.setDisable(true);
        HBox radBox = this.createHbox();
        radBox.getChildren().add((Object)radA);
        radBox.getChildren().add((Object)radB);
        radBox.getChildren().add((Object)radC);
        return radBox;
    }

    private HBox createSliderPane() {
        Slider elemA = new Slider();
        elemA.setMin(0.0);
        elemA.setMax(100.0);
        elemA.setValue(40.0);
        elemA.setShowTickLabels(true);
        elemA.setShowTickMarks(true);
        Slider elemB = new Slider();
        elemB.setMin(0.0);
        elemB.setMax(100.0);
        elemB.setValue(40.0);
        elemB.setShowTickLabels(false);
        elemB.setShowTickMarks(true);
        Slider elemC = new Slider();
        elemC.setMin(0.0);
        elemC.setMax(100.0);
        elemC.setValue(40.0);
        elemC.setShowTickLabels(false);
        elemC.setShowTickMarks(false);
        elemC.setDisable(true);
        HBox box = this.createHbox();
        box.getChildren().add((Object)elemA);
        box.getChildren().add((Object)elemB);
        box.getChildren().add((Object)elemC);
        return box;
    }

    private HBox createHbox() {
        HBox box = new HBox();
        box.setSpacing(5.0);
        box.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        return box;
    }

    private VBox createVbox() {
        VBox box = new VBox();
        box.setSpacing(5.0);
        box.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        return box;
    }

    @Override
    public Pane getWindowContent() {
        return this.pane;
    }

    @Override
    public WindowCallbacks getWindowCallbacks() {
        return this.callbacks;
    }
}

