package br.pucrio.tecgraf.soma.job.domain.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;

import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

import com.vladmihalcea.hibernate.type.json.JsonType;

/**
 * The Flow entity
 */
@Entity
@TypeDefs({
    @TypeDef(name = "json", typeClass = JsonType.class)
})
@Table(name = "flow")
public class Flow {

	// Identifier
	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "flow_generator")
	@SequenceGenerator(name = "flow_generator", sequenceName = "public.flow_seq", allocationSize = 1)
	@Column(name = "id", updatable = false, nullable = false)
	private long id;

	@Column(name = "name", nullable = false, columnDefinition = "VARCHAR")
	private String name = null;

	@Column(name = "flow_data", columnDefinition = "jsonb", nullable = false)
	@Type(type = "json")
	private Object flowData = null;

	@Column(name = "layout_data", columnDefinition = "jsonb")
	@Type(type = "json")
	private Object layoutData = null;

	public Flow() {
	}

	public void setId(long id) {
		this.id = id;
	}

	public long getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Object getFlowData() {
		return flowData;
	}

	public void setFlowData(Object flowData) {
		this.flowData = flowData;
	}

	public Object getLayoutData() {
		return layoutData;
	}

	public void setLayoutData(Object layoutData) {
		this.layoutData = layoutData;
	}

}
