package br.pucrio.tecgraf.soma.job.domain.model;

import java.util.ArrayList;
import java.util.List;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;

import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.Type;

/**
 * Job Algorithm Parameter Entity
 */
@Entity
@Table(name = "job_algo_params")
public class JobAlgorithmParameter {

  // Identifier
  @Id
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "job_algo_params_generator")
  @SequenceGenerator(name="job_algo_params_generator", sequenceName = "public.job_algo_params_seq", allocationSize=1)
  @Column(name = "id", updatable = false, nullable = false)
  private Long id;

  // The parameter identifier
  @Column(name = "param_id", nullable = false)
  private String parameterId;

  // Parameter label
  @Column(name = "param_label", nullable = false)
  private String label;

  // The type of the parameter
  @Column(name = "param_type", nullable = false)
  private String type;

  @ManyToOne
  @OnDelete(action = OnDeleteAction.CASCADE)
  @JoinColumn(name = "job_algo_id", nullable = false)
  private JobAlgorithm jobAlgorithm;

  // The list of values submitted in the parameter
  @ElementCollection(fetch = FetchType.EAGER)
  @CollectionTable(name = "job_param_values", joinColumns = @JoinColumn(name = "job_algo_param_id"))
  @Column(columnDefinition="TEXT")
  @JoinColumn(name = "id") // nome da coluna @Id do JobAlgorithmParameter
  @OnDelete(action = OnDeleteAction.CASCADE)
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "job_param_values_generator")
  @SequenceGenerator(name = "job_param_values_generator", sequenceName = "public.job_param_values_seq", allocationSize=1)
  @CollectionId(columns = {@Column(name="id")}, generator="job_param_values_generator", type=@Type(type="long"))
  @Fetch(value = FetchMode.SUBSELECT)
  private List<String> value = new ArrayList<String>();

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public String getParameterId() {
    return parameterId;
  }

  public void setParameterId(String parameterId) {
    this.parameterId = parameterId;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public JobAlgorithm getJobAlgorithm() {
    return jobAlgorithm;
  }

  public void setJobAlgorithm(JobAlgorithm jobAlgorithm) {
    this.jobAlgorithm = jobAlgorithm;
  }

  public List<String> getValue() {
    return value;
  }

  public void setValue(List<String> value) {
    this.value = value;
  }
}
