package br.pucrio.tecgraf.soma.job.domain.model;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;

import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name = "multiflow")
public class Multiflow {
    // Identifier
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "multiflow_generator")
    @SequenceGenerator(name = "multiflow_generator", sequenceName = "public.multiflow_seq", allocationSize = 1)
    @Column(name = "id", updatable = false, nullable = false)
    private long id;

    @Column(name = "name", nullable = false, columnDefinition = "VARCHAR")
    private String name = null;

    @CreationTimestamp
    @Column(name = "creation_time", updatable = false, nullable = false)
    private LocalDateTime creationTime;

    @UpdateTimestamp
    @Column(name = "last_modified_time", nullable = false)
    private LocalDateTime lastModifiedTime;

    @Column(name = "is_deleted", nullable = false)
    private boolean isDeleted = false;

    @Column(name = "project_id", nullable = false, columnDefinition = "VARCHAR")
    private String projectId = null;

    @ManyToOne
    @JoinColumn(name = "flow_id", foreignKey = @ForeignKey(name = "multiflow_flow_fk"), nullable = false)
    private Flow flow = null;

    @OneToMany(fetch = FetchType.EAGER, cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(name = "multiflow_id", foreignKey = @ForeignKey(name = "multiflow_replica_file_multiflow_fk"), nullable = false)
    @OrderBy("multiflow_id, is_deleted DESC, creation_time ASC") // a associação válida mais recente estará no final da lista
    private List<MultiflowReplicaFile> multiflowReplicaFiles = new ArrayList<>();

    public Multiflow() {
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getProjectId() {
		return projectId;
	}

    public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getLastModifiedTime() {
        return lastModifiedTime;
    }

    public void setLastModifiedTime(LocalDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Flow getFlow() {
        return flow;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public List<MultiflowReplicaFile> getMultiflowReplicaFiles() {
        return multiflowReplicaFiles;
    }

	public void addMultiflowReplicaFile(MultiflowReplicaFile multiflowReplicaFile) {
		multiflowReplicaFiles.add(multiflowReplicaFile);
	}
}
