package br.pucrio.tecgraf.soma.job.domain.model;

import java.time.LocalDateTime;

import jakarta.persistence.*;

import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;

@Entity
@Table(name = "multiflow_replica_file")
public class MultiflowReplicaFile {
    // Identifier
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "multiflow_replica_file_generator")
    @SequenceGenerator(name = "multiflow_replica_file_generator", sequenceName = "public.multiflow_replica_file_seq", allocationSize = 1)
    @Column(name = "id", updatable = false, nullable = false)
    private long id;

    @CreationTimestamp
    @Column(name = "creation_time", updatable = false, nullable = false)
    private LocalDateTime creationTime;

    @Column(name = "is_deleted", nullable = false)
    private boolean isDeleted = false;

    @ManyToOne
    @JoinColumn(name = "replica_file_id", foreignKey = @ForeignKey(name = "multiflow_replica_file_replica_file_fk"), nullable = false)
    private ReplicaFile replicaFile = null;

    @Column(name = "parameter_mapping", columnDefinition = "jsonb DEFAULT '{}'::jsonb", nullable = false)
    @Type(type = "json")
    private Object parameterMapping = null;

    public MultiflowReplicaFile() {
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public ReplicaFile getReplicaFile() {
        return replicaFile;
    }

    public void setReplicaFile(ReplicaFile replicaFile) {
        this.replicaFile = replicaFile;
    }

    public Object getParameterMapping() {
        return parameterMapping;
    }

    public void setParameterMapping(Object parameterMapping) {
        this.parameterMapping = parameterMapping;
    }

    @PrePersist
    public void onCreate(){
        if (parameterMapping == null) {
            parameterMapping = "{}";
        }
    }
}
