package br.pucrio.tecgraf.soma.serviceapi;

import java.util.Properties;
import java.util.Set;

import jakarta.persistence.Entity;
import jakarta.persistence.EntityManagerFactory;

import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.reflections.Reflections;


public class ServiceContext {

	private EntityManagerFactory entityManagerFactory;
	private String hibernateConfigFilePath;
	private String[] hibernateAnnotatedPackages;
	private Properties hibernateProperties;

	public ServiceContext(Properties hibernateProperties, String hibernateConfigFilePath, String... hibernateAnnotatedPackages) {
		this.hibernateProperties = hibernateProperties;
		this.hibernateConfigFilePath = hibernateConfigFilePath;
		this.hibernateAnnotatedPackages = hibernateAnnotatedPackages;
		buildHibernateSessionFactory();
	}

	protected void buildHibernateSessionFactory() {
		Configuration configuration = new Configuration();
		for (int i = 0; i < hibernateAnnotatedPackages.length; i++) {
			Reflections reflections = new Reflections(hibernateAnnotatedPackages[i]);
			Set<Class<? extends Object>> allEntites = reflections.getTypesAnnotatedWith(Entity.class);
			for (Class<? extends Object> c : allEntites) {
				configuration.addAnnotatedClass(c);
			}

		}
		configuration.configure(hibernateConfigFilePath);
		if(this.hibernateProperties != null) {
			configuration.addProperties(this.hibernateProperties);
		}
		ServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(configuration.getProperties()).build();
		entityManagerFactory = configuration.buildSessionFactory(serviceRegistry);
	}

	public EntityManagerFactory getEntityManagerFactory() {
		return entityManagerFactory;
	}
	
	public void finalize() {
		if(entityManagerFactory != null && entityManagerFactory.isOpen())
			entityManagerFactory.close();
	}


}