package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Predicate;

import java.util.List;

@Transactional
@Repository
public class JobAlgorithmRepository extends JPARepository<JobAlgorithm> {

  @PersistenceContext private EntityManager _entityManager;

  @Override
  public Class<JobAlgorithm> getType() {
    return JobAlgorithm.class;
  }

  @Override
  public EntityManager getEntityManager() {
    return _entityManager;
  }

  public void setEntityManager(EntityManager entityManager) {
    this._entityManager = entityManager;
  }

  public List<JobAlgorithm> findDistinct(JPASpecification<JobAlgorithm> specification) {
    CriteriaBuilder criteriaBuilder = getEntityManager().getCriteriaBuilder();
    CriteriaQuery<JobAlgorithm> queryCriteria = criteriaBuilder.createQuery(JobAlgorithm.class);
    Root<JobAlgorithm> from = queryCriteria.from(JobAlgorithm.class);
    Predicate condition = specification.toPredicate(from, criteriaBuilder);

    queryCriteria.multiselect(from.get("algorithmId"), from.get("algorithmName"))
                 .where(condition)
                 .groupBy(from.get("algorithmId"), from.get("algorithmName"))
                 .orderBy(criteriaBuilder.asc(from.get("algorithmName")));

    TypedQuery<JobAlgorithm> query = getEntityManager().createQuery(queryCriteria);
    return query.getResultList();
  }
}
