/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.util.ArrayList;
import oracle.spatial.geometry.J3D_Geometry;

public class ElementExtractor {
    public static final int MULTICOMP_TOSIMPLE = 0;
    public static final int INNER_OUTER = 1;
    public static final int LOWER_LEVEL = 2;
    private static final int ANYTYPE = -1;
    private boolean allow_comp_sub_elements = true;
    private int ordoffset;
    private int curoffset;
    private int dim = 3;
    private J3D_Geometry curGeom = null;
    private J3D_Geometry newGeom = null;
    private int extract_type = 0;
    private int global_etype;
    private int comcnt;
    private boolean invalidIterator = true;
    private boolean curSolid = false;
    private int expType = -1;
    private int expOrient = 1;
    public static final int GTYPE_POINT = 1;
    public static final int GTYPE_CURVE = 2;
    public static final int GTYPE_SURFACE = 3;
    public static final int GTYPE_POLYGON = 3;
    public static final int GTYPE_COLLECTION = 4;
    public static final int GTYPE_SOLID = 8;
    public static final int GTYPE_MULTIPOINT = 5;
    public static final int GTYPE_MULTICURVE = 6;
    public static final int GTYPE_MULTISURFACE = 7;
    public static final int GTYPE_MULTIPOLYGON = 7;
    public static final int GTYPE_MULTISOLID = 9;
    public static final int ETYPE_UNKNOWN = 0;
    public static final int ETYPE_POINT = 1;
    public static final int ETYPE_CURVE = 2;
    public static final int ETYPE_RING = 3;
    public static final int ETYPE_POLYGON = 3;
    public static final int ETYPE_SURFACE = 3;
    public static final int ETYPE_SOLID = 7;
    public static final int ETYPE_COMPOUNDCURVE = 4;
    public static final int ETYPE_COMPOUNDRING = 5;
    public static final int ETYPE_COMPOSITEPOLYGON = 6;
    public static final int ETYPE_COMPOSITESURFACE = 6;
    public static final int ETYPE_COMPOSITESOLID = 8;

    public ElementExtractor(J3D_Geometry j3D_Geometry, int n, int n2, boolean bl) throws Exception {
        this.allow_comp_sub_elements = bl;
        this.newGeom = this.expandSolid(j3D_Geometry);
        this.initConstructor(this.newGeom, n, n2);
    }

    public ElementExtractor(J3D_Geometry j3D_Geometry, int n, int n2) throws Exception {
        this.newGeom = this.expandSolid(j3D_Geometry);
        this.initConstructor(this.newGeom, n, n2);
    }

    public ElementExtractor(J3D_Geometry j3D_Geometry, int n) throws Exception {
        this.newGeom = this.expandSolid(j3D_Geometry);
        this.initConstructor(this.newGeom, 0, n);
    }

    public ElementExtractor(J3D_Geometry j3D_Geometry, int n, int n2, int n3, boolean bl) throws Exception {
        this.allow_comp_sub_elements = bl;
        this.dim = n3;
        this.newGeom = this.expandSolid(j3D_Geometry);
        this.initConstructor(this.newGeom, n, n2);
    }

    public ElementExtractor(J3D_Geometry j3D_Geometry, int n, int n2, int n3) throws Exception {
        this.dim = n3;
        this.newGeom = this.expandSolid(j3D_Geometry);
        this.initConstructor(this.newGeom, n, n2);
    }

    public ElementExtractor(J3D_Geometry j3D_Geometry) throws Exception {
        this.newGeom = this.expandSolid(j3D_Geometry);
        int n = 3;
        this.ordoffset = 1;
        this.allow_comp_sub_elements = true;
        int n2 = this.newGeom.getElemInfo()[1] % 1000;
        int n3 = this.newGeom.getType();
        if (n3 == 9 || n3 == 7 || n3 == 6 || n3 == 5 || n3 == 4 || n2 == 8 || n2 == 4 || n2 == 6 || n2 == 2 && this.newGeom.getOrdinatesArray().length != n * 2) {
            this.initConstructor(this.newGeom, 0, 0);
        } else if (n2 == 7 || n2 == 2 && this.newGeom.getOrdinatesArray().length == 2 * n) {
            this.initConstructor(this.newGeom, 0, 2);
        } else {
            int[] nArray = new int[1];
            this.initConstructor(this.newGeom, 0, 1);
            this.readElem(0, nArray);
            int[] nArray2 = this.newGeom.getElemInfo();
            if (nArray[0] + 2 >= nArray2.length || nArray2[nArray[0] + 2] / 1000 <= 1) {
                this.initConstructor(this.newGeom, 0, 2);
            }
        }
    }

    protected J3D_Geometry expandSolid(J3D_Geometry j3D_Geometry) throws Exception {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n + 2 < j3D_Geometry.getElemInfo().length) {
            if (j3D_Geometry.getElemInfo()[n + 1] == 1007 && j3D_Geometry.getElemInfo()[n + 2] == 3) {
                arrayList.add(new Integer(n));
            }
            n += 3;
        }
        if (arrayList.size() == 0) {
            return j3D_Geometry;
        }
        double[] dArray = new double[j3D_Geometry.getOrdinatesArray().length + 84 * arrayList.size()];
        int[] nArray = new int[j3D_Geometry.getElemInfo().length + 21 * arrayList.size()];
        double[] dArray2 = new double[j3D_Geometry.getOrdinatesArray().length];
        int[] nArray2 = new int[j3D_Geometry.getElemInfo().length];
        for (n = 0; n < j3D_Geometry.getElemInfo().length; ++n) {
            nArray2[n] = j3D_Geometry.getElemInfo()[n];
            nArray[n] = j3D_Geometry.getElemInfo()[n];
        }
        for (n = 0; n < j3D_Geometry.getOrdinatesArray().length; ++n) {
            dArray2[n] = j3D_Geometry.getOrdinatesArray()[n];
            dArray[n] = j3D_Geometry.getOrdinatesArray()[n];
        }
        for (n = 0; n < arrayList.size(); ++n) {
            int n2;
            int n3 = (Integer)arrayList.get(n);
            this.expandElemInfo(nArray, n3 + n * 21, nArray2[n3] + n * 84);
            this.expandOrdinates(dArray, nArray2[n3] + n * 84 - 1, dArray2, nArray2[n3] - 1);
            if (n3 + 3 >= nArray2.length) continue;
            int n4 = n3 + 3 + (n + 1) * 21;
            for (n2 = n3 + 3; n2 < nArray2.length; ++n2) {
                nArray[n4] = n2 % 3 == 0 ? nArray2[n2] + (n + 1) * 84 : nArray2[n2];
                ++n4;
            }
            n4 = nArray2[n3 + 3] + (n + 1) * 84 - 1;
            for (n2 = nArray2[n3 + 3] - 1; n2 < dArray2.length; ++n2) {
                dArray[n4] = dArray2[n2];
                ++n4;
            }
        }
        int n5 = j3D_Geometry.getType();
        J3D_Geometry j3D_Geometry2 = new J3D_Geometry(n5, 0, nArray, dArray);
        return j3D_Geometry2;
    }

    private void expandElemInfo(int[] nArray, int n, int n2) {
        nArray[n + 0] = n2 + 1 - 1;
        nArray[n + 1] = 1007;
        nArray[n + 2] = 1;
        nArray[n + 3] = n2 + 1 - 1;
        nArray[n + 4] = 1006;
        nArray[n + 5] = 6;
        nArray[n + 6] = n2 + 1 - 1;
        nArray[n + 7] = 1003;
        nArray[n + 8] = 1;
        nArray[n + 9] = n2 + 16 - 1;
        nArray[n + 10] = 1003;
        nArray[n + 11] = 1;
        nArray[n + 12] = n2 + 31 - 1;
        nArray[n + 13] = 1003;
        nArray[n + 14] = 1;
        nArray[n + 15] = n2 + 46 - 1;
        nArray[n + 16] = 1003;
        nArray[n + 17] = 1;
        nArray[n + 18] = n2 + 61 - 1;
        nArray[n + 19] = 1003;
        nArray[n + 20] = 1;
        nArray[n + 21] = n2 + 76 - 1;
        nArray[n + 22] = 1003;
        nArray[n + 23] = 1;
    }

    private void expandOrdinates(double[] dArray, int n, double[] dArray2, int n2) throws Exception {
        if (dArray2[n2 + 0] < dArray2[n2 + 3] && dArray2[n2 + 1] < dArray2[n2 + 4] && dArray2[n2 + 2] < dArray2[n2 + 5]) {
            dArray[n + 0] = dArray2[n2 + 0];
            dArray[n + 1] = dArray2[n2 + 1];
            dArray[n + 2] = dArray2[n2 + 2];
            dArray[n + 3] = dArray2[n2 + 0];
            dArray[n + 4] = dArray2[n2 + 4];
            dArray[n + 5] = dArray2[n2 + 2];
            dArray[n + 6] = dArray2[n2 + 3];
            dArray[n + 7] = dArray2[n2 + 4];
            dArray[n + 8] = dArray2[n2 + 2];
            dArray[n + 9] = dArray2[n2 + 3];
            dArray[n + 10] = dArray2[n2 + 1];
            dArray[n + 11] = dArray2[n2 + 2];
            dArray[n + 12] = dArray2[n2 + 0];
            dArray[n + 13] = dArray2[n2 + 1];
            dArray[n + 14] = dArray2[n2 + 2];
            dArray[n + 15] = dArray2[n2 + 3];
            dArray[n + 16] = dArray2[n2 + 4];
            dArray[n + 17] = dArray2[n2 + 5];
            dArray[n + 18] = dArray2[n2 + 0];
            dArray[n + 19] = dArray2[n2 + 4];
            dArray[n + 20] = dArray2[n2 + 5];
            dArray[n + 21] = dArray2[n2 + 0];
            dArray[n + 22] = dArray2[n2 + 1];
            dArray[n + 23] = dArray2[n2 + 5];
            dArray[n + 24] = dArray2[n2 + 3];
            dArray[n + 25] = dArray2[n2 + 1];
            dArray[n + 26] = dArray2[n2 + 5];
            dArray[n + 27] = dArray2[n2 + 3];
            dArray[n + 28] = dArray2[n2 + 4];
            dArray[n + 29] = dArray2[n2 + 5];
            dArray[n + 30] = dArray2[n2 + 0];
            dArray[n + 31] = dArray2[n2 + 1];
            dArray[n + 32] = dArray2[n2 + 2];
            dArray[n + 33] = dArray2[n2 + 3];
            dArray[n + 34] = dArray2[n2 + 1];
            dArray[n + 35] = dArray2[n2 + 2];
            dArray[n + 36] = dArray2[n2 + 3];
            dArray[n + 37] = dArray2[n2 + 1];
            dArray[n + 38] = dArray2[n2 + 5];
            dArray[n + 39] = dArray2[n2 + 0];
            dArray[n + 40] = dArray2[n2 + 1];
            dArray[n + 41] = dArray2[n2 + 5];
            dArray[n + 42] = dArray2[n2 + 0];
            dArray[n + 43] = dArray2[n2 + 1];
            dArray[n + 44] = dArray2[n2 + 2];
            dArray[n + 45] = dArray2[n2 + 0];
            dArray[n + 46] = dArray2[n2 + 1];
            dArray[n + 47] = dArray2[n2 + 2];
            dArray[n + 48] = dArray2[n2 + 0];
            dArray[n + 49] = dArray2[n2 + 1];
            dArray[n + 50] = dArray2[n2 + 5];
            dArray[n + 51] = dArray2[n2 + 0];
            dArray[n + 52] = dArray2[n2 + 4];
            dArray[n + 53] = dArray2[n2 + 5];
            dArray[n + 54] = dArray2[n2 + 0];
            dArray[n + 55] = dArray2[n2 + 4];
            dArray[n + 56] = dArray2[n2 + 2];
            dArray[n + 57] = dArray2[n2 + 0];
            dArray[n + 58] = dArray2[n2 + 1];
            dArray[n + 59] = dArray2[n2 + 2];
            dArray[n + 60] = dArray2[n2 + 3];
            dArray[n + 61] = dArray2[n2 + 4];
            dArray[n + 62] = dArray2[n2 + 5];
            dArray[n + 63] = dArray2[n2 + 3];
            dArray[n + 64] = dArray2[n2 + 4];
            dArray[n + 65] = dArray2[n2 + 2];
            dArray[n + 66] = dArray2[n2 + 0];
            dArray[n + 67] = dArray2[n2 + 4];
            dArray[n + 68] = dArray2[n2 + 2];
            dArray[n + 69] = dArray2[n2 + 0];
            dArray[n + 70] = dArray2[n2 + 4];
            dArray[n + 71] = dArray2[n2 + 5];
            dArray[n + 72] = dArray2[n2 + 3];
            dArray[n + 73] = dArray2[n2 + 4];
            dArray[n + 74] = dArray2[n2 + 5];
            dArray[n + 75] = dArray2[n2 + 3];
            dArray[n + 76] = dArray2[n2 + 4];
            dArray[n + 77] = dArray2[n2 + 5];
            dArray[n + 78] = dArray2[n2 + 3];
            dArray[n + 79] = dArray2[n2 + 1];
            dArray[n + 80] = dArray2[n2 + 5];
            dArray[n + 81] = dArray2[n2 + 3];
            dArray[n + 82] = dArray2[n2 + 1];
            dArray[n + 83] = dArray2[n2 + 2];
            dArray[n + 84] = dArray2[n2 + 3];
            dArray[n + 85] = dArray2[n2 + 4];
            dArray[n + 86] = dArray2[n2 + 2];
            dArray[n + 87] = dArray2[n2 + 3];
            dArray[n + 88] = dArray2[n2 + 4];
            dArray[n + 89] = dArray2[n2 + 5];
        } else if (dArray2[n2 + 0] > dArray2[n2 + 3] && dArray2[n2 + 1] > dArray2[n2 + 4] && dArray2[n2 + 2] > dArray2[n2 + 5]) {
            dArray[n + 0] = dArray2[n2 + 3];
            dArray[n + 1] = dArray2[n2 + 4];
            dArray[n + 2] = dArray2[n2 + 5];
            dArray[n + 3] = dArray2[n2 + 3];
            dArray[n + 4] = dArray2[n2 + 1];
            dArray[n + 5] = dArray2[n2 + 5];
            dArray[n + 6] = dArray2[n2 + 0];
            dArray[n + 7] = dArray2[n2 + 1];
            dArray[n + 8] = dArray2[n2 + 5];
            dArray[n + 9] = dArray2[n2 + 0];
            dArray[n + 10] = dArray2[n2 + 4];
            dArray[n + 11] = dArray2[n2 + 5];
            dArray[n + 12] = dArray2[n2 + 3];
            dArray[n + 13] = dArray2[n2 + 4];
            dArray[n + 14] = dArray2[n2 + 5];
            dArray[n + 15] = dArray2[n2 + 0];
            dArray[n + 16] = dArray2[n2 + 1];
            dArray[n + 17] = dArray2[n2 + 2];
            dArray[n + 18] = dArray2[n2 + 3];
            dArray[n + 19] = dArray2[n2 + 1];
            dArray[n + 20] = dArray2[n2 + 2];
            dArray[n + 21] = dArray2[n2 + 3];
            dArray[n + 22] = dArray2[n2 + 4];
            dArray[n + 23] = dArray2[n2 + 2];
            dArray[n + 24] = dArray2[n2 + 0];
            dArray[n + 25] = dArray2[n2 + 4];
            dArray[n + 26] = dArray2[n2 + 2];
            dArray[n + 27] = dArray2[n2 + 0];
            dArray[n + 28] = dArray2[n2 + 1];
            dArray[n + 29] = dArray2[n2 + 2];
            dArray[n + 30] = dArray2[n2 + 3];
            dArray[n + 31] = dArray2[n2 + 4];
            dArray[n + 32] = dArray2[n2 + 5];
            dArray[n + 33] = dArray2[n2 + 0];
            dArray[n + 34] = dArray2[n2 + 4];
            dArray[n + 35] = dArray2[n2 + 5];
            dArray[n + 36] = dArray2[n2 + 0];
            dArray[n + 37] = dArray2[n2 + 4];
            dArray[n + 38] = dArray2[n2 + 2];
            dArray[n + 39] = dArray2[n2 + 3];
            dArray[n + 40] = dArray2[n2 + 4];
            dArray[n + 41] = dArray2[n2 + 2];
            dArray[n + 42] = dArray2[n2 + 3];
            dArray[n + 43] = dArray2[n2 + 4];
            dArray[n + 44] = dArray2[n2 + 5];
            dArray[n + 45] = dArray2[n2 + 3];
            dArray[n + 46] = dArray2[n2 + 4];
            dArray[n + 47] = dArray2[n2 + 5];
            dArray[n + 48] = dArray2[n2 + 3];
            dArray[n + 49] = dArray2[n2 + 4];
            dArray[n + 50] = dArray2[n2 + 2];
            dArray[n + 51] = dArray2[n2 + 3];
            dArray[n + 52] = dArray2[n2 + 1];
            dArray[n + 53] = dArray2[n2 + 2];
            dArray[n + 54] = dArray2[n2 + 3];
            dArray[n + 55] = dArray2[n2 + 1];
            dArray[n + 56] = dArray2[n2 + 5];
            dArray[n + 57] = dArray2[n2 + 3];
            dArray[n + 58] = dArray2[n2 + 4];
            dArray[n + 59] = dArray2[n2 + 5];
            dArray[n + 60] = dArray2[n2 + 0];
            dArray[n + 61] = dArray2[n2 + 1];
            dArray[n + 62] = dArray2[n2 + 2];
            dArray[n + 63] = dArray2[n2 + 0];
            dArray[n + 64] = dArray2[n2 + 1];
            dArray[n + 65] = dArray2[n2 + 5];
            dArray[n + 66] = dArray2[n2 + 3];
            dArray[n + 67] = dArray2[n2 + 1];
            dArray[n + 68] = dArray2[n2 + 5];
            dArray[n + 69] = dArray2[n2 + 3];
            dArray[n + 70] = dArray2[n2 + 1];
            dArray[n + 71] = dArray2[n2 + 2];
            dArray[n + 72] = dArray2[n2 + 0];
            dArray[n + 73] = dArray2[n2 + 1];
            dArray[n + 74] = dArray2[n2 + 2];
            dArray[n + 75] = dArray2[n2 + 0];
            dArray[n + 76] = dArray2[n2 + 1];
            dArray[n + 77] = dArray2[n2 + 2];
            dArray[n + 78] = dArray2[n2 + 0];
            dArray[n + 79] = dArray2[n2 + 4];
            dArray[n + 80] = dArray2[n2 + 2];
            dArray[n + 81] = dArray2[n2 + 0];
            dArray[n + 82] = dArray2[n2 + 4];
            dArray[n + 83] = dArray2[n2 + 5];
            dArray[n + 84] = dArray2[n2 + 0];
            dArray[n + 85] = dArray2[n2 + 1];
            dArray[n + 86] = dArray2[n2 + 5];
            dArray[n + 87] = dArray2[n2 + 0];
            dArray[n + 88] = dArray2[n2 + 1];
            dArray[n + 89] = dArray2[n2 + 2];
        } else {
            throw new Exception("54525");
        }
    }

    private void initConstructor(J3D_Geometry j3D_Geometry, int n, int n2) throws Exception {
        this.invalidIterator = false;
        if (j3D_Geometry.getType() / 1000 != 0) {
            this.dim = j3D_Geometry.getType() / 1000;
        }
        this.ordoffset = j3D_Geometry.getElemInfo()[n];
        this.curoffset = n;
        this.curGeom = j3D_Geometry;
        this.extract_type = n2;
        this.global_etype = j3D_Geometry.getElemInfo()[1] % 1000;
        this.comcnt = j3D_Geometry.getElemInfo()[2];
        int n3 = j3D_Geometry.getType();
        int n4 = j3D_Geometry.getElemInfo()[n + 1] % 1000;
        int n5 = j3D_Geometry.getElemInfo()[n + 2];
        int n6 = j3D_Geometry.getElemInfo()[n + 1] / 1000;
        int n7 = j3D_Geometry.getOrdinatesArray().length;
        this.curSolid = false;
        if (n3 == 8 || n3 == 9) {
            this.curSolid = true;
        }
        this.chkVldty(n3, n4, n5, n7);
        if (n4 == 8 && this.extract_type == 0 && this.allow_comp_sub_elements && n3 != 9 && n3 != 4) {
            this.expType = 7;
            this.expOrient = n6;
            this.curoffset += 3;
        } else if (n4 == 8 && this.extract_type == 0 && !this.allow_comp_sub_elements) {
            this.expType = 7;
            this.expOrient = n6;
            this.curoffset += 3;
        } else if (n4 == 6 && this.extract_type == 0 && this.allow_comp_sub_elements && n3 != 7 && n3 != 4) {
            this.expType = 3;
            this.expOrient = n6;
            this.curoffset += 3;
        } else if (n4 == 6 && this.extract_type == 0 && !this.allow_comp_sub_elements) {
            this.expType = 3;
            this.expOrient = n6;
            this.curoffset += 3;
        } else if (n3 == 8 && this.extract_type == 2) {
            this.expType = 6;
            this.expOrient = n6;
            this.curoffset += 3;
        } else {
            this.expType = -1;
        }
    }

    private void chkVldty(int n, int n2, int n3, int n4) throws Exception {
        if (this.extract_type != 0 && (n == 9 || n == 7 || n == 6 || n == 5 || n2 == 2 && n4 != 6 || n == 4)) {
            this.invalidIterator = true;
            throw new Exception("54526");
        }
        if (this.extract_type == 0 && n != 9 && n != 7 && n != 6 && n != 5 && n != 4 && (n2 != 2 || n4 == 6) && n2 != 8 && n2 != 6) {
            this.invalidIterator = true;
            throw new Exception("54527");
        }
        if (this.extract_type == 1 && n2 != 3 && n2 != 6) {
            this.invalidIterator = true;
            throw new Exception("54528");
        }
        if (this.extract_type != 2 && n2 == 7 && n == 8) {
            this.invalidIterator = true;
            throw new Exception("54529");
        }
        if (this.extract_type == 2 && n2 == 7 && n == 8 && n3 != 1) {
            this.invalidIterator = true;
            throw new Exception("13033");
        }
    }

    private void getElementEnd(int n, int[] nArray, int[] nArray2, int[] nArray3) throws Exception {
        int[] nArray4 = new int[1];
        int n2 = n;
        int n3 = this.curGeom.getType();
        nArray[0] = -1;
        nArray2[0] = -1;
        if (this.curGeom == null || this.curGeom.getElemInfo() == null || this.curoffset < 0) {
            return;
        }
        if (this.invalidIterator) {
            return;
        }
        int n4 = this.curGeom.getElemInfo()[n];
        int n5 = this.curGeom.getElemInfo()[n + 1] % 1000;
        int n6 = this.curGeom.getElemInfo()[n + 2];
        int n7 = this.curGeom.getElemInfo()[n + 1] / 1000;
        if (this.expType != -1 && n5 != this.expType) {
            this.invalidIterator = true;
            throw new Exception("54530");
        }
        if (this.expType != -1 && n7 != this.expOrient) {
            this.invalidIterator = true;
            throw new Exception("54531");
        }
        if (this.curGeom.getElemInfo()[n + 1] == 1007 && n6 != 1 && n6 != 3) {
            this.invalidIterator = true;
            throw new Exception("54530");
        }
        if (this.curGeom.getElemInfo()[n + 1] == 2007) {
            this.invalidIterator = true;
            throw new Exception("54530");
        }
        if (this.extract_type == 0) {
            this.readElemWithInteriors(n2, nArray4);
        } else if (this.extract_type == 1) {
            this.readElem(n2, nArray4);
        } else if (this.extract_type == 2) {
            this.readElemWithInteriors(n2, nArray4);
        }
        nArray[0] = n2;
        nArray2[0] = nArray4[0];
        if (nArray4[0] + 1 < this.curGeom.getElemInfo().length && this.curSolid) {
            n2 = nArray2[0] + 1;
            int n8 = this.curGeom.getElemInfo()[n2 + 1];
            if (n8 != 2006) {
                this.curSolid = false;
            }
        } else {
            this.curSolid = false;
        }
    }

    private void readElemWithInteriors(int n, int[] nArray) throws Exception {
        int n2 = n;
        int[] nArray2 = new int[]{n2};
        if (n2 + 1 > this.curGeom.getElemInfo().length) {
            throw new Exception("13033");
        }
        int n3 = this.curGeom.getElemInfo()[n2 + 1];
        while (n2 < this.curGeom.getElemInfo().length) {
            int n4;
            this.readElem(n2, nArray2);
            n2 = nArray2[0] + 1;
            if (n2 >= this.curGeom.getElemInfo().length) continue;
            int n5 = this.curGeom.getElemInfo()[n2];
            int n6 = this.curGeom.getElemInfo()[n2 + 1];
            int n7 = this.curGeom.getElemInfo()[n2 + 2];
            if (n6 == 1006) {
                this.comcnt = this.curGeom.getElemInfo()[n2 + 2];
            }
            if ((n4 = n6 - n3) < 0) {
                n4 = -n4;
            }
            if (n4 != 1000) break;
            this.readElem(n2, nArray2);
        }
        nArray[0] = nArray2[0];
    }

    private void readElem(int n, int[] nArray) throws Exception {
        int[] nArray2 = new int[]{n};
        int n2 = n;
        if (n2 + 1 > this.curGeom.getElemInfo().length) {
            throw new Exception("13033");
        }
        int n3 = this.curGeom.getElemInfo()[n2 + 1] % 1000;
        int n4 = this.curGeom.getElemInfo()[n2 + 2];
        int n5 = this.curGeom.getElemInfo()[n2 + 1] / 1000;
        int n6 = this.curGeom.getElemInfo().length;
        switch (n3) {
            case 8: {
                n2 += 3;
                int n7 = n4;
                for (int i = 0; i < n7; ++i) {
                    if (n2 + 3 > n6) {
                        this.invalidIterator = true;
                        nArray2[0] = -1;
                        throw new Exception("54557");
                    }
                    this.readElemWithInteriors(n2 += 3, nArray2);
                    n2 = nArray2[0] + 1;
                    if (i >= n7 - 1) continue;
                    if (n2 + 1 > n6) {
                        this.invalidIterator = true;
                        nArray2[0] = -1;
                        throw new Exception("54557");
                    }
                    int n8 = this.curGeom.getElemInfo()[n2 + 1];
                    if (n8 == n5 * 1000 + 7) continue;
                    this.invalidIterator = true;
                    nArray2[0] = -1;
                    throw new Exception("54533");
                }
                nArray2[0] = n2 - 1;
                break;
            }
            case 4: {
                n2 += 3;
                for (int i = 0; i < n4; ++i) {
                    this.readElemWithInteriors(n2, nArray2);
                    n2 = nArray2[0] + 1;
                }
                break;
            }
            case 6: {
                if (this.curSolid) {
                    n2 += 3;
                    int n9 = n4;
                    for (int i = 0; i < n9; ++i) {
                        if (n2 + 3 > n6) {
                            this.invalidIterator = true;
                            nArray2[0] = -1;
                            throw new Exception("54532");
                        }
                        int n10 = this.curGeom.getElemInfo()[n2 + 1];
                        if (n10 != n5 * 1000 + 3) {
                            this.invalidIterator = true;
                            nArray2[0] = -1;
                            throw new Exception("54533");
                        }
                        n2 += 3;
                    }
                } else {
                    n2 += 3;
                    int n11 = n4;
                    block12: for (int i = 0; i < n11; ++i) {
                        if (n2 + 3 > n6) {
                            this.invalidIterator = true;
                            nArray2[0] = -1;
                            throw new Exception("54532");
                        }
                        int n12 = this.curGeom.getElemInfo()[n2 + 1];
                        if (n12 != n5 * 1000 + 3) {
                            this.invalidIterator = true;
                            nArray2[0] = -1;
                            throw new Exception("54533");
                        }
                        n2 += 3;
                        while (n2 < n6) {
                            int n13;
                            if (n2 + 3 > n6) {
                                this.invalidIterator = true;
                                nArray2[0] = -1;
                                throw new Exception("54532");
                            }
                            n12 = this.curGeom.getElemInfo()[n2 + 1];
                            if (n12 != (n13 = n5 == 1 ? 2003 : 1003)) continue block12;
                            n2 += 3;
                        }
                    }
                }
                nArray2[0] = n2 - 1;
                break;
            }
            case 7: {
                if (n4 == 1) {
                    this.curSolid = true;
                    this.readElemWithInteriors(n2 += 3, nArray2);
                    break;
                }
                if (n4 != 3) break;
                nArray2[0] = n2 + 2;
                break;
            }
            case 3: {
                nArray2[0] = n2 + 2;
                break;
            }
            case 2: {
                nArray2[0] = n2 + 2;
                break;
            }
            case 1: {
                nArray2[0] = n2 + 2;
                break;
            }
            default: {
                throw new Exception("54530");
            }
        }
        nArray[0] = nArray2[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private J3D_Geometry getElement(int n, int n2, int[] nArray) throws Exception {
        int n3 = 3000;
        int n4 = this.curGeom.getElemInfo().length;
        int n5 = this.curGeom.getElemInfo()[n];
        int n6 = this.curGeom.getElemInfo()[n + 1];
        int n7 = n2 + 1 != n4 ? this.curGeom.getElemInfo()[n2 + 1] - 1 : this.curGeom.getOrdinatesArray().length;
        int[] nArray2 = new int[n2 - n + 1];
        this.copyElemInfo(nArray2, n, n2);
        int n8 = 0;
        for (int i = n; i < n2; i += 3) {
            nArray2[n8] = nArray2[n8] - (n5 - 1);
            n8 += 3;
        }
        if (n7 < n5) {
            throw new Exception("13033");
        }
        double[] dArray = new double[n7 - n5 + 1];
        this.copyOrds(dArray, n5 - 1, n7 - 1);
        nArray[0] = n6 / 1000;
        switch (n6 %= 1000) {
            case 7: 
            case 8: {
                n3 = this.dim * 1000 + 8;
                break;
            }
            case 3: 
            case 6: {
                n3 = this.dim * 1000 + 3;
                break;
            }
            case 2: 
            case 4: {
                n3 = this.dim * 1000 + 2;
                break;
            }
            case 1: {
                n3 = this.dim * 1000 + 1;
            }
        }
        int n9 = 0;
        if (nArray2.length == 3 && nArray2[1] % 1000 == 3 && nArray2[2] != 1 && nArray2[2] != 3) {
            throw new Exception("13033");
        }
        if (nArray2.length == 3 && nArray2[1] % 1000 == 3 && (nArray2[2] == 1 && dArray.length == 6 || nArray2[2] == 3 && dArray.length != 6)) {
            J3D_Geometry j3D_Geometry = new J3D_Geometry(n3, n9, nArray2, dArray);
            throw new Exception("54534");
        }
        if (nArray2.length != 3) return new J3D_Geometry(n3, n9, nArray2, dArray);
        if (nArray2[2] != 3) return new J3D_Geometry(n3, n9, nArray2, dArray);
        if (nArray2[1] % 1000 != 3) return new J3D_Geometry(n3, n9, nArray2, dArray);
        if (dArray.length != 6) return new J3D_Geometry(n3, n9, nArray2, dArray);
        double[] dArray2 = new double[15];
        if (dArray[0] <= dArray[3] && dArray[1] <= dArray[4] && dArray[2] <= dArray[5]) {
            if (dArray[0] == dArray[3] && dArray[1] != dArray[4] && dArray[2] != dArray[5]) {
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                dArray2[2] = dArray[2];
                dArray2[3] = dArray[0];
                dArray2[4] = dArray[4];
                dArray2[5] = dArray[2];
                dArray2[6] = dArray[0];
                dArray2[7] = dArray[4];
                dArray2[8] = dArray[5];
                dArray2[9] = dArray[0];
                dArray2[10] = dArray[1];
                dArray2[11] = dArray[5];
                dArray2[12] = dArray[0];
                dArray2[13] = dArray[1];
                dArray2[14] = dArray[2];
                nArray2[2] = 1;
                return new J3D_Geometry(n3, n9, nArray2, dArray2);
            }
            if (dArray[1] == dArray[4] && dArray[0] != dArray[3] && dArray[2] != dArray[5]) {
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                dArray2[2] = dArray[2];
                dArray2[3] = dArray[0];
                dArray2[4] = dArray[1];
                dArray2[5] = dArray[5];
                dArray2[6] = dArray[3];
                dArray2[7] = dArray[1];
                dArray2[8] = dArray[5];
                dArray2[9] = dArray[3];
                dArray2[10] = dArray[1];
                dArray2[11] = dArray[2];
                dArray2[12] = dArray[0];
                dArray2[13] = dArray[1];
                dArray2[14] = dArray[2];
                nArray2[2] = 1;
                return new J3D_Geometry(n3, n9, nArray2, dArray2);
            }
            if (dArray[2] == dArray[5] && dArray[0] != dArray[3] && dArray[1] != dArray[4]) {
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                dArray2[2] = dArray[2];
                dArray2[3] = dArray[3];
                dArray2[4] = dArray[1];
                dArray2[5] = dArray[2];
                dArray2[6] = dArray[3];
                dArray2[7] = dArray[4];
                dArray2[8] = dArray[2];
                dArray2[9] = dArray[0];
                dArray2[10] = dArray[4];
                dArray2[11] = dArray[2];
                dArray2[12] = dArray[0];
                dArray2[13] = dArray[1];
                dArray2[14] = dArray[2];
                nArray2[2] = 1;
                return new J3D_Geometry(n3, n9, nArray2, dArray2);
            }
            J3D_Geometry j3D_Geometry = new J3D_Geometry(n3, n9, nArray2, dArray);
            throw new Exception("54535");
        }
        if (dArray[0] >= dArray[3] && dArray[1] >= dArray[4] && dArray[2] >= dArray[5]) {
            if (dArray[0] == dArray[3] && dArray[1] != dArray[4] && dArray[2] != dArray[5]) {
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                dArray2[2] = dArray[2];
                dArray2[3] = dArray[0];
                dArray2[4] = dArray[1];
                dArray2[5] = dArray[5];
                dArray2[6] = dArray[0];
                dArray2[7] = dArray[4];
                dArray2[8] = dArray[5];
                dArray2[9] = dArray[0];
                dArray2[10] = dArray[4];
                dArray2[11] = dArray[2];
                dArray2[12] = dArray[0];
                dArray2[13] = dArray[1];
                dArray2[14] = dArray[2];
                nArray2[2] = 1;
                return new J3D_Geometry(n3, n9, nArray2, dArray2);
            }
            if (dArray[1] == dArray[4] && dArray[0] != dArray[3] && dArray[2] != dArray[5]) {
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                dArray2[2] = dArray[2];
                dArray2[3] = dArray[3];
                dArray2[4] = dArray[1];
                dArray2[5] = dArray[2];
                dArray2[6] = dArray[3];
                dArray2[7] = dArray[1];
                dArray2[8] = dArray[5];
                dArray2[9] = dArray[0];
                dArray2[10] = dArray[1];
                dArray2[11] = dArray[5];
                dArray2[12] = dArray[0];
                dArray2[13] = dArray[1];
                dArray2[14] = dArray[2];
                nArray2[2] = 1;
                return new J3D_Geometry(n3, n9, nArray2, dArray2);
            }
            if (dArray[2] == dArray[5] && dArray[0] != dArray[3] && dArray[1] != dArray[4]) {
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                dArray2[2] = dArray[2];
                dArray2[3] = dArray[0];
                dArray2[4] = dArray[4];
                dArray2[5] = dArray[2];
                dArray2[6] = dArray[3];
                dArray2[7] = dArray[4];
                dArray2[8] = dArray[2];
                dArray2[9] = dArray[3];
                dArray2[10] = dArray[1];
                dArray2[11] = dArray[2];
                dArray2[12] = dArray[0];
                dArray2[13] = dArray[1];
                dArray2[14] = dArray[2];
                nArray2[2] = 1;
                return new J3D_Geometry(n3, n9, nArray2, dArray2);
            }
            J3D_Geometry j3D_Geometry = new J3D_Geometry(n3, n9, nArray2, dArray);
            throw new Exception("54535");
        }
        J3D_Geometry j3D_Geometry = new J3D_Geometry(n3, n9, nArray2, dArray);
        throw new Exception("54537");
    }

    public J3D_Geometry nextElement(int[] nArray) throws Exception {
        int n = this.curoffset;
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n2 = this.curGeom.getElemInfo().length;
        if (this.invalidIterator) {
            return null;
        }
        if (this.curoffset + 1 >= n2) {
            return null;
        }
        if (this.extract_type == 0 && this.curGeom.getType() == 5) {
            int[] nArray4 = new int[]{1, 1, 1};
            nArray3[0] = this.ordoffset - 1;
            nArray3[0] = nArray3[0] + 3;
            double[] dArray = new double[3];
            int n3 = 0;
            if (nArray3[0] <= this.curGeom.getOrdinatesArray().length) {
                for (int i = this.ordoffset; i <= nArray3[0]; ++i) {
                    dArray[n3] = this.curGeom.getOrdinatesArray()[i - 1];
                    ++n3;
                }
                J3D_Geometry j3D_Geometry = new J3D_Geometry(1, 0, nArray4, dArray);
                this.ordoffset += 3;
                return j3D_Geometry;
            }
            return null;
        }
        if (this.extract_type == 0 && this.curGeom.getType() == 2 || this.extract_type == 2 && this.curGeom.getType() == 3) {
            int[] nArray5 = new int[]{1, 2, 1};
            nArray3[0] = this.ordoffset - 1;
            nArray3[0] = nArray3[0] + 6;
            double[] dArray = new double[6];
            int n4 = 0;
            if (nArray3[0] <= this.curGeom.getOrdinatesArray().length) {
                for (int i = this.ordoffset; i <= nArray3[0]; ++i) {
                    dArray[n4] = this.curGeom.getOrdinatesArray()[i - 1];
                    ++n4;
                }
                J3D_Geometry j3D_Geometry = new J3D_Geometry(2, 0, nArray5, dArray);
                this.ordoffset += 3;
                return j3D_Geometry;
            }
            return null;
        }
        if (this.global_etype == 8 || this.global_etype == 6) {
            --this.comcnt;
        }
        if (!this.allow_comp_sub_elements) {
            if ((this.curGeom.getType() == 4 || this.curGeom.getType() == 7) && this.curGeom.getElemInfo()[this.curoffset + 1] % 1000 == 6) {
                this.curoffset += 3;
            }
            if ((this.curGeom.getType() == 4 || this.curGeom.getType() == 9) && this.curGeom.getElemInfo()[this.curoffset + 1] % 1000 == 8) {
                this.curoffset += 3;
            }
        }
        this.getElementEnd(this.curoffset, nArray2, nArray3, nArray);
        this.curoffset = nArray3[0] + 1;
        return this.getElement(nArray2[0], nArray3[0], nArray);
    }

    private void copyElemInfo(int[] nArray, int n, int n2) throws Exception {
        int n3 = 0;
        if (n2 > this.curGeom.getElemInfo().length) {
            throw new Exception("13033");
        }
        for (int i = n; i <= n2; ++i) {
            nArray[n3] = this.curGeom.getElemInfo()[i];
            ++n3;
        }
    }

    private void copyOrds(double[] dArray, int n, int n2) throws Exception {
        int n3 = 0;
        if (n2 > this.curGeom.getOrdinatesArray().length) {
            throw new Exception("13033");
        }
        for (int i = n; i <= n2; ++i) {
            dArray[n3] = this.curGeom.getOrdinatesArray()[i];
            ++n3;
        }
    }
}

