/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import oracle.spatial.util.DBFieldDesc;
import oracle.spatial.util.DBFileHdr;

public class DBFReaderJGeom {
    private static final byte TERMINATOR = 13;
    private static final byte DELETED = 42;
    private static final int MAX_CHRS = 1024;
    RandomAccessFile mainFIS;
    DBFieldDesc[] fields;
    DBFileHdr file_hdr;
    int n_fields;
    int n_records;
    int record_sz;
    boolean big_endian;
    byte[] buffer;
    String namePrefix;
    String codePage;

    void init() {
        this.record_sz = 0;
        this.n_records = 0;
        this.n_fields = 0;
        this.fields = null;
        this.buffer = new byte[1024];
        this.file_hdr = new DBFileHdr();
        this.big_endian = true;
        this.codePage = null;
    }

    public DBFReaderJGeom() {
        this.init();
    }

    public DBFReaderJGeom(String string) throws IOException {
        this.init();
        this.readCodePage(string);
        this.openDBF(string);
    }

    public void readCodePage(String string) throws IOException {
        String string2 = string;
        int n = string.lastIndexOf(".dbf");
        string2 = n < 0 ? string + ".cpg" : string.substring(0, n) + ".cpg";
        try {
            FileReader fileReader = new FileReader(string2);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            this.codePage = bufferedReader.readLine();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.codePage = null;
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException.getMessage());
            this.codePage = null;
        }
    }

    public void openDBF(String string) throws IOException {
        String string2;
        this.namePrefix = new String(string);
        if (string.lastIndexOf(".dbf") < 0) {
            string2 = new String(string + ".dbf");
            this.namePrefix = new String(string);
        } else {
            string2 = new String(string);
            this.namePrefix = new String(string.substring(0, string.lastIndexOf(".dbf")));
        }
        this.mainFIS = new RandomAccessFile(string2, "r");
        this.mainFIS.read(this.buffer, 0, 32);
        this.file_hdr.fromBuffer(this.buffer);
        this.n_records = this.file_hdr.n_records;
        this.record_sz = this.file_hdr.record_sz;
        this.n_fields = (this.file_hdr.header_sz - 1 - 32) / 32;
        if (this.record_sz > 1024) {
            this.buffer = new byte[this.record_sz];
        }
        this.fields = new DBFieldDesc[this.n_fields];
        for (int i = 0; i < this.n_fields; ++i) {
            this.fields[i] = new DBFieldDesc();
        }
        byte[] byArray = new byte[this.n_fields * 32];
        this.mainFIS.read(byArray, 0, this.n_fields * 32);
        for (int i = 0; i < this.n_fields; ++i) {
            this.fields[i].fromBuffer(byArray);
            System.arraycopy(byArray, 32, byArray, 0, (this.n_fields - i - 1) * 32);
        }
    }

    public void closeDBF() throws IOException {
        if (this.mainFIS != null) {
            this.mainFIS.close();
        }
    }

    public int numRecords() {
        return this.n_records;
    }

    public int numFields() {
        return this.n_fields;
    }

    public int recordSize() {
        return this.record_sz;
    }

    public byte[] getRecord(int n) {
        int n2 = 32 + this.n_fields * 32 + 1 + n * this.record_sz;
        try {
            this.mainFIS.seek(n2);
            this.mainFIS.read(this.buffer, 0, this.record_sz);
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException);
            return null;
        }
        if (this.buffer[0] == 42) {
            System.err.println("Record " + n + " has been deleted.");
            return null;
        }
        return this.buffer;
    }

    public String getFieldData(int n, byte[] byArray) {
        if (n < 0 || n >= this.n_fields) {
            System.err.println("invalid field index !");
            return null;
        }
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 += this.fields[i].field_len;
        }
        if (this.codePage == null) {
            return new String(byArray, n2, (int)this.fields[n].field_len).trim();
        }
        try {
            return new String(byArray, n2, (int)this.fields[n].field_len, this.codePage).trim();
        }
        catch (Exception exception) {
            return new String(byArray, n2, (int)this.fields[n].field_len).trim();
        }
    }

    DBFieldDesc getFieldDesc(int n) {
        if (n < 0 || n >= this.n_fields) {
            return null;
        }
        return this.fields[n];
    }

    public int getFieldLength(int n) {
        if (n < 0 || n >= this.n_fields) {
            return -1;
        }
        return this.fields[n].field_len;
    }

    public String getFieldName(int n) {
        if (n < 0 || n >= this.n_fields) {
            System.err.println("invalid field index !");
            return null;
        }
        String string = new String(this.fields[n].name);
        int n2 = string.indexOf(0);
        return string.substring(0, n2);
    }

    public byte getFieldType(int n) {
        if (n < 0 || n >= this.n_fields) {
            System.err.println("invalid field index !");
            return 0;
        }
        int n2 = this.fields[n].field_type;
        if (n2 == 78 && this.fields[n].decimal_cnt == 0) {
            n2 = 73;
        }
        return (byte)n2;
    }

    public void print() {
        System.out.println("\nDBF attributes: ");
        int n = 0;
        int n2 = 0;
        while (n < this.n_fields) {
            System.out.print(new String(this.fields[n].name) + " [" + (char)this.fields[n].field_type + "," + this.fields[n].field_len + "], ");
            if (n2 == 4) {
                n2 = 0;
                System.out.print("\n");
            }
            ++n;
            ++n2;
        }
        System.out.print("\n");
        System.out.println("record_sz=" + this.record_sz + ", #records=" + this.n_records + ", #fields=" + this.n_fields);
    }

    public static class LogicalColumn
    extends RecordColumn {
        public LogicalColumn(byte[] byArray) {
            super(byArray);
        }

        public byte getType() {
            return 76;
        }

        public int getLength() {
            return 1;
        }
    }

    public static class NumericColumn
    extends RecordColumn {
        protected int columnLength;
        protected int columnDecimalDigits;

        public NumericColumn(byte[] byArray, int n, int n2) {
            super(byArray);
            this.columnLength = n;
            this.columnDecimalDigits = n2;
        }

        public int getDecimalDigits() {
            return this.columnDecimalDigits;
        }

        public byte getType() {
            return 78;
        }

        public int getLength() {
            return this.columnLength;
        }
    }

    public static class DateColumn
    extends RecordColumn {
        public DateColumn(byte[] byArray) {
            super(byArray);
        }

        public byte getType() {
            return 68;
        }

        public int getLength() {
            return 8;
        }
    }

    public static class CharacterColumn
    extends RecordColumn {
        protected int columnLength;

        public CharacterColumn(byte[] byArray, int n) {
            super(byArray);
            this.columnLength = n;
        }

        public byte getType() {
            return 67;
        }

        public int getLength() {
            return this.columnLength;
        }
    }

    public static abstract class RecordColumn {
        protected byte[] columnName;
        protected Vector values;

        public RecordColumn(byte[] byArray) {
            if (byArray.length == 11) {
                this.columnName = byArray;
            } else {
                int n;
                byte[] byArray2 = new byte[11];
                for (n = 0; n < byArray.length && n < 10; ++n) {
                    byArray2[n] = byArray[n];
                }
                while (n < 11) {
                    byArray2[n] = 0;
                    ++n;
                }
                this.columnName = byArray2;
            }
            this.values = new Vector();
        }

        public void addValue(byte[] byArray) {
            if (byArray.length == this.getLength()) {
                this.values.addElement(byArray);
            } else {
                int n;
                byte[] byArray2 = new byte[this.getLength()];
                for (n = 0; n < byArray.length; ++n) {
                    byArray2[n] = byArray[n];
                }
                while (n < this.getLength()) {
                    byArray2[n] = 32;
                    ++n;
                }
                this.values.addElement(byArray2);
            }
        }

        public byte[] getValue(int n) {
            return (byte[])this.values.elementAt(n);
        }

        public byte[] getName() {
            return this.columnName;
        }

        public int getNumValues() {
            return this.values.size();
        }

        public byte getType() {
            return 32;
        }

        public int getLength() {
            return 0;
        }

        public int getDecimalDigits() {
            return 0;
        }
    }
}

