/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.jdbc.OracleConnection;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.ElementExtractor;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;

public class GML3 {
    protected static Connection _conn;
    protected static String _srsNameSpace;
    protected static String _srsAlias;

    public static void setConnection(Connection connection) {
        _conn = connection;
    }

    public static void setsrsNameSpace(String string) {
        _srsNameSpace = string;
    }

    public static void setsrsAlias(String string) {
        _srsAlias = string;
    }

    protected void CCWOutputRectangle(int n, double[] dArray, int n2, StringBuffer stringBuffer) throws Exception, IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n == 2) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d2 = dArray[n2 + 2];
            d4 = dArray[n2 + 3];
            stringBuffer.append(d + " " + d3 + " " + d2 + " " + d3 + " " + d2 + " " + d4 + " " + d + " " + d4 + " " + d + " " + d3 + " ");
        } else if (n == 3) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d5 = dArray[n2 + 2];
            d2 = dArray[n2 + 3];
            d4 = dArray[n2 + 4];
            d6 = dArray[n2 + 5];
            J3D_Geometry j3D_Geometry = new J3D_Geometry(3003, 0, new int[]{1, 1003, 3}, new double[]{d, d3, d5, d2, d4, d6});
            ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 1, 3, false);
            int[] nArray = new int[]{0};
            j3D_Geometry = elementExtractor.nextElement(nArray);
            for (int i = 0; i < j3D_Geometry.getOrdinatesArray().length / 3; ++i) {
                stringBuffer.append(j3D_Geometry.getOrdinatesArray()[3 * i] + " " + j3D_Geometry.getOrdinatesArray()[3 * i + 1] + " " + j3D_Geometry.getOrdinatesArray()[3 * i + 2] + " ");
            }
        }
    }

    protected void CWOutputRectangle(int n, double[] dArray, int n2, StringBuffer stringBuffer) throws Exception, IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n == 2) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d2 = dArray[n2 + 2];
            d4 = dArray[n2 + 3];
            stringBuffer.append(d + " " + d3 + " " + d + " " + d4 + " " + d2 + " " + d4 + " " + d2 + " " + d3 + " " + d + " " + d3 + " ");
        } else if (n == 3) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d5 = dArray[n2 + 2];
            d2 = dArray[n2 + 3];
            d4 = dArray[n2 + 4];
            d6 = dArray[n2 + 5];
            J3D_Geometry j3D_Geometry = new J3D_Geometry(3003, 0, new int[]{1, 1003, 3}, new double[]{d, d3, d5, d2, d4, d6});
            ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 1, 3, false);
            int[] nArray = new int[]{0};
            j3D_Geometry = elementExtractor.nextElement(nArray);
            for (int i = 0; i < j3D_Geometry.getOrdinatesArray().length / 3; ++i) {
                stringBuffer.append(j3D_Geometry.getOrdinatesArray()[3 * i] + " " + j3D_Geometry.getOrdinatesArray()[3 * i + 1] + " " + j3D_Geometry.getOrdinatesArray()[3 * i + 2] + " ");
            }
        }
    }

    protected void outputCoordinates(int n, int n2, double[] dArray, int n3, StringBuffer stringBuffer) throws IOException {
        for (int i = 1; i <= n2; ++i) {
            stringBuffer.append(dArray[n3 + (i - 1) * n] + " " + dArray[n3 + (i - 1) * n + 1]);
            if (n == 3) {
                stringBuffer.append(" " + dArray[n3 + (i - 1) * n + 2]);
            }
            stringBuffer.append(" ");
        }
    }

    protected boolean geometryHasArcs(JGeometry jGeometry, int n) {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (n != 3) {
            if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
                bl = false;
                return bl;
            }
            int n2 = jGeometry.getElemInfo().length / 3;
            for (int i = 0; i < n2 && !bl; ++i) {
                if (nArray[3 * i + 2] == 2 && nArray[3 * i + 1] % 10 > 1) {
                    bl = true;
                    continue;
                }
                if (nArray[3 * i + 1] % 10 == 3 && nArray[3 * i + 2] == 4) {
                    bl = true;
                    continue;
                }
                if (nArray[3 * i + 1] % 10 <= 3) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected boolean geometryHasEtypeZero(JGeometry jGeometry) {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
            bl = false;
            return bl;
        }
        int n = jGeometry.getElemInfo().length / 3;
        for (int i = 0; i < n && !bl; ++i) {
            if (nArray[3 * i + 1] % 10 != 0) continue;
            bl = true;
        }
        return bl;
    }

    protected void toGML(int n, JGeometry jGeometry, StringBuffer stringBuffer) throws SQLException, IOException, DataException, Exception {
        Object object;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ElementExtractor elementExtractor;
        double[] dArray;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        String string = "Unknown";
        int n4 = 0;
        int n5 = 0;
        String string2 = "<gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">";
        String string3 = "</gml:posList>";
        String string4 = "<gml:pos srsDimension=\"" + jGeometry.getDimensions() + "\">";
        String string5 = "</gml:pos>";
        String string6 = "<gml:geometryMember>";
        String string7 = "</gml:geometryMember>";
        String string8 = "<gml:pointMember>";
        String string9 = "</gml:pointMember>";
        String string10 = "<gml:curveMember>";
        String string11 = "</gml:curveMember>";
        String string12 = "<gml:surfaceMember>";
        String string13 = "</gml:surfaceMember>";
        String string14 = "<gml:exterior>";
        String string15 = "</gml:exterior>";
        String string16 = "<gml:interior>";
        String string17 = "</gml:interior>";
        String string18 = "<gml:LinearRing>";
        String string19 = "</gml:LinearRing>";
        int n6 = jGeometry.getType();
        int n7 = jGeometry.getSRID();
        n3 = jGeometry.getDimensions();
        int[] nArray = jGeometry.getElemInfo();
        if (nArray != null) {
            n2 = nArray.length / 3;
        }
        if ((dArray = jGeometry.getOrdinatesArray()) != null) {
            n5 = dArray.length / n3;
        }
        if (n3 == 0) {
            n3 = dArray.length % 2 == 0 ? 2 : 3;
        }
        if (jGeometry == null) {
            throw new DataException("NULL Geometry");
        }
        if (!(!this.geometryHasArcs(jGeometry, n3) || n6 == 4 && n3 == 2 || n6 == 7 && n3 == 2 || n6 == 6 && n3 == 2 || n6 == 3 && jGeometry.getElemInfo()[1] % 1000 == 3 && n3 == 2 || n6 == 3 && jGeometry.getElemInfo()[1] % 1000 == 5 && n3 == 2 || n6 == 2 && jGeometry.getElemInfo()[1] % 1000 == 2 && n3 == 2 || n6 == 2 && jGeometry.getElemInfo()[1] % 1000 == 4 && n3 == 2)) {
            throw new DataException("54554");
        }
        if (this.geometryHasEtypeZero(jGeometry)) {
            throw new DataException("Etype zero not supported in GML3.1.1");
        }
        if (jGeometry.isLRSGeometry()) {
            throw new DataException("LRS not supported in GML3.1.1");
        }
        if (n6 == 1) {
            string = "Point";
            if (nArray != null && nArray[2] > 1) {
                string = "MultiPoint";
                n6 = 5;
            }
        } else if (n6 == 2) {
            string = nArray[1] % 1000 == 4 ? "CompositeCurve" : "Curve";
        } else if (n6 == 3) {
            string = "Polygon";
            if (nArray[1] % 1000 == 6) {
                string = "CompositeSurface";
            }
        } else if (n6 == 4) {
            string = "MultiGeometry";
        } else if (n6 == 5) {
            string = "MultiPoint";
        } else if (n6 == 6) {
            string = "MultiCurve";
        } else if (n6 == 7) {
            string = "MultiSurface";
        } else if (n6 == 8) {
            string = "Solid";
            if (nArray[1] % 1000 == 8) {
                string = "CompositeSolid";
            }
        } else if (n6 == 9) {
            string = "MultiSolid";
        }
        if (n == 0) {
            if (n7 == 0) {
                stringBuffer.append("<gml:" + string + " srsName=\"SDO:\" xmlns:gml=\"http://www.opengis.net/gml\">");
            } else if (_srsNameSpace == null) {
                stringBuffer.append("<gml:" + string + " srsName=\"SDO:" + n7 + "\" xmlns:gml=\"http://www.opengis.net/gml\">");
            } else {
                if (_conn == null) {
                    throw new DataException("GML Converter needs a valid connection and SrsNameSpace");
                }
                elementExtractor = " select srsname   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and sdo_srid = ? ";
                preparedStatement = _conn.prepareStatement((String)elementExtractor);
                preparedStatement.setString(1, _srsNameSpace);
                preparedStatement.setInt(2, n7);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw new DataException("GML has unregistered SrsNameSpace/SrsName");
                }
                object = resultSet.getString("srsname");
                stringBuffer.append("<gml:" + string + " srsName='" + _srsAlias + ":" + (String)object + "'" + " xmlns:gml=\"http://www.opengis.net/gml" + "\" xmlns:" + _srsAlias + "=\"" + _srsNameSpace + "\" >");
            }
        }
        if (n6 == 1 && dArray == null) {
            double[] dArray2;
            if (n != 0) {
                stringBuffer.append("<gml:Point>");
            }
            if ((dArray2 = jGeometry.getPoint()) != null) {
                n3 = dArray2.length;
                stringBuffer.append(string4);
                this.outputCoordinates(n3, 1, dArray2, 0, stringBuffer);
                stringBuffer.append(string5 + "</gml:" + string + ">");
            }
        }
        if (n6 == 1 && dArray != null) {
            if (n != 0) {
                stringBuffer.append("<gml:Point>");
            }
            stringBuffer.append(string4);
            this.outputCoordinates(n3, 1, dArray, 0, stringBuffer);
            stringBuffer.append(string5 + "</gml:" + string + ">");
        } else if (n6 == 2 && nArray[1] % 1000 == 2 && n2 == 1 && dArray != null) {
            if (n != 0) {
                stringBuffer.append("<gml:Curve>");
            }
            stringBuffer.append("<gml:segments>");
            if (nArray[2] == 1) {
                stringBuffer.append("<gml:LineStringSegment>");
            } else {
                stringBuffer.append("<gml:Arc>");
            }
            stringBuffer.append(string2);
            this.outputCoordinates(n3, n5, dArray, 0, stringBuffer);
            stringBuffer.append(string3);
            if (nArray[2] == 1) {
                stringBuffer.append("</gml:LineStringSegment>");
            } else {
                stringBuffer.append("</gml:Arc>");
            }
            stringBuffer.append("</gml:segments>");
            stringBuffer.append("</gml:" + string + ">");
        } else if (n6 == 2 && nArray[1] % 1000 == 4 && n2 > 1) {
            int n8 = 0;
            int n9 = 1;
            int n10 = nArray[2];
            if (n != 0) {
                stringBuffer.append("<gml:CompositeCurve>");
            }
            ++n8;
            while (n9 <= n10) {
                stringBuffer.append("<gml:curveMember><gml:Curve><gml:segments>");
                n5 = n9 == n10 ? (dArray.length - nArray[3 * n8] + 1) / n3 : 1 + (nArray[3 * n8 + 3] - nArray[3 * n8]) / n3;
                if (nArray[3 * n8 + 2] == 1) {
                    stringBuffer.append("<gml:LineStringSegment><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(n3, n5, dArray, nArray[3 * n8] - 1, stringBuffer);
                    stringBuffer.append("</gml:posList></gml:LineStringSegment>");
                } else if (nArray[3 * n8 + 2] == 2) {
                    stringBuffer.append("<gml:Arc><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(n3, n5, dArray, nArray[3 * n8] - 1, stringBuffer);
                    stringBuffer.append("</gml:posList></gml:Arc>");
                }
                stringBuffer.append("</gml:segments></gml:Curve></gml:curveMember>");
                ++n9;
                ++n8;
            }
            stringBuffer.append("</gml:CompositeCurve>");
        } else if (n6 == 3 && nArray[1] % 1000 == 3) {
            if (n != 0) {
                stringBuffer.append("<gml:Polygon>");
            }
            stringBuffer.append(string14);
            n5 = 3 >= nArray.length ? (dArray.length - nArray[0] + 1) / n3 : (nArray[3] - nArray[0]) / n3;
            n4 = 0;
            if (nArray[2] == 1 || nArray[2] == 3) {
                stringBuffer.append(string18 + string2);
                if (nArray[2] == 3) {
                    this.CCWOutputRectangle(n3, dArray, n4, stringBuffer);
                } else {
                    this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                }
                stringBuffer.append(string3 + string19);
            } else if (nArray[2] == 4) {
                stringBuffer.append("<gml:Circle><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                stringBuffer.append("</gml:posList></gml:Circle>");
            } else {
                throw new DataException("54539");
            }
            stringBuffer.append(string15);
            for (int i = 2; i <= n2; ++i) {
                stringBuffer.append(string16);
                n5 = i == n2 ? (dArray.length - nArray[3 * (i - 1)] + 1) / n3 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n3;
                n4 = nArray[3 * (i - 1)] - 1;
                if (nArray[3 * (i - 1) + 1] == 2003 && (nArray[3 * (i - 1) + 2] == 1 || nArray[3 * (i - 1) + 2] == 3)) {
                    stringBuffer.append(string18 + string2);
                    if (nArray[3 * (i - 1) + 2] == 3) {
                        this.CWOutputRectangle(n3, dArray, n4, stringBuffer);
                    } else {
                        this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                    }
                    stringBuffer.append(string3 + string19);
                } else if (nArray[3 * (i - 1) + 1] == 2003 && nArray[3 * (i - 1) + 2] == 4) {
                    stringBuffer.append("<gml:Circle><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                    stringBuffer.append("</gml:posList></gml:Circle>");
                } else if (nArray[3 * (i - 1) + 1] == 2005) {
                    stringBuffer.append("<gml:Ring>");
                    int n11 = 1;
                    int n12 = nArray[3 * (i - 1) + 2];
                    ++i;
                    while (n11 <= n12) {
                        stringBuffer.append("<gml:curveMember><gml:Curve><gml:segments>");
                        n5 = 3 * (i - 1) + 3 >= nArray.length ? (dArray.length - nArray[3 * (i - 1)] + 1) / n3 : (nArray[3 * (i - 1) + 4] == 2003 || nArray[3 * (i - 1) + 4] == 2005 ? (nArray[3 * (i - 1) + 3] - nArray[3 * (i - 1)]) / n3 : 1 + (nArray[3 * (i - 1) + 3] - nArray[3 * (i - 1)]) / n3);
                        if (nArray[3 * (i - 1) + 2] == 1) {
                            stringBuffer.append("<gml:LineStringSegment><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                            this.outputCoordinates(n3, n5, dArray, nArray[3 * (i - 1)] - 1, stringBuffer);
                            stringBuffer.append("</gml:posList></gml:LineStringSegment>");
                        } else if (nArray[3 * (i - 1) + 2] == 2) {
                            stringBuffer.append("<gml:Arc><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                            this.outputCoordinates(n3, n5, dArray, nArray[3 * (i - 1)] - 1, stringBuffer);
                            stringBuffer.append("</gml:posList></gml:Arc>");
                        }
                        stringBuffer.append("</gml:segments></gml:Curve></gml:curveMember>");
                        ++n11;
                        ++i;
                    }
                    stringBuffer.append("</gml:Ring>");
                } else {
                    throw new DataException("54539");
                }
                stringBuffer.append(string17);
            }
            stringBuffer.append("</gml:" + string + ">");
        } else if (n6 == 3 && nArray[1] % 1000 == 5) {
            if (n != 0) {
                stringBuffer.append("<gml:Polygon>");
            }
            int n13 = 0;
            int n14 = 1;
            int n15 = nArray[2];
            stringBuffer.append("<gml:exterior><gml:Ring>");
            ++n13;
            while (n14 <= n15) {
                stringBuffer.append("<gml:curveMember><gml:Curve><gml:segments>");
                n5 = 3 * n13 + 3 >= nArray.length ? (dArray.length - nArray[3 * n13] + 1) / n3 : (nArray[3 * n13 + 4] == 2003 || nArray[3 * n13 + 4] == 2005 ? (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3 : 1 + (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3);
                if (nArray[3 * n13 + 2] == 1) {
                    stringBuffer.append("<gml:LineStringSegment><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuffer);
                    stringBuffer.append("</gml:posList></gml:LineStringSegment>");
                } else if (nArray[3 * n13 + 2] == 2) {
                    stringBuffer.append("<gml:Arc><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuffer);
                    stringBuffer.append("</gml:posList></gml:Arc>");
                }
                stringBuffer.append("</gml:segments></gml:Curve></gml:curveMember>");
                ++n14;
                ++n13;
            }
            stringBuffer.append("</gml:Ring></gml:exterior>");
            while (3 * n13 < nArray.length) {
                stringBuffer.append("<gml:interior>");
                if (nArray[3 * n13 + 1] == 2005) {
                    stringBuffer.append("<gml:Ring>");
                    n14 = 1;
                    n15 = nArray[3 * n13 + 2];
                    ++n13;
                    while (n14 <= n15) {
                        stringBuffer.append("<gml:curveMember><gml:Curve><gml:segments>");
                        n5 = 3 * n13 + 3 >= nArray.length ? (dArray.length - nArray[3 * n13] + 1) / n3 : (nArray[3 * n13 + 4] == 2003 || nArray[3 * n13 + 4] == 2005 ? (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3 : 1 + (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3);
                        if (nArray[3 * n13 + 2] == 1) {
                            stringBuffer.append("<gml:LineStringSegment><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                            this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuffer);
                            stringBuffer.append("</gml:posList></gml:LineStringSegment>");
                        } else if (nArray[3 * n13 + 2] == 2) {
                            stringBuffer.append("<gml:Arc><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                            this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuffer);
                            stringBuffer.append("</gml:posList></gml:Arc>");
                        }
                        stringBuffer.append("</gml:segments></gml:Curve></gml:curveMember>");
                        ++n14;
                        ++n13;
                    }
                    stringBuffer.append("</gml:Ring>");
                } else if (nArray[3 * n13 + 1] == 2003) {
                    if (nArray[3 * n13 + 2] == 1) {
                        stringBuffer.append("<gml:LinearRing><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                        n5 = 3 * n13 + 3 >= nArray.length ? (dArray.length - nArray[3 * n13] + 1) / n3 : (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3;
                        this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuffer);
                        stringBuffer.append("</gml:posList></gml:LinearRing>");
                    } else if (nArray[3 * n13 + 2] == 3) {
                        stringBuffer.append("<gml:LinearRing><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                        n4 = nArray[3 * n13] - 1;
                        this.CWOutputRectangle(n3, dArray, n4, stringBuffer);
                        stringBuffer.append("</gml:posList></gml:LinearRing>");
                    } else if (nArray[3 * n13 + 2] == 4) {
                        stringBuffer.append("<gml:Circle><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                        n5 = 3 * n13 + 3 >= nArray.length ? (dArray.length - nArray[3 * n13] + 1) / n3 : (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3;
                        this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuffer);
                        stringBuffer.append("</gml:posList></gml:Circle>");
                    } else {
                        throw new DataException("54539");
                    }
                    ++n13;
                } else {
                    throw new DataException("54539");
                }
                stringBuffer.append("</gml:interior>");
            }
            stringBuffer.append("</gml:Polygon>");
        } else if (n6 == 3 && nArray[1] % 1000 == 6) {
            int n16;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[jGeometry.getElemInfo().length];
            double[] dArray3 = new double[jGeometry.getOrdinatesArray().length];
            for (n16 = 0; n16 < jGeometry.getOrdinatesArray().length; ++n16) {
                dArray3[n16] = jGeometry.getOrdinatesArray()[n16];
            }
            for (n16 = 0; n16 < jGeometry.getElemInfo().length; ++n16) {
                nArray3[n16] = jGeometry.getElemInfo()[n16];
            }
            resultSet = new J3D_Geometry(3, 0, nArray3, dArray3);
            if (n != 0) {
                stringBuffer.append("<gml:CompositeSurface>");
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            elementExtractor = new ElementExtractor((J3D_Geometry)resultSet);
            nArray2[0] = 0;
            while ((object = elementExtractor.nextElement(nArray2)) != null) {
                arrayList.add(object);
            }
            for (n16 = 0; n16 < arrayList.size(); ++n16) {
                int n17;
                stringBuffer.append("<gml:surfaceMember>");
                object = (J3D_Geometry)arrayList.get(n16);
                int[] nArray4 = new int[object.getElemInfo().length];
                double[] dArray4 = new double[object.getOrdinatesArray().length];
                for (n17 = 0; n17 < object.getOrdinatesArray().length; ++n17) {
                    dArray4[n17] = object.getOrdinatesArray()[n17];
                }
                for (n17 = 0; n17 < object.getElemInfo().length; ++n17) {
                    nArray4[n17] = object.getElemInfo()[n17];
                }
                preparedStatement = new JGeometry(3003, 0, nArray4, dArray4);
                this.toGML(++n, (JGeometry)preparedStatement, stringBuffer);
                stringBuffer.append("</gml:surfaceMember>");
            }
            stringBuffer.append("</gml:CompositeSurface>");
        } else if (n6 == 4) {
            if (n3 == 2) {
                int n18;
                int n19 = 0;
                object = _conn.prepareCall("{ ? = call mdsys.sdo_util.getnumelem(?)}");
                object.registerOutParameter(1, 4);
                object.setObject(2, JGeometry.store((JGeometry)jGeometry, (Connection)_conn));
                object.execute();
                n19 = object.getInt(1);
                object.close();
                object = null;
                elementExtractor = new ArrayList();
                for (n18 = 1; n18 <= n19; ++n18) {
                    CallableStatement callableStatement = _conn.prepareCall("{ ? = call mdsys.sdo_util.extract(?,?)}");
                    callableStatement.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
                    callableStatement.setObject(2, (Object)JGeometry.store((JGeometry)jGeometry, (Connection)_conn));
                    callableStatement.setInt(3, n18);
                    callableStatement.execute();
                    STRUCT sTRUCT = (STRUCT)callableStatement.getObject(1);
                    object = JGeometry.load((STRUCT)sTRUCT);
                    elementExtractor.add(object);
                    callableStatement.close();
                    continue;
                }
                for (n18 = 0; n18 < elementExtractor.size(); ++n18) {
                    stringBuffer.append("<gml:geometryMember>");
                    preparedStatement = (JGeometry)elementExtractor.get(n18);
                    n = 0;
                    this.toGML(n, (JGeometry)preparedStatement, stringBuffer);
                    stringBuffer.append("</gml:geometryMember>");
                }
                stringBuffer.append("</gml:" + string + ">");
            } else {
                int n20;
                int[] nArray5 = new int[1];
                int[] nArray6 = new int[jGeometry.getElemInfo().length];
                double[] dArray5 = new double[jGeometry.getOrdinatesArray().length];
                for (n20 = 0; n20 < jGeometry.getOrdinatesArray().length; ++n20) {
                    dArray5[n20] = jGeometry.getOrdinatesArray()[n20];
                }
                for (n20 = 0; n20 < jGeometry.getElemInfo().length; ++n20) {
                    nArray6[n20] = jGeometry.getElemInfo()[n20];
                }
                resultSet = new J3D_Geometry(4, 0, nArray6, dArray5);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                elementExtractor = new ElementExtractor((J3D_Geometry)resultSet);
                nArray5[0] = 0;
                while ((object = elementExtractor.nextElement(nArray5)) != null) {
                    if (nArray5[0] == 2) continue;
                    arrayList.add(object);
                }
                for (n20 = 0; n20 < arrayList.size(); ++n20) {
                    int n21;
                    stringBuffer.append("<gml:geometryMember>");
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(n20);
                    int[] nArray7 = new int[j3D_Geometry.getElemInfo().length];
                    double[] dArray6 = new double[j3D_Geometry.getOrdinatesArray().length];
                    for (n21 = 0; n21 < j3D_Geometry.getOrdinatesArray().length; ++n21) {
                        dArray6[n21] = j3D_Geometry.getOrdinatesArray()[n21];
                    }
                    for (n21 = 0; n21 < j3D_Geometry.getElemInfo().length; ++n21) {
                        nArray7[n21] = j3D_Geometry.getElemInfo()[n21];
                    }
                    preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray7, dArray6);
                    n = 0;
                    this.toGML(n, (JGeometry)preparedStatement, stringBuffer);
                    stringBuffer.append("</gml:geometryMember>");
                }
                stringBuffer.append("</gml:MultiGeometry>");
            }
        } else if (n6 == 5) {
            if (n2 == 1 && nArray[2] > 1) {
                n5 = nArray[2];
            } else if (n2 > 1) {
                n5 = n2;
            }
            for (int i = 1; i <= n5; ++i) {
                n4 = n3 * (i - 1);
                if (nArray.length >= n4 + 2 && nArray[n4 + 2] == 0) continue;
                stringBuffer.append(string8 + "<gml:Point>" + string4);
                this.outputCoordinates(n3, 1, dArray, n4, stringBuffer);
                stringBuffer.append(string5 + "</gml:Point>" + string9);
            }
            stringBuffer.append("</gml:" + string + ">");
        } else if (n6 == 6) {
            if (n3 == 2) {
                int n22;
                int n23 = 0;
                object = _conn.prepareCall("{ ? = call mdsys.sdo_util.getnumelem(?)}");
                object.registerOutParameter(1, 4);
                object.setObject(2, JGeometry.store((JGeometry)jGeometry, (Connection)_conn));
                object.execute();
                n23 = object.getInt(1);
                object.close();
                object = null;
                elementExtractor = new ArrayList();
                for (n22 = 1; n22 <= n23; ++n22) {
                    CallableStatement callableStatement = _conn.prepareCall("{ ? = call mdsys.sdo_util.extract(?,?)}");
                    callableStatement.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
                    callableStatement.setObject(2, (Object)JGeometry.store((JGeometry)jGeometry, (Connection)_conn));
                    callableStatement.setInt(3, n22);
                    callableStatement.execute();
                    STRUCT sTRUCT = (STRUCT)callableStatement.getObject(1);
                    object = JGeometry.load((STRUCT)sTRUCT);
                    elementExtractor.add(object);
                    callableStatement.close();
                    continue;
                }
                for (n22 = 0; n22 < elementExtractor.size(); ++n22) {
                    stringBuffer.append("<gml:curveMember>");
                    preparedStatement = (JGeometry)elementExtractor.get(n22);
                    this.toGML(++n, (JGeometry)preparedStatement, stringBuffer);
                    stringBuffer.append("</gml:curveMember>");
                }
                stringBuffer.append("</gml:" + string + ">");
            } else {
                int n24;
                int[] nArray8 = new int[1];
                int[] nArray9 = new int[jGeometry.getElemInfo().length];
                double[] dArray7 = new double[jGeometry.getOrdinatesArray().length];
                for (n24 = 0; n24 < jGeometry.getOrdinatesArray().length; ++n24) {
                    dArray7[n24] = jGeometry.getOrdinatesArray()[n24];
                }
                for (n24 = 0; n24 < jGeometry.getElemInfo().length; ++n24) {
                    nArray9[n24] = jGeometry.getElemInfo()[n24];
                }
                resultSet = new J3D_Geometry(6, 0, nArray9, dArray7);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                elementExtractor = new ElementExtractor((J3D_Geometry)resultSet);
                nArray8[0] = 0;
                while ((object = elementExtractor.nextElement(nArray8)) != null) {
                    if (nArray8[0] == 2) continue;
                    arrayList.add(object);
                }
                for (n24 = 0; n24 < arrayList.size(); ++n24) {
                    int n25;
                    stringBuffer.append("<gml:curveMember>");
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(n24);
                    int[] nArray10 = new int[j3D_Geometry.getElemInfo().length];
                    double[] dArray8 = new double[j3D_Geometry.getOrdinatesArray().length];
                    for (n25 = 0; n25 < j3D_Geometry.getOrdinatesArray().length; ++n25) {
                        dArray8[n25] = j3D_Geometry.getOrdinatesArray()[n25];
                    }
                    for (n25 = 0; n25 < j3D_Geometry.getElemInfo().length; ++n25) {
                        nArray10[n25] = j3D_Geometry.getElemInfo()[n25];
                    }
                    preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray10, dArray8);
                    this.toGML(++n, (JGeometry)preparedStatement, stringBuffer);
                    stringBuffer.append("</gml:curveMember>");
                }
                stringBuffer.append("</gml:MultiCurve>");
            }
        } else if (n6 == 7) {
            if (n3 == 2) {
                int n26;
                int n27 = 0;
                object = _conn.prepareCall("{ ? = call mdsys.sdo_util.getnumelem(?)}");
                object.registerOutParameter(1, 4);
                object.setObject(2, JGeometry.store((JGeometry)jGeometry, (Connection)_conn));
                object.execute();
                n27 = object.getInt(1);
                object.close();
                object = null;
                elementExtractor = new ArrayList();
                for (n26 = 1; n26 <= n27; ++n26) {
                    CallableStatement callableStatement = _conn.prepareCall("{ ? = call mdsys.sdo_util.extract(?,?)}");
                    callableStatement.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
                    callableStatement.setObject(2, (Object)JGeometry.store((JGeometry)jGeometry, (Connection)_conn));
                    callableStatement.setInt(3, n26);
                    callableStatement.execute();
                    STRUCT sTRUCT = (STRUCT)callableStatement.getObject(1);
                    object = JGeometry.load((STRUCT)sTRUCT);
                    elementExtractor.add(object);
                    callableStatement.close();
                    continue;
                }
                for (n26 = 0; n26 < elementExtractor.size(); ++n26) {
                    stringBuffer.append("<gml:surfaceMember>");
                    preparedStatement = (JGeometry)elementExtractor.get(n26);
                    ++n;
                    for (int i = 1; i < preparedStatement.getElemInfo().length / 3; ++i) {
                        if (preparedStatement.getElemInfo()[3 * i + 1] != 1003) continue;
                        preparedStatement.getElemInfo()[3 * i + 1] = 2003;
                    }
                    this.toGML(n, (JGeometry)preparedStatement, stringBuffer);
                    stringBuffer.append("</gml:surfaceMember>");
                }
                stringBuffer.append("</gml:" + string + ">");
            } else {
                int n28;
                int[] nArray11 = new int[1];
                int[] nArray12 = new int[jGeometry.getElemInfo().length];
                double[] dArray9 = new double[jGeometry.getOrdinatesArray().length];
                for (n28 = 0; n28 < jGeometry.getOrdinatesArray().length; ++n28) {
                    dArray9[n28] = jGeometry.getOrdinatesArray()[n28];
                }
                for (n28 = 0; n28 < jGeometry.getElemInfo().length; ++n28) {
                    nArray12[n28] = jGeometry.getElemInfo()[n28];
                }
                resultSet = new J3D_Geometry(7, 0, nArray12, dArray9);
                if (n != 0) {
                    stringBuffer.append("<gml:MultiSurface>");
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                elementExtractor = new ElementExtractor((J3D_Geometry)resultSet);
                nArray11[0] = 0;
                while ((object = elementExtractor.nextElement(nArray11)) != null) {
                    if (nArray11[0] == 2) continue;
                    arrayList.add(object);
                }
                for (n28 = 0; n28 < arrayList.size(); ++n28) {
                    int n29;
                    stringBuffer.append("<gml:surfaceMember>");
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(n28);
                    int[] nArray13 = new int[j3D_Geometry.getElemInfo().length];
                    double[] dArray10 = new double[j3D_Geometry.getOrdinatesArray().length];
                    for (n29 = 0; n29 < j3D_Geometry.getOrdinatesArray().length; ++n29) {
                        dArray10[n29] = j3D_Geometry.getOrdinatesArray()[n29];
                    }
                    for (n29 = 0; n29 < j3D_Geometry.getElemInfo().length; ++n29) {
                        nArray13[n29] = j3D_Geometry.getElemInfo()[n29];
                    }
                    preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray13, dArray10);
                    this.toGML(++n, (JGeometry)preparedStatement, stringBuffer);
                    stringBuffer.append("</gml:surfaceMember>");
                }
                stringBuffer.append("</gml:MultiSurface>");
            }
        } else if (n6 == 8 && nArray[1] % 1000 == 7) {
            J3D_Geometry j3D_Geometry;
            J3D_Geometry j3D_Geometry2;
            J3D_Geometry j3D_Geometry3;
            int n30;
            int[] nArray14 = new int[1];
            ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
            int[] nArray15 = new int[jGeometry.getElemInfo().length];
            double[] dArray11 = new double[jGeometry.getOrdinatesArray().length];
            for (n30 = 0; n30 < jGeometry.getOrdinatesArray().length; ++n30) {
                dArray11[n30] = jGeometry.getOrdinatesArray()[n30];
            }
            for (n30 = 0; n30 < jGeometry.getElemInfo().length; ++n30) {
                nArray15[n30] = jGeometry.getElemInfo()[n30];
            }
            object = new J3D_Geometry(8, 0, nArray15, dArray11);
            if (n != 0) {
                stringBuffer.append("<gml:Solid>");
            }
            ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
            elementExtractor = new ElementExtractor((J3D_Geometry)object, 0, 2, 3);
            nArray14[0] = 0;
            while ((j3D_Geometry3 = elementExtractor.nextElement(nArray14)) != null) {
                if (nArray14[0] == 2) continue;
                arrayList.add(j3D_Geometry3);
            }
            j3D_Geometry3 = (J3D_Geometry)arrayList.get(0);
            preparedStatement = new ElementExtractor(j3D_Geometry3, 0, 1, 3);
            nArray14[0] = 0;
            while ((j3D_Geometry2 = preparedStatement.nextElement(nArray14)) != null) {
                if (nArray14[0] == 2) {
                    arrayList2.add(j3D_Geometry2);
                    continue;
                }
                arrayList3.add(j3D_Geometry2);
            }
            J3D_Geometry j3D_Geometry4 = (J3D_Geometry)arrayList3.get(0);
            resultSet = new ElementExtractor(j3D_Geometry4, 0, 0, 3);
            ArrayList<J3D_Geometry> arrayList4 = new ArrayList<J3D_Geometry>();
            nArray14[0] = 0;
            while ((j3D_Geometry = resultSet.nextElement(nArray14)) != null) {
                if (nArray14[0] == 2) continue;
                arrayList4.add(j3D_Geometry);
            }
            stringBuffer.append("<gml:exterior><gml:CompositeSurface>");
            for (n30 = 0; n30 < arrayList4.size(); ++n30) {
                j3D_Geometry = (J3D_Geometry)arrayList4.get(n30);
                stringBuffer.append("<gml:surfaceMember><gml:Polygon><gml:exterior><gml:LinearRing>");
                stringBuffer.append("<gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                this.outputCoordinates(3, j3D_Geometry.getOrdinatesArray().length / 3, j3D_Geometry.getOrdinatesArray(), 0, stringBuffer);
                stringBuffer.append("</gml:posList>");
                stringBuffer.append("</gml:LinearRing></gml:exterior></gml:Polygon></gml:surfaceMember>");
            }
            stringBuffer.append("</gml:CompositeSurface></gml:exterior>");
            for (n30 = 0; n30 < arrayList2.size(); ++n30) {
                J3D_Geometry j3D_Geometry5 = (J3D_Geometry)arrayList2.get(n30);
                stringBuffer.append("<gml:interior><gml:CompositeSurface>");
                resultSet = new ElementExtractor(j3D_Geometry5, 0, 0, 3);
                arrayList4 = new ArrayList();
                nArray14[0] = 0;
                while ((j3D_Geometry = resultSet.nextElement(nArray14)) != null) {
                    if (nArray14[0] != 2) continue;
                    arrayList4.add(j3D_Geometry);
                }
                for (int i = 0; i < arrayList4.size(); ++i) {
                    j3D_Geometry = (J3D_Geometry)arrayList4.get(i);
                    stringBuffer.append("<gml:surfaceMember><gml:Polygon><gml:exterior><gml:LinearRing>");
                    stringBuffer.append("<gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(3, j3D_Geometry.getOrdinatesArray().length / 3, j3D_Geometry.getOrdinatesArray(), 0, stringBuffer);
                    stringBuffer.append("</gml:posList>");
                    stringBuffer.append("</gml:LinearRing></gml:exterior></gml:Polygon></gml:surfaceMember>");
                }
                stringBuffer.append("</gml:CompositeSurface></gml:interior>");
            }
            stringBuffer.append("</gml:Solid>");
        } else if (n6 == 8 && nArray[1] % 1000 == 8) {
            int n31;
            int[] nArray16 = new int[1];
            int[] nArray17 = new int[jGeometry.getElemInfo().length];
            double[] dArray12 = new double[jGeometry.getOrdinatesArray().length];
            for (n31 = 0; n31 < jGeometry.getOrdinatesArray().length; ++n31) {
                dArray12[n31] = jGeometry.getOrdinatesArray()[n31];
            }
            for (n31 = 0; n31 < jGeometry.getElemInfo().length; ++n31) {
                nArray17[n31] = jGeometry.getElemInfo()[n31];
            }
            resultSet = new J3D_Geometry(8, 0, nArray17, dArray12);
            if (n != 0) {
                stringBuffer.append("<gml:CompositeSolid>");
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            elementExtractor = new ElementExtractor((J3D_Geometry)resultSet);
            nArray16[0] = 0;
            while ((object = elementExtractor.nextElement(nArray16)) != null) {
                if (nArray16[0] == 2) continue;
                arrayList.add(object);
            }
            for (n31 = 0; n31 < arrayList.size(); ++n31) {
                int n32;
                stringBuffer.append("<gml:solidMember>");
                object = (J3D_Geometry)arrayList.get(n31);
                int[] nArray18 = new int[object.getElemInfo().length];
                double[] dArray13 = new double[object.getOrdinatesArray().length];
                for (n32 = 0; n32 < object.getOrdinatesArray().length; ++n32) {
                    dArray13[n32] = object.getOrdinatesArray()[n32];
                }
                for (n32 = 0; n32 < object.getElemInfo().length; ++n32) {
                    nArray18[n32] = object.getElemInfo()[n32];
                }
                preparedStatement = new JGeometry(3008, 0, nArray18, dArray13);
                this.toGML(++n, (JGeometry)preparedStatement, stringBuffer);
                stringBuffer.append("</gml:solidMember>");
            }
            stringBuffer.append("</gml:CompositeSolid>");
        } else if (n6 == 9) {
            int n33;
            int[] nArray19 = new int[1];
            ArrayList arrayList = new ArrayList();
            int[] nArray20 = new int[jGeometry.getElemInfo().length];
            double[] dArray14 = new double[jGeometry.getOrdinatesArray().length];
            for (n33 = 0; n33 < jGeometry.getOrdinatesArray().length; ++n33) {
                dArray14[n33] = jGeometry.getOrdinatesArray()[n33];
            }
            for (n33 = 0; n33 < jGeometry.getElemInfo().length; ++n33) {
                nArray20[n33] = jGeometry.getElemInfo()[n33];
            }
            resultSet = new J3D_Geometry(9, 0, nArray20, dArray14);
            if (n != 0) {
                stringBuffer.append("<gml:MultiSolid>");
            }
            ArrayList<Object> arrayList5 = new ArrayList<Object>();
            elementExtractor = new ElementExtractor((J3D_Geometry)resultSet);
            nArray19[0] = 0;
            while ((object = elementExtractor.nextElement(nArray19)) != null) {
                if (nArray19[0] == 2) continue;
                arrayList5.add(object);
            }
            for (n33 = 0; n33 < arrayList5.size(); ++n33) {
                int n34;
                stringBuffer.append("<gml:solidMember>");
                J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList5.get(n33);
                int[] nArray21 = new int[j3D_Geometry.getElemInfo().length];
                double[] dArray15 = new double[j3D_Geometry.getOrdinatesArray().length];
                for (n34 = 0; n34 < j3D_Geometry.getOrdinatesArray().length; ++n34) {
                    dArray15[n34] = j3D_Geometry.getOrdinatesArray()[n34];
                }
                for (n34 = 0; n34 < j3D_Geometry.getElemInfo().length; ++n34) {
                    nArray21[n34] = j3D_Geometry.getElemInfo()[n34];
                }
                preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray21, dArray15);
                this.toGML(++n, (JGeometry)preparedStatement, stringBuffer);
                stringBuffer.append("</gml:solidMember>");
            }
            stringBuffer.append("</gml:MultiSolid>");
        }
    }

    public static CLOB to_GML3GeometryCLOB(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = GML3.to_GML3Geometry(sTRUCT);
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return cLOB;
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        String string3 = GML3.to_GML3Geometry(sTRUCT);
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return string3;
    }

    public static String to_GML3Geometry(STRUCT sTRUCT) throws SQLException, IOException {
        if (sTRUCT == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        return GML3.to_GML3Geometry(jGeometry);
    }

    public static CLOB to_GML3GeometryCLOB(STRUCT sTRUCT) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = GML3.to_GML3Geometry(sTRUCT);
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static String to_GML3Geometry(JGeometry jGeometry) throws SQLException, IOException {
        GML3 gML3 = new GML3();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            gML3.toGML(n, jGeometry, stringBuffer);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static {
        _srsAlias = "Non-SDO";
    }
}

