/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.JGeometry;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GML3g {
    protected static Connection _conn;
    protected static String _srsNameSpace;
    protected static final Locale ENGLISH;
    protected static final Set gmlTypes;

    public static void setConnection(Connection connection) {
        _conn = connection;
    }

    public static void setsrsNameSpace(String string) {
        _srsNameSpace = string;
    }

    public static String getNameSpace() {
        return _srsNameSpace;
    }

    private static final double[] getOrdinatesFromNode(Node node) {
        String string;
        Node node2 = GML3g.getFirst(node, new String[]{"posList"});
        if (node2 == null) {
            node2 = GML3g.getFirst(node, new String[]{"pos"});
        }
        if (node2 == null) {
            node2 = GML3g.getFirst(node, new String[]{"coordinates"});
        }
        if (node2 == null) {
            node2 = GML3g.getFirst(node, new String[]{"coord"});
        }
        if (GML3g.normalize(string = node2.getNodeName()).equalsIgnoreCase("posList") || GML3g.normalize(string).equalsIgnoreCase("coordinates")) {
            return GML3g.parseCoordinates(node2.getFirstChild().getNodeValue(), ", \n\t\r\f");
        }
        if (GML3g.normalize(string).equalsIgnoreCase("pos") || GML3g.normalize(string).equalsIgnoreCase("coord")) {
            return GML3g.parseCoordinates(node.getChildNodes());
        }
        return new double[0];
    }

    private static final double[] parseCoordinates(NodeList nodeList) {
        double[] dArray;
        int n = nodeList.getLength();
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        try {
            Node node;
            for (n2 = 0; n2 < n; ++n2) {
                node = nodeList.item(n2);
                if (node.getNodeName() == "#text") continue;
                ++n4;
                n3 = n2;
            }
            XMLElement xMLElement = (XMLElement)nodeList.item(n3);
            int n5 = GML3g.parseCoordinates(xMLElement.getFirstChild().getNodeValue(), ", \n\t\r\f").length;
            dArray = new double[n4 * n5];
            int n6 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                node = nodeList.item(n2);
                if (node.getNodeName() == "#text") continue;
                xMLElement = (XMLElement)nodeList.item(n2);
                double[] dArray2 = GML3g.parseCoordinates(xMLElement.getFirstChild().getNodeValue(), ", \n\t\r\f");
                for (n3 = 0; n3 < dArray2.length; ++n3) {
                    dArray[n6 * n5 + n3] = dArray2[n3];
                }
                ++n6;
            }
        }
        catch (Exception exception) {
            return new double[0];
        }
        return dArray;
    }

    private static final double[] parseCoordinates(String string, String string2) {
        Vector vector = new Vector();
        GML3g.addCoords(vector, string);
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector.get(i));
        }
        return dArray;
    }

    private static final int getSRIDFromNode(Node node) throws DataException, Exception {
        XMLElement xMLElement = (XMLElement)node;
        String string = xMLElement.getAttribute("srsName");
        int n = 0;
        String string2 = ((XMLElement)node).getAttribute("srsName");
        String string3 = GML3g.normalize(string2);
        String string4 = null;
        try {
            string4 = string2.substring(0, string2.indexOf(":"));
        }
        catch (Exception exception) {
            n = 0;
        }
        if (string4 == null) {
            return n;
        }
        if (string4.equalsIgnoreCase("SDO") || string4.equalsIgnoreCase("EPSG")) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                n = 0;
            }
        } else {
            if (_conn == null || _srsNameSpace == null) {
                throw new DataException("GML Converter needs a valid connection and SrsNameSpace" + _srsNameSpace);
            }
            String string5 = " select sdo_srid   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and SrsName = ? ";
            PreparedStatement preparedStatement = _conn.prepareStatement(string5);
            preparedStatement.setString(1, _srsNameSpace);
            preparedStatement.setString(2, string3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new DataException("GML has unregistered SrsNameSpace/SrsName");
            }
            n = resultSet.getInt("sdo_srid");
        }
        return n;
    }

    private static final int guessDimensionality(Node node) {
        String string;
        Node node2 = GML3g.getFirst(node, new String[]{"posList"});
        if (node2 == null) {
            node2 = GML3g.getFirst(node, new String[]{"pos"});
        }
        if (node2 == null) {
            node2 = GML3g.getFirst(node, new String[]{"coordinates"});
        }
        if (node2 == null) {
            node2 = GML3g.getFirst(node, new String[]{"coord"});
        }
        if (GML3g.normalize(string = GML3g.normalize(node2.getNodeName())).equalsIgnoreCase("posList") || GML3g.normalize(string).equalsIgnoreCase("coordinates")) {
            Object object;
            int n;
            Object object2;
            if (node2.hasAttributes()) {
                object2 = node2.getAttributes();
                for (n = 0; n < object2.getLength(); ++n) {
                    object = object2.item(n);
                    if (!object.getNodeName().equalsIgnoreCase("srsDimension")) continue;
                    return Integer.parseInt(object.getNodeValue());
                }
            }
            if ((n = ((String)(object2 = node2.getFirstChild().getNodeValue().trim())).indexOf(" ")) == -1) {
                n = ((String)object2).length();
            }
            object = ((String)object2).substring(0, n);
            int n2 = 0;
            for (int i = 0; i < ((String)object).length(); ++i) {
                if (((String)object).charAt(i) != ',') continue;
                ++n2;
            }
            return ++n2;
        }
        if (GML3g.normalize(string).equalsIgnoreCase("pos") || GML3g.normalize(string).equalsIgnoreCase("coord")) {
            return GML3g.parseCoordinates(node2.getFirstChild().getNodeValue(), ", \n\t\r\f").length;
        }
        return 0;
    }

    public static JGeometry fromNodeToPoint(Node node) throws DataException, Exception {
        int n = 0;
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        n = GML3g.getSRIDFromNode(node);
        double[] dArray = GML3g.getOrdinatesFromNode(node);
        if (dArray.length == 2) {
            return new JGeometry(dArray[0], dArray[1], n);
        }
        if (dArray.length == 3) {
            return new JGeometry(dArray[0], dArray[1], dArray[2], n);
        }
        return null;
    }

    public static final JGeometry fromNodeToEnvelope(Node node) throws DataException, Exception {
        int n = GML3g.getSRIDFromNode(node);
        double[] dArray = GML3g.getOrdinatesFromNode(node);
        if (dArray.length == 4) {
            return new JGeometry(Math.min(dArray[0], dArray[2]), Math.min(dArray[1], dArray[3]), Math.max(dArray[0], dArray[2]), Math.max(dArray[1], dArray[3]), n);
        }
        if (dArray.length == 6) {
            int[] nArray = new int[3];
            double[] dArray2 = new double[]{Math.min(dArray[0], dArray[3]), Math.min(dArray[1], dArray[4]), Math.min(dArray[2], dArray[5]), Math.max(dArray[0], dArray[3]), Math.max(dArray[1], dArray[4]), Math.max(dArray[2], dArray[5])};
            if (Math.abs(dArray[0] - dArray[3]) < 1.0E-16 || Math.abs(dArray[1] - dArray[4]) < 1.0E-16 || Math.abs(dArray[2] - dArray[5]) < 1.0E-16) {
                nArray[0] = 1;
                nArray[1] = 1003;
                nArray[2] = 3;
                return new JGeometry(3003, n, nArray, dArray2);
            }
            nArray[0] = 1;
            nArray[1] = 1007;
            nArray[2] = 3;
            return new JGeometry(3008, n, nArray, dArray2);
        }
        throw new DataException("13357");
    }

    public static JGeometry fromNodeToLineString(Node node) throws DataException, Exception {
        int n = GML3g.getSRIDFromNode(node);
        int n2 = GML3g.guessDimensionality(node);
        double[] dArray = GML3g.getOrdinatesFromNode(node);
        return JGeometry.createLinearLineString((double[])dArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToCurve(Node node) throws DataException, Exception {
        int n = GML3g.getSRIDFromNode(node);
        Node node2 = GML3g.getFirst(node, new String[]{"segments", "LineStringSegment"});
        if (node2 != null) {
            int n2 = GML3g.guessDimensionality(node2);
            double[] dArray = GML3g.getOrdinatesFromNode(node2);
            return JGeometry.createLinearLineString((double[])dArray, (int)n2, (int)n);
        }
        Node node3 = GML3g.getFirst(node, new String[]{"segments", "Arc"});
        int n3 = GML3g.guessDimensionality(node3);
        double[] dArray = GML3g.getOrdinatesFromNode(node3);
        return JGeometry.createArc2d((double[])dArray, (int)n3, (int)n);
    }

    public static JGeometry fromNodeToPolygon(Node node) throws DataException, Exception {
        int n;
        String string;
        Object object;
        Object object2;
        Node node2;
        Node node3;
        Node node4;
        Object object3;
        int n2;
        int n3 = 0;
        Vector vector = GML3g.getAll(node, new String[]{"exterior"});
        Vector vector2 = GML3g.getAll(node, new String[]{"interior"});
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Node node5 = GML3g.getFirst(node, new String[]{"exterior", "LinearRing"});
        Node node6 = GML3g.getFirst(node, new String[]{"exterior", "Circle"});
        Node node7 = GML3g.getFirst(node, new String[]{"exterior", "Ring", "curveMember", "Curve", "segments", "LineStringSegment"});
        Node node8 = GML3g.getFirst(node, new String[]{"exterior", "Ring", "curveMember", "Curve", "segments", "Arc"});
        if (node5 != null) {
            n3 = GML3g.guessDimensionality(node5);
        } else if (node6 != null) {
            n3 = GML3g.guessDimensionality(node6);
        } else if (node7 != null) {
            n3 = GML3g.guessDimensionality(node7);
        } else if (node8 != null) {
            n3 = GML3g.guessDimensionality(node8);
        } else {
            throw new DataException("Invalid Polygon");
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object3 = (Node)vector.get(n2);
            node4 = GML3g.getFirst((Node)object3, new String[]{"LinearRing"});
            node3 = GML3g.getFirst((Node)object3, new String[]{"Circle"});
            node2 = GML3g.getFirst((Node)object3, new String[]{"Ring"});
            if (node4 != null) {
                object2 = GML3g.getOrdinatesFromNode(node4);
                object = new int[3];
                object = ((double[])object2).length > n3 * 2 ? new int[]{1, 1003, 1} : new int[]{1, 1003, 3};
                string = "";
                for (int i = 0; i < ((int[])object).length; ++i) {
                    string = i % 3 == 0 ? string.concat(String.valueOf((int)(object[i] + vector4.size()))).concat(" ") : string.concat(String.valueOf((int)object[i])).concat(" ");
                }
                GML3g.addCoords(vector3, string);
                String string2 = "";
                for (n = 0; n < ((double[])object2).length; ++n) {
                    string2 = string2.concat(String.valueOf(object2[n])).concat(" ");
                }
                GML3g.addCoords(vector4, string2);
                continue;
            }
            if (node3 != null) {
                object2 = GML3g.getOrdinatesFromNode(node3);
                object = new int[3];
                object = new int[]{1, 1003, 4};
                string = "";
                for (int i = 0; i < ((int[])object).length; ++i) {
                    string = i % 3 == 0 ? string.concat(String.valueOf((int)(object[i] + vector4.size()))).concat(" ") : string.concat(String.valueOf((int)object[i])).concat(" ");
                }
                GML3g.addCoords(vector3, string);
                String string3 = "";
                for (n = 0; n < ((double[])object2).length; ++n) {
                    string3 = string3.concat(String.valueOf(object2[n])).concat(" ");
                }
                GML3g.addCoords(vector4, string3);
                continue;
            }
            if (node2 != null) {
                object2 = null;
                object2 = GML3g.fromNodeToCompositeCurve(node2);
                object2.getElemInfo()[1] = 1005;
                object = "";
                for (int i = 0; i < object2.getElemInfo().length; ++i) {
                    object = i % 3 == 0 ? object.concat(String.valueOf(object2.getElemInfo()[i] + vector4.size())).concat(" ") : object.concat(String.valueOf(object2.getElemInfo()[i])).concat(" ");
                }
                GML3g.addCoords(vector3, (String)object);
                string = "";
                for (int i = 0; i < object2.getOrdinatesArray().length; ++i) {
                    string = string.concat(String.valueOf(object2.getOrdinatesArray()[i])).concat(" ");
                }
                GML3g.addCoords(vector4, string);
                continue;
            }
            throw new DataException("Invalid Polygon");
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            object3 = (Node)vector2.get(n2);
            node4 = GML3g.getFirst((Node)object3, new String[]{"LinearRing"});
            node3 = GML3g.getFirst((Node)object3, new String[]{"Circle"});
            node2 = GML3g.getFirst((Node)object3, new String[]{"Ring"});
            if (node4 != null) {
                object2 = GML3g.getOrdinatesFromNode(node4);
                object = new int[3];
                object = ((double[])object2).length > n3 * 2 ? new int[]{1, 2003, 1} : new int[]{1, 2003, 3};
                string = "";
                for (int i = 0; i < ((Object)object).length; ++i) {
                    string = i % 3 == 0 ? string.concat(String.valueOf((int)(object[i] + vector4.size()))).concat(" ") : string.concat(String.valueOf((int)object[i])).concat(" ");
                }
                GML3g.addCoords(vector3, string);
                String string4 = "";
                for (n = 0; n < ((double[])object2).length; ++n) {
                    string4 = string4.concat(String.valueOf(object2[n])).concat(" ");
                }
                GML3g.addCoords(vector4, string4);
                continue;
            }
            if (node3 != null) {
                object2 = GML3g.getOrdinatesFromNode(node3);
                object = new int[3];
                object = new int[]{1, 2003, 4};
                string = "";
                for (int i = 0; i < ((Object)object).length; ++i) {
                    string = i % 3 == 0 ? string.concat(String.valueOf((int)(object[i] + vector4.size()))).concat(" ") : string.concat(String.valueOf((int)object[i])).concat(" ");
                }
                GML3g.addCoords(vector3, string);
                String string5 = "";
                for (n = 0; n < ((double[])object2).length; ++n) {
                    string5 = string5.concat(String.valueOf(object2[n])).concat(" ");
                }
                GML3g.addCoords(vector4, string5);
                continue;
            }
            if (node2 != null) {
                object2 = null;
                object2 = GML3g.fromNodeToCompositeCurve(node2);
                object2.getElemInfo()[1] = 2005;
                object = "";
                for (int i = 0; i < object2.getElemInfo().length; ++i) {
                    object = i % 3 == 0 ? object.concat(String.valueOf(object2.getElemInfo()[i] + vector4.size())).concat(" ") : object.concat(String.valueOf(object2.getElemInfo()[i])).concat(" ");
                }
                GML3g.addCoords(vector3, (String)object);
                string = "";
                for (int i = 0; i < object2.getOrdinatesArray().length; ++i) {
                    string = string.concat(String.valueOf(object2.getOrdinatesArray()[i])).concat(" ");
                }
                GML3g.addCoords(vector4, string);
                continue;
            }
            throw new DataException("Invalid Polygon");
        }
        n2 = GML3g.getSRIDFromNode(node);
        object3 = new int[vector3.size()];
        for (int i = 0; i < ((Object)object3).length; ++i) {
            object3[i] = Integer.parseInt((String)vector3.get(i));
        }
        double[] dArray = new double[vector4.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector4.get(i));
        }
        return new JGeometry(n3 * 1000 + 3, n2, (int[])object3, dArray);
    }

    public static JGeometry fromNodeToSurface(Node node) throws DataException, Exception {
        return GML3g.fromNodeToPolygon(node);
    }

    public static JGeometry fromNodeToMultiCurve(Node node) throws DataException, Exception {
        int n;
        Object object;
        int n2 = 0;
        Vector vector = GML3g.getAll(node, new String[]{"curveMember"});
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Node node2 = GML3g.getFirst(node, new String[]{"curveMember", "CompositeCurve", "curveMember", "Curve", "segments", "LineStringSegment"});
        Node node3 = GML3g.getFirst(node, new String[]{"curveMember", "CompositeCurve", "curveMember", "Curve", "segments", "Arc"});
        if (node2 != null || node3 != null) {
            n2 = node2 != null ? GML3g.guessDimensionality(node2) : GML3g.guessDimensionality(node3);
        } else {
            Node node4 = GML3g.getFirst(node, new String[]{"curveMember", "Curve", "segments", "LineStringSegment"});
            object = GML3g.getFirst(node, new String[]{"curveMember", "Curve", "segments", "Arc"});
            n2 = node4 != null ? GML3g.guessDimensionality(node4) : GML3g.guessDimensionality((Node)object);
        }
        for (n = 0; n < vector.size(); ++n) {
            object = (Node)vector.get(n);
            Node node5 = GML3g.getFirst((Node)object, new String[]{"CompositeCurve"});
            Node node6 = GML3g.getFirst((Node)object, new String[]{"Curve"});
            JGeometry jGeometry = null;
            if (node5 != null) {
                jGeometry = GML3g.fromNodeToGeometry(node5);
            } else if (node6 != null) {
                jGeometry = GML3g.fromNodeToGeometry(node6);
            } else {
                throw new Exception("Invalid Curve");
            }
            String string = "";
            for (int i = 0; i < jGeometry.getElemInfo().length; ++i) {
                string = i % 3 == 0 ? string.concat(String.valueOf(jGeometry.getElemInfo()[i] + vector3.size())).concat(" ") : string.concat(String.valueOf(jGeometry.getElemInfo()[i])).concat(" ");
            }
            GML3g.addCoords(vector2, string);
            String string2 = "";
            for (int i = 0; i < jGeometry.getOrdinatesArray().length; ++i) {
                string2 = string2.concat(String.valueOf(jGeometry.getOrdinatesArray()[i])).concat(" ");
            }
            GML3g.addCoords(vector3, string2);
        }
        n = GML3g.getSRIDFromNode(node);
        object = new int[vector2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = Integer.parseInt((String)vector2.get(i));
        }
        double[] dArray = new double[vector3.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector3.get(i));
        }
        return new JGeometry(n2 * 1000 + 6, n, (int[])object, dArray);
    }

    public static JGeometry fromNodeToMultiPoint(Node node) throws DataException, Exception {
        int n = GML3g.getSRIDFromNode(node);
        int n2 = GML3g.guessDimensionality(GML3g.getFirst(node, new String[]{"pointMember", "Point"}));
        Vector vector = GML3g.getAll(node, new String[]{"pointMember", "Point"});
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = GML3g.getOrdinatesFromNode((Node)vector.get(i));
            objectArray[i] = dArray;
        }
        return JGeometry.createMultiPoint((Object[])objectArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToGeometry(Node node) throws DataException, Exception {
        Locale.setDefault(ENGLISH);
        String string = GML3g.normalize(node.getNodeName()).toUpperCase();
        if (string.equals("POINT")) {
            return GML3g.fromNodeToPoint(node);
        }
        if (string.equals("LINESTRING")) {
            return GML3g.fromNodeToLineString(node);
        }
        if (string.equals("CURVE")) {
            return GML3g.fromNodeToCurve(node);
        }
        if (string.equals("COMPOSITECURVE")) {
            return GML3g.fromNodeToCompositeCurve(node);
        }
        if (string.equals("POLYGON")) {
            return GML3g.fromNodeToPolygon(node);
        }
        if (string.equals("SURFACE")) {
            return GML3g.fromNodeToSurface(node);
        }
        if (string.equals("COMPOSITESURFACE")) {
            return GML3g.fromNodeToCompositeSurface(node);
        }
        if (string.equals("MULTIGEOMETRY")) {
            return GML3g.fromNodeToGeometryCollection(node);
        }
        if (string.equals("MULTIPOINT")) {
            return GML3g.fromNodeToMultiPoint(node);
        }
        if (string.equals("MULTICURVE")) {
            return GML3g.fromNodeToMultiCurve(node);
        }
        if (string.equals("MULTIPOLYGON")) {
            return GML3g.fromNodeToMultiSurface(node);
        }
        if (string.equals("MULTISURFACE")) {
            return GML3g.fromNodeToMultiSurface(node);
        }
        if (string.equals("ENVELOPE")) {
            return GML3g.fromNodeToEnvelope(node);
        }
        if (string.equals("LINEARRING")) {
            return GML3g.fromNodeToLinearRing(node);
        }
        if (string.equals("SOLID")) {
            return GML3g.fromNodeToSolid(node);
        }
        if (string.equals("COMPOSITESOLID")) {
            return GML3g.fromNodeToCompositeSolid(node);
        }
        if (string.equals("MULTISOLID")) {
            return GML3g.fromNodeToMultiSolid(node);
        }
        throw new DataException("GML Geometry type " + node.getNodeName() + " not supported.");
    }

    public static JGeometry fromNodeToGeometryCollection(Node node) throws DataException, Exception {
        Object object;
        Object object2;
        int n;
        Locale.setDefault(ENGLISH);
        int n2 = 0;
        Vector<JGeometry> vector = new Vector<JGeometry>();
        int n3 = 0;
        int n4 = 0;
        Vector vector2 = GML3g.getAll(node, new String[]{"geometryMember"});
        for (n = 0; n < vector2.size(); ++n) {
            object2 = (Node)vector2.get(n);
            object = null;
            for (object = (Object)object2.getFirstChild(); object != null && !gmlTypes.contains(GML3g.normalize(object.getNodeName().toUpperCase())); object = object.getNextSibling()) {
            }
            if (object == null) continue;
            JGeometry jGeometry = GML3g.fromNodeToGeometry((Node)object);
            vector.add(jGeometry);
            if (jGeometry.getPoint() != null) {
                n3 += 3;
                n4 += jGeometry.getPoint().length;
                continue;
            }
            n3 += jGeometry.getElemInfo().length;
            n4 += jGeometry.getOrdinatesArray().length;
        }
        n = GML3g.getSRIDFromNode(node);
        object2 = new int[n3];
        object = new double[n4];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n7;
            JGeometry jGeometry = (JGeometry)vector.get(i);
            n2 = jGeometry.getDimensions();
            int[] nArray = jGeometry.getElemInfo();
            double[] dArray = jGeometry.getOrdinatesArray();
            if (jGeometry.getPoint() != null) {
                object2[n5 + 0] = n6 + 1;
                object2[n5 + 1] = true;
                object2[n5 + 2] = true;
                n5 += 3;
                for (n7 = 0; n7 < jGeometry.getPoint().length; ++n7) {
                    object[n6 + n7] = jGeometry.getPoint()[n7];
                }
                n6 += jGeometry.getPoint().length;
                continue;
            }
            for (n7 = 0; n7 < nArray.length; n7 += 3) {
                object2[n5 + n7 + 0] = nArray[n7 + 0] + n6;
                object2[n5 + n7 + 1] = nArray[n7 + 1];
                object2[n5 + n7 + 2] = nArray[n7 + 2];
            }
            n5 += nArray.length;
            for (n7 = 0; n7 < dArray.length; ++n7) {
                object[n6 + n7] = dArray[n7];
            }
            n6 += dArray.length;
        }
        if (n2 == 0) {
            throw new DataException("54555");
        }
        return new JGeometry(n2 * 1000 + 4, n, (int[])object2, (double[])object);
    }

    public static JGeometry fromNodeToLinearRing(Node node) throws DataException, Exception {
        Node node2 = GML3g.getFirst(node, new String[]{"posList"});
        int n = GML3g.guessDimensionality(node);
        Vector<String> vector = new Vector<String>();
        if (node2 == null) {
            double[] dArray = GML3g.getOrdinatesFromNode(node);
            for (int i = 0; i < dArray.length; ++i) {
                vector.add(Double.toString(dArray[i]));
            }
        } else {
            GML3g.addCoords(vector, node2.getFirstChild().getNodeValue());
        }
        int n2 = GML3g.getSRIDFromNode(node);
        int[] nArray = new int[]{1, 2, 1};
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector.get(i));
        }
        if (n == 2 && dArray.length < 8 || n == 3 && dArray.length < 12) {
            throw new DataException("13343");
        }
        return new JGeometry(n * 1000 + 2, n2, nArray, dArray);
    }

    public static JGeometry fromNodeToMultiSurface(Node node) throws DataException, Exception {
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = GML3g.getAll(node, new String[]{"surfaceMember", "CompositeSurface"});
        for (int i = 0; i < vector3.size(); ++i) {
            Node node2 = (Node)vector3.get(i);
            object3 = GML3g.fromNodeToGeometry(node2);
            n2 = object3.getDimensions();
            object2 = object3.getElemInfo();
            for (int j = 0; j < ((int[])object2).length; ++j) {
                if (j % 3 == 0) {
                    vector.add("" + (object2[j] - 1 + vector2.size() + 1));
                    continue;
                }
                vector.add("" + object2[j]);
            }
            object = object3.getOrdinatesArray();
            for (int j = 0; j < ((double[])object).length; ++j) {
                vector2.add(Double.toString(object[j]));
            }
        }
        Vector vector4 = GML3g.getAll(node, new String[]{"surfaceMember", "Polygon"});
        for (n = 0; n < vector4.size(); ++n) {
            object3 = (Node)vector4.get(n);
            object2 = GML3g.fromNodeToGeometry((Node)object3);
            n2 = object2.getDimensions();
            object = "";
            for (int i = 0; i < object2.getElemInfo().length; ++i) {
                object = i % 3 == 0 ? ((String)object).concat(String.valueOf(object2.getElemInfo()[i] + vector2.size())).concat(" ") : ((String)object).concat(String.valueOf(object2.getElemInfo()[i])).concat(" ");
            }
            GML3g.addCoords(vector, (String)object);
            String string = "";
            for (int i = 0; i < object2.getOrdinatesArray().length; ++i) {
                string = string.concat(String.valueOf(object2.getOrdinatesArray()[i])).concat(" ");
            }
            GML3g.addCoords(vector2, string);
        }
        n = GML3g.getSRIDFromNode(node);
        object3 = new int[vector.size()];
        for (int i = 0; i < ((JGeometry)object3).length; ++i) {
            object3[i] = (JGeometry)Integer.parseInt((String)vector.get(i));
        }
        double[] dArray = new double[vector2.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector2.get(i));
        }
        if (n2 == 0) {
            throw new DataException("54555");
        }
        return new JGeometry(n2 * 1000 + 7, n, (int[])object3, dArray);
    }

    protected static void addCoords(Vector vector, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace(',', ' '));
        while (stringTokenizer.hasMoreElements()) {
            vector.add(stringTokenizer.nextElement());
        }
    }

    protected static Vector getAll(Node node, String[] stringArray) {
        Vector vector = new Vector();
        GML3g.getAll(node, stringArray, 0, vector);
        return vector;
    }

    protected static void getAll(Node node, String[] stringArray, int n, Vector vector) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!GML3g.normalize(node2.getNodeName()).equalsIgnoreCase(stringArray[n])) continue;
            if (n + 1 == stringArray.length) {
                vector.add(node2);
                continue;
            }
            GML3g.getAll(node2, stringArray, n + 1, vector);
        }
    }

    protected static Node getFirst(Node node, String[] stringArray) {
        return GML3g.getFirst(node, stringArray, 0);
    }

    protected static Node getFirst(Node node, String[] stringArray, int n) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!GML3g.normalize(node2.getNodeName()).equalsIgnoreCase(stringArray[n])) continue;
            if (n + 1 == stringArray.length) {
                return node2;
            }
            Node node3 = GML3g.getFirst(node2, stringArray, n + 1);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    protected static String normalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(":") >= 0) {
            return string.substring(string.indexOf(":") + 1);
        }
        return string;
    }

    public static JGeometry fromNodeToCompositeCurve(Node node) throws DataException, Exception {
        Object object;
        int n;
        int n2 = 0;
        Vector vector = GML3g.getAll(node, new String[]{"curveMember", "Curve"});
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector();
        vector2.add("" + (vector3.size() + 1));
        vector2.add("4");
        vector2.add("" + vector.size());
        Node node2 = GML3g.getFirst(node, new String[]{"curveMember", "Curve", "segments", "LineStringSegment"});
        if (node2 != null) {
            n2 = GML3g.guessDimensionality(node2);
        } else {
            Node node3 = GML3g.getFirst(node, new String[]{"curveMember", "Curve", "segments", "Arc"});
            n2 = GML3g.guessDimensionality(node3);
        }
        for (n = 0; n < vector.size(); ++n) {
            int n3;
            object = (Node)vector.get(n);
            JGeometry jGeometry = GML3g.fromNodeToGeometry((Node)object);
            String string = "";
            for (int i = 0; i < jGeometry.getElemInfo().length; ++i) {
                string = i % 3 == 0 ? string.concat(String.valueOf(jGeometry.getElemInfo()[i] + vector3.size())).concat(" ") : string.concat(String.valueOf(jGeometry.getElemInfo()[i])).concat(" ");
            }
            GML3g.addCoords(vector2, string);
            String string2 = "";
            if (n + 1 == vector.size()) {
                for (n3 = 0; n3 < jGeometry.getOrdinatesArray().length; ++n3) {
                    string2 = string2.concat(String.valueOf(jGeometry.getOrdinatesArray()[n3])).concat(" ");
                }
            } else {
                for (n3 = 0; n3 < jGeometry.getOrdinatesArray().length - 2; ++n3) {
                    string2 = string2.concat(String.valueOf(jGeometry.getOrdinatesArray()[n3])).concat(" ");
                }
            }
            GML3g.addCoords(vector3, string2);
        }
        n = GML3g.getSRIDFromNode(node);
        object = new int[vector2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = Integer.parseInt((String)vector2.get(i));
        }
        double[] dArray = new double[vector3.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector3.get(i));
        }
        return new JGeometry(n2 * 1000 + 2, n, (int[])object, dArray);
    }

    public static JGeometry fromNodeToCompositeSurface(Node node) throws DataException, Exception {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2 = GML3g.guessDimensionality(GML3g.getFirst(node, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing"}));
        Vector vector = GML3g.getAll(node, new String[]{"surfaceMember", "Polygon"});
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector();
        vector2.add("" + (vector3.size() + 1));
        vector2.add("1006");
        vector2.add("" + vector.size());
        Vector vector4 = GML3g.getAll(node, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing", "pos"});
        if (vector4.size() != 0) {
            for (n = 0; n < vector.size(); ++n) {
                object3 = (Node)vector.get(n);
                object2 = GML3g.fromNodeToGeometry((Node)object3);
                object = "";
                for (int i = 0; i < object2.getElemInfo().length; ++i) {
                    object = i % 3 == 0 ? ((String)object).concat(String.valueOf(object2.getElemInfo()[i] + vector3.size())).concat(" ") : ((String)object).concat(String.valueOf(object2.getElemInfo()[i])).concat(" ");
                }
                GML3g.addCoords(vector2, (String)object);
                String string = "";
                for (int i = 0; i < object2.getOrdinatesArray().length; ++i) {
                    string = string.concat(String.valueOf(object2.getOrdinatesArray()[i])).concat(" ");
                }
                GML3g.addCoords(vector3, string);
            }
        } else {
            for (n = 0; n < vector.size(); ++n) {
                int n3;
                object3 = (Node)vector.get(n);
                object2 = GML3g.getAll((Node)object3, new String[]{"interior", "LinearRing", "posList"});
                object = GML3g.getAll((Node)object3, new String[]{"exterior", "LinearRing", "posList"});
                for (n3 = 0; n3 < ((Vector)object).size(); ++n3) {
                    vector2.add("" + (vector3.size() + 1));
                    vector2.add("1003");
                    vector2.add("1");
                    GML3g.addCoords(vector3, ((Node)((Vector)object).get(n3)).getFirstChild().getNodeValue());
                }
                for (n3 = 0; n3 < ((Vector)object2).size(); ++n3) {
                    vector2.add("" + (vector3.size() + 1));
                    vector2.add("2003");
                    vector2.add("1");
                    GML3g.addCoords(vector3, ((Node)((Vector)object2).get(n3)).getFirstChild().getNodeValue());
                }
            }
        }
        n = GML3g.getSRIDFromNode(node);
        object3 = new int[vector2.size()];
        for (int i = 0; i < ((Object)object3).length; ++i) {
            object3[i] = Integer.parseInt((String)vector2.get(i));
        }
        double[] dArray = new double[vector3.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector3.get(i));
        }
        return new JGeometry(n2 * 1000 + 3, n, (int[])object3, dArray);
    }

    public static JGeometry fromNodeToSolid(Node node) throws DataException, Exception {
        Object object;
        Object object2;
        int n;
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        int n2 = GML3g.guessDimensionality(GML3g.getFirst(node, new String[]{"exterior", "CompositeSurface", "surfaceMember", "Polygon", "exterior", "LinearRing"}));
        Vector vector3 = GML3g.getAll(node, new String[]{"exterior", "CompositeSurface"});
        Vector vector4 = GML3g.getAll(node, new String[]{"interior", "CompositeSurface"});
        vector.add("" + (vector2.size() + 1));
        vector.add("1007");
        vector.add("1");
        Node node2 = (Node)vector3.get(0);
        Vector vector5 = GML3g.getAll(node2, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing", "pos"});
        if (vector5.size() != 0) {
            vector5 = GML3g.getAll(node2, new String[]{"surfaceMember", "Polygon"});
            vector.add("" + (vector2.size() + 1));
            vector.add("1006");
            vector.add("" + vector5.size());
            for (n = 0; n < vector5.size(); ++n) {
                object2 = (Node)vector5.get(n);
                JGeometry jGeometry = GML3g.fromNodeToGeometry((Node)object2);
                vector.add("" + (vector2.size() + 1));
                vector.add("1003");
                vector.add("1");
                object = "";
                for (int i = 0; i < jGeometry.getOrdinatesArray().length; ++i) {
                    object = ((String)object).concat(String.valueOf(jGeometry.getOrdinatesArray()[i])).concat(" ");
                }
                GML3g.addCoords(vector2, (String)object);
            }
        } else {
            vector5 = GML3g.getAll(node2, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing", "posList"});
            vector.add("" + (vector2.size() + 1));
            vector.add("1006");
            vector.add("" + vector5.size());
            for (n = 0; n < vector5.size(); ++n) {
                vector.add("" + (vector2.size() + 1));
                vector.add("1003");
                vector.add("1");
                GML3g.addCoords(vector2, ((Node)vector5.get(n)).getFirstChild().getNodeValue());
            }
        }
        vector5.clear();
        for (n = 0; n < vector4.size(); ++n) {
            int n3;
            object2 = (Node)vector4.get(n);
            vector5 = GML3g.getAll((Node)object2, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing", "pos"});
            if (vector5.size() != 0) {
                vector5 = GML3g.getAll((Node)object2, new String[]{"surfaceMember", "Polygon"});
                vector.add("" + (vector2.size() + 1));
                vector.add("2006");
                vector.add("" + vector5.size());
                for (n3 = 0; n3 < vector5.size(); ++n3) {
                    object = (Node)vector5.get(n3);
                    JGeometry jGeometry = GML3g.fromNodeToGeometry((Node)object);
                    vector.add("" + (vector2.size() + 1));
                    vector.add("2003");
                    vector.add("1");
                    String string = "";
                    for (int i = 0; i < jGeometry.getOrdinatesArray().length; ++i) {
                        string = string.concat(String.valueOf(jGeometry.getOrdinatesArray()[i])).concat(" ");
                    }
                    GML3g.addCoords(vector2, string);
                }
                continue;
            }
            vector5 = GML3g.getAll((Node)object2, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing", "posList"});
            vector.add("" + (vector2.size() + 1));
            vector.add("2006");
            vector.add("" + vector5.size());
            for (n3 = 0; n3 < vector5.size(); ++n3) {
                vector.add("" + (vector2.size() + 1));
                vector.add("2003");
                vector.add("1");
                GML3g.addCoords(vector2, ((Node)vector5.get(n3)).getFirstChild().getNodeValue());
            }
        }
        n = GML3g.getSRIDFromNode(node);
        object2 = new int[vector.size()];
        for (int i = 0; i < ((Object)object2).length; ++i) {
            object2[i] = Integer.parseInt((String)vector.get(i));
        }
        double[] dArray = new double[vector2.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector2.get(i));
        }
        return new JGeometry(n2 * 1000 + 8, n, (int[])object2, dArray);
    }

    public static JGeometry fromNodeToCompositeSolid(Node node) throws DataException, Exception {
        Object object;
        Object object2;
        int n;
        Locale.setDefault(ENGLISH);
        Vector<JGeometry> vector = new Vector<JGeometry>();
        int n2 = 0;
        int n3 = 0;
        int n4 = GML3g.guessDimensionality(GML3g.getFirst(node, new String[]{"solidMember", "Solid", "exterior", "CompositeSurface", "surfaceMember", "Polygon", "exterior", "LinearRing"}));
        Vector vector2 = GML3g.getAll(node, new String[]{"solidMember"});
        for (n = 0; n < vector2.size(); ++n) {
            object2 = (Node)vector2.get(n);
            object = null;
            for (object = object2.getFirstChild(); object != null && !gmlTypes.contains(GML3g.normalize(object.getNodeName().toUpperCase())); object = object.getNextSibling()) {
            }
            if (object == null) continue;
            JGeometry jGeometry = GML3g.fromNodeToGeometry((Node)object);
            vector.add(jGeometry);
            if (jGeometry.getPoint() != null) {
                n2 += 3;
                n3 += jGeometry.getPoint().length;
                continue;
            }
            n2 += jGeometry.getElemInfo().length;
            n3 += jGeometry.getOrdinatesArray().length;
        }
        n = GML3g.getSRIDFromNode(node);
        object2 = new int[n2 + 3];
        object = new double[n3];
        object2[0] = true;
        object2[1] = 1008;
        object2[2] = vector2.size();
        int n5 = 3;
        int n6 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n7;
            JGeometry jGeometry = (JGeometry)vector.get(i);
            int[] nArray = jGeometry.getElemInfo();
            double[] dArray = jGeometry.getOrdinatesArray();
            if (jGeometry.getPoint() != null) {
                object2[n5 + 0] = n6 + 1;
                object2[n5 + 1] = true;
                object2[n5 + 2] = true;
                n5 += 3;
                for (n7 = 0; n7 < jGeometry.getPoint().length; ++n7) {
                    object[n6 + n7] = jGeometry.getPoint()[n7];
                }
                n6 += jGeometry.getPoint().length;
                continue;
            }
            for (n7 = 0; n7 < nArray.length; n7 += 3) {
                object2[n5 + n7 + 0] = nArray[n7 + 0] + n6;
                object2[n5 + n7 + 1] = nArray[n7 + 1];
                object2[n5 + n7 + 2] = nArray[n7 + 2];
            }
            n5 += nArray.length;
            for (n7 = 0; n7 < dArray.length; ++n7) {
                object[n6 + n7] = dArray[n7];
            }
            n6 += dArray.length;
        }
        return new JGeometry(n4 * 1000 + 8, n, (int[])object2, (double[])object);
    }

    public static JGeometry fromNodeToMultiSolid(Node node) throws DataException, Exception {
        int n;
        Object[] objectArray;
        Object object;
        Object object2;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = GML3g.getAll(node, new String[]{"solidMember", "CompositeSolid"});
        for (int i = 0; i < vector3.size(); ++i) {
            Node node2 = (Node)vector3.get(i);
            object2 = GML3g.fromNodeToGeometry(node2);
            n2 = object2.getDimensions();
            object = object2.getElemInfo();
            for (int j = 0; j < ((int[])object).length; ++j) {
                if (j % 3 == 0) {
                    vector.add("" + (object[j] - 1 + vector2.size() + 1));
                    continue;
                }
                vector.add("" + object[j]);
            }
            objectArray = object2.getOrdinatesArray();
            for (int j = 0; j < objectArray.length; ++j) {
                vector2.add(Double.toString(objectArray[j]));
            }
        }
        Vector vector4 = GML3g.getAll(node, new String[]{"solidMember", "Solid"});
        for (n = 0; n < vector4.size(); ++n) {
            object2 = (Node)vector4.get(n);
            object = GML3g.fromNodeToGeometry((Node)object2);
            n2 = object.getDimensions();
            objectArray = object.getElemInfo();
            for (int i = 0; i < objectArray.length; ++i) {
                if (i % 3 == 0) {
                    vector.add("" + (int)(objectArray[i] - true + vector2.size() + true));
                    continue;
                }
                vector.add("" + (int)objectArray[i]);
            }
            double[] dArray = object.getOrdinatesArray();
            for (int i = 0; i < dArray.length; ++i) {
                vector2.add(Double.toString(dArray[i]));
            }
        }
        n = GML3g.getSRIDFromNode(node);
        object2 = new int[vector.size()];
        for (int i = 0; i < ((JGeometry)object2).length; ++i) {
            object2[i] = (JGeometry)Integer.parseInt((String)vector.get(i));
        }
        double[] dArray = new double[vector2.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector2.get(i));
        }
        if (n2 == 0) {
            throw new DataException("54555");
        }
        return new JGeometry(n2 * 1000 + 9, n, (int[])object2, dArray);
    }

    static {
        _srsNameSpace = "Test";
        ENGLISH = new Locale("en_US");
        gmlTypes = new HashSet(16);
        gmlTypes.add("POINT");
        gmlTypes.add("LINESTRING");
        gmlTypes.add("CURVE");
        gmlTypes.add("COMPOSITECURVE");
        gmlTypes.add("POLYGON");
        gmlTypes.add("SURFACE");
        gmlTypes.add("COMPOSITESURFACE");
        gmlTypes.add("MULTIGEOMETRY");
        gmlTypes.add("MULTIPOINT");
        gmlTypes.add("MULTICURVE");
        gmlTypes.add("MULTIPOLYGON");
        gmlTypes.add("MULTISURFACE");
        gmlTypes.add("ENVELOPE");
        gmlTypes.add("LINEARRING");
        gmlTypes.add("SOLID");
        gmlTypes.add("COMPOSITESOLID");
        gmlTypes.add("MULTISOLID");
    }
}

