/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import oracle.spatial.util.SDODoubleGeneralPathIterator;
import sun.awt.geom.Crossings;
import sun.awt.geom.Curve;

public final class SDODoubleGeneralPath
implements Shape,
Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    byte[] pointTypes;
    double[] pointCoords;
    int numTypes;
    int numCoords;
    int windingRule;
    static final int INIT_SIZE = 20;
    static final int EXPAND_MAX = 500;

    public SDODoubleGeneralPath() {
        this(1, 20, 20);
    }

    public SDODoubleGeneralPath(int n) {
        this(n, 20, 20);
    }

    public SDODoubleGeneralPath(int n, int n2) {
        this(n, n2, n2);
    }

    SDODoubleGeneralPath(int n, int n2, int n3) {
        this.setWindingRule(n);
        this.pointTypes = new byte[n2];
        this.pointCoords = new double[n3 * 2];
    }

    public SDODoubleGeneralPath(Shape shape) {
        this(1, 20, 20);
        PathIterator pathIterator = shape.getPathIterator(null);
        this.setWindingRule(pathIterator.getWindingRule());
        this.append(pathIterator, false);
    }

    private void needRoom(int n, int n2, boolean bl) {
        Object[] objectArray;
        int n3;
        if (bl && this.numTypes == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        int n4 = this.pointCoords.length;
        if (this.numCoords + n2 > n4) {
            n3 = n4;
            if (n3 > 1000) {
                n3 = 1000;
            }
            if (n3 < n2) {
                n3 = n2;
            }
            objectArray = new double[n4 + n3];
            System.arraycopy(this.pointCoords, 0, objectArray, 0, this.numCoords);
            this.pointCoords = objectArray;
        }
        if (this.numTypes + n > (n4 = this.pointTypes.length)) {
            n3 = n4;
            if (n3 > 500) {
                n3 = 500;
            }
            if (n3 < n) {
                n3 = n;
            }
            objectArray = new byte[n4 + n3];
            System.arraycopy(this.pointTypes, 0, objectArray, 0, this.numTypes);
            this.pointTypes = (byte[])objectArray;
        }
    }

    public synchronized void moveTo(double d, double d2) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.pointCoords[this.numCoords - 2] = d;
            this.pointCoords[this.numCoords - 1] = d2;
        } else {
            this.needRoom(1, 2, false);
            this.pointTypes[this.numTypes++] = 0;
            this.pointCoords[this.numCoords++] = d;
            this.pointCoords[this.numCoords++] = d2;
        }
    }

    public synchronized void lineTo(double d, double d2) {
        this.needRoom(1, 2, true);
        this.pointTypes[this.numTypes++] = 1;
        this.pointCoords[this.numCoords++] = d;
        this.pointCoords[this.numCoords++] = d2;
    }

    public synchronized void quadTo(double d, double d2, double d3, double d4) {
        this.needRoom(1, 4, true);
        this.pointTypes[this.numTypes++] = 2;
        this.pointCoords[this.numCoords++] = d;
        this.pointCoords[this.numCoords++] = d2;
        this.pointCoords[this.numCoords++] = d3;
        this.pointCoords[this.numCoords++] = d4;
    }

    public synchronized void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.needRoom(1, 6, true);
        this.pointTypes[this.numTypes++] = 3;
        this.pointCoords[this.numCoords++] = d;
        this.pointCoords[this.numCoords++] = d2;
        this.pointCoords[this.numCoords++] = d3;
        this.pointCoords[this.numCoords++] = d4;
        this.pointCoords[this.numCoords++] = d5;
        this.pointCoords[this.numCoords++] = d6;
    }

    public synchronized void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(1, 0, true);
            this.pointTypes[this.numTypes++] = 4;
        }
    }

    public void append(Shape shape, boolean bl) {
        PathIterator pathIterator = shape.getPathIterator(null);
        this.append(pathIterator, bl);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    if (!bl || this.numTypes < 1 || this.numCoords < 2) {
                        this.moveTo(dArray[0], dArray[1]);
                        break;
                    }
                    if (this.pointTypes[this.numTypes - 1] != 4 && this.pointCoords[this.numCoords - 2] == dArray[0] && this.pointCoords[this.numCoords - 1] == dArray[1]) break;
                }
                case 1: {
                    this.lineTo(dArray[0], dArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            pathIterator.next();
            bl = false;
        }
    }

    public synchronized int getWindingRule() {
        return this.windingRule;
    }

    public void setWindingRule(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized Point2D getCurrentPoint() {
        if (this.numTypes < 1) return null;
        if (this.numCoords < 2) {
            return null;
        }
        int n = this.numCoords;
        if (this.pointTypes[this.numTypes - 1] != 4) return new Point2D.Double(this.pointCoords[n - 2], this.pointCoords[n - 1]);
        int n2 = this.numTypes - 2;
        while (n2 > 0) {
            switch (this.pointTypes[n2]) {
                case 0: {
                    return new Point2D.Double(this.pointCoords[n - 2], this.pointCoords[n - 1]);
                }
                case 1: {
                    n -= 2;
                    break;
                }
                case 2: {
                    n -= 4;
                    break;
                }
                case 3: {
                    n -= 6;
                }
            }
            --n2;
        }
        return new Point2D.Double(this.pointCoords[n - 2], this.pointCoords[n - 1]);
    }

    public synchronized void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transform(this.pointCoords, 0, this.pointCoords, 0, this.numCoords / 2);
    }

    public synchronized Shape createTransformedShape(AffineTransform affineTransform) {
        SDODoubleGeneralPath sDODoubleGeneralPath = (SDODoubleGeneralPath)this.clone();
        if (affineTransform != null) {
            sDODoubleGeneralPath.transform(affineTransform);
        }
        return sDODoubleGeneralPath;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public synchronized Rectangle2D getBounds2D() {
        double d;
        double d2;
        double d3;
        double d4;
        int n = this.numCoords;
        if (n > 0) {
            d3 = d4 = this.pointCoords[--n];
            d = d2 = this.pointCoords[--n];
            while (n > 0) {
                double d5;
                double d6 = this.pointCoords[--n];
                if ((d5 = this.pointCoords[--n]) < d) {
                    d = d5;
                }
                if (d6 < d3) {
                    d3 = d6;
                }
                if (d5 > d2) {
                    d2 = d5;
                }
                if (!(d6 > d4)) continue;
                d4 = d6;
            }
        } else {
            d4 = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            d = 0.0;
        }
        return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
    }

    public boolean contains(double d, double d2) {
        if (this.numTypes < 2) {
            return false;
        }
        int n = Curve.crossingsForPath((PathIterator)this.getPathIterator(null), (double)d, (double)d2);
        if (this.windingRule == 1) {
            return n != 0;
        }
        return (n & 1) != 0;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        Crossings crossings = Crossings.findCrossings(this.getPathIterator(null), d, d2, d + d3, d2 + d4);
        return crossings != null && crossings.covers(d2, d2 + d4);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        Crossings crossings = Crossings.findCrossings(this.getPathIterator(null), d, d2, d + d3, d2 + d4);
        return crossings == null || !crossings.isEmpty();
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new SDODoubleGeneralPathIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public Object clone() {
        try {
            SDODoubleGeneralPath sDODoubleGeneralPath = (SDODoubleGeneralPath)super.clone();
            sDODoubleGeneralPath.pointTypes = (byte[])this.pointTypes.clone();
            sDODoubleGeneralPath.pointCoords = (double[])this.pointCoords.clone();
            return sDODoubleGeneralPath;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    SDODoubleGeneralPath(int n, byte[] byArray, int n2, double[] dArray, int n3) {
        this.windingRule = n;
        this.pointTypes = byArray;
        this.numTypes = n2;
        this.pointCoords = dArray;
        this.numCoords = n3;
    }
}

