/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import oracle.spatial.util.SDODoubleGeneralPath;

class SDODoubleGeneralPathIterator
implements PathIterator {
    int typeIdx = 0;
    int pointIdx = 0;
    SDODoubleGeneralPath path;
    AffineTransform affine;
    private static final int[] curvesize = new int[]{2, 2, 4, 6, 0};

    SDODoubleGeneralPathIterator(SDODoubleGeneralPath sDODoubleGeneralPath) {
        this(sDODoubleGeneralPath, null);
    }

    SDODoubleGeneralPathIterator(SDODoubleGeneralPath sDODoubleGeneralPath, AffineTransform affineTransform) {
        this.path = sDODoubleGeneralPath;
        this.affine = affineTransform;
    }

    public int getWindingRule() {
        return this.path.getWindingRule();
    }

    public boolean isDone() {
        return this.typeIdx >= this.path.numTypes;
    }

    public void next() {
        byte by = this.path.pointTypes[this.typeIdx++];
        this.pointIdx += curvesize[by];
    }

    public int currentSegment(float[] fArray) {
        byte by = this.path.pointTypes[this.typeIdx];
        int n = curvesize[by];
        if (n > 0 && this.affine != null) {
            this.affine.transform(this.path.pointCoords, this.pointIdx, fArray, 0, n / 2);
        } else {
            for (int i = 0; i < n; ++i) {
                fArray[i * 2] = (float)this.path.pointCoords[this.pointIdx + i * 2];
                fArray[i * 2 + 1] = (float)this.path.pointCoords[this.pointIdx + i * 2 + 1];
            }
        }
        return by;
    }

    public int currentSegment(double[] dArray) {
        byte by = this.path.pointTypes[this.typeIdx];
        int n = curvesize[by];
        if (n > 0 && this.affine != null) {
            this.affine.transform(this.path.pointCoords, this.pointIdx, dArray, 0, n / 2);
        } else {
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.path.pointCoords[this.pointIdx + i];
            }
        }
        return by;
    }
}

