/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.IndexRecord;
import oracle.spatial.util.ShapefileHdr;

public class ShapefileReaderJGeom {
    public static final int AV_NULL = 0;
    public static final int AV_POINT = 1;
    public static final int AV_POLYLINE = 3;
    public static final int AV_POLYGON = 5;
    public static final int AV_MULTIPOINT = 8;
    public static final int AV_POINTZ = 11;
    public static final int AV_POLYLINEZ = 13;
    public static final int AV_POLYGONZ = 15;
    public static final int AV_MULTIPOINTZ = 18;
    public static final int AV_POINTM = 21;
    public static final int AV_POLYLINEM = 23;
    public static final int AV_POLYGONM = 25;
    public static final int AV_MULTIPOINTM = 28;
    protected int nRecords = 0;
    protected int type = 0;
    protected double xMax = 0.0;
    protected double xMin = 0.0;
    protected double yMax = 0.0;
    protected double yMin = 0.0;
    protected double zMax = 0.0;
    protected double zMin = 0.0;
    protected double measureMax = 0.0;
    protected double measureMin = 0.0;
    protected byte[] recBuffer = new byte[this.bufferLen];
    protected double[] partBuffer;
    protected int bufferLen = 512;
    protected int partBufferLen = this.bufferLen / 8 + 1;
    protected int cnt = 0;
    protected String namePrefix = null;
    protected ShapefileHdr mainFileHdr;
    protected ShapefileHdr idxFileHdr;
    protected RandomAccessFile mainFIS = null;
    protected RandomAccessFile idxFIS = null;

    public static int getShpDims(int n, double d) throws Exception {
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                return 2;
            }
            case 21: 
            case 23: 
            case 25: 
            case 28: {
                return 3;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                if (Double.isNaN(d) || d <= -1.0E39) {
                    return 3;
                }
                return 4;
            }
            case 0: {
                return 0;
            }
        }
        throw new Exception("Type not recognized: " + n);
    }

    public static JGeometry getGeometry(byte[] byArray, int n) throws Exception {
        int n2 = ShapefileReaderJGeom.makeIntLittleEndian(byArray, 8);
        return ShapefileReaderJGeom.getGeometry(byArray, n2, 12, n);
    }

    protected static JGeometry getGeometry(byte[] byArray, int n, int n2, int n3) throws Exception {
        switch (n) {
            case 1: {
                return ShapefileReaderJGeom.makePoint(byArray, n2, n3);
            }
            case 3: 
            case 5: {
                return ShapefileReaderJGeom.makePoly(byArray, n, n2, n3);
            }
            case 8: {
                return ShapefileReaderJGeom.makeMPoint(byArray, n2, n3);
            }
            case 11: {
                return ShapefileReaderJGeom.makePointZ(byArray, n2, n3);
            }
            case 13: 
            case 15: {
                return ShapefileReaderJGeom.makePolyZ(byArray, n, n2, n3);
            }
            case 18: {
                return ShapefileReaderJGeom.makeMPointZ(byArray, n2, n3);
            }
            case 21: {
                return ShapefileReaderJGeom.makePointM(byArray, n2, n3);
            }
            case 23: 
            case 25: {
                return ShapefileReaderJGeom.makePolyM(byArray, n, n2, n3);
            }
            case 0: {
                return null;
            }
        }
        throw new Exception("Type not supported: " + n + " / " + byArray.length);
    }

    protected static JGeometry makePoint(byte[] byArray, int n, int n2) throws IOException {
        double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n);
        double d2 = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n += 8);
        n += 8;
        double[] dArray = new double[]{d, d2};
        return JGeometry.createPoint((double[])dArray, (int)2, (int)n2);
    }

    protected static JGeometry makePointZ(byte[] byArray, int n, int n2) throws IOException {
        double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n);
        double d2 = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n += 8);
        double d3 = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n += 8);
        double d4 = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n += 8);
        if (Double.isNaN(d4) || d4 <= -1.0E39) {
            double[] dArray = new double[]{d, d2, d3};
            return JGeometry.createPoint((double[])dArray, (int)3, (int)n2);
        }
        double[] dArray = new double[]{d, d2, d3, d4};
        return JGeometry.createLRSPoint((double[])dArray, (int)3, (int)n2);
    }

    protected static JGeometry makePointM(byte[] byArray, int n, int n2) throws IOException {
        double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n);
        double d2 = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n += 8);
        double d3 = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n += 8);
        n += 8;
        if (d3 <= -1.0E39) {
            d3 = Double.NaN;
        }
        double[] dArray = new double[]{d, d2, d3};
        return JGeometry.createLRSPoint((double[])dArray, (int)2, (int)n2);
    }

    protected static JGeometry makeMPoint(byte[] byArray, int n, int n2) throws IOException {
        int n3 = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n += 32);
        JGeometry[] jGeometryArray = new JGeometry[n3];
        n += 4;
        for (int i = 0; i < n3; ++i) {
            double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n);
            double d2 = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n += 8);
            n += 8;
            double[] dArray = new double[]{d, d2};
            jGeometryArray[i] = JGeometry.createPoint((double[])dArray, (int)2, (int)n2);
        }
        double[][] dArrayArray = new double[jGeometryArray.length][];
        for (int i = 0; i < jGeometryArray.length; ++i) {
            dArrayArray[i] = jGeometryArray[i].getPoint();
        }
        return JGeometry.createMultiPoint((Object[])dArrayArray, (int)2, (int)n2);
    }

    protected static JGeometry makeMPointZ(byte[] byArray, int n, int n2) throws IOException {
        int n3 = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n += 32);
        JGeometry[] jGeometryArray = new JGeometry[n3];
        n += 4;
        int n4 = 40 + 16 * n3;
        int n5 = n4 + 16;
        for (int i = 0; i < n3; ++i) {
            double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n);
            double d2 = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n += 8);
            n += 8;
            double d3 = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n5);
            n5 += 8;
            double[] dArray = new double[]{d, d2, d3};
            jGeometryArray[i] = JGeometry.createPoint((double[])dArray, (int)3, (int)n2);
        }
        double[][] dArrayArray = new double[jGeometryArray.length][];
        for (int i = 0; i < jGeometryArray.length; ++i) {
            dArrayArray[i] = jGeometryArray[i].getPoint();
        }
        return JGeometry.createMultiPoint((Object[])dArrayArray, (int)3, (int)n2);
    }

    protected static JGeometry makePoly(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n2 += 32);
        int[] nArray = new int[n6 + 1];
        int n7 = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n2 += 4);
        n2 += 4;
        nArray[n6] = n7;
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n2);
            n2 += 4;
        }
        if (n == 5) {
            int n8;
            JGeometry[] jGeometryArray = new JGeometry[n6];
            for (int i = 0; i < n6; ++i) {
                n8 = nArray[i + 1] - nArray[i];
                double[] dArray = new double[2 * n8];
                for (int j = 0; j < n8 * 2; ++j) {
                    dArray[j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                    n2 += 8;
                }
                jGeometryArray[i] = JGeometry.createLinearLineString((double[])dArray, (int)2, (int)n3);
            }
            double[][] dArrayArray = new double[jGeometryArray.length][];
            for (n8 = 0; n8 < jGeometryArray.length; ++n8) {
                dArrayArray[n8] = jGeometryArray[n8].getOrdinatesArray();
            }
            JGeometry jGeometry = JGeometry.createLinearPolygon((Object[])dArrayArray, (int)2, (int)n3);
            return jGeometry;
        }
        if (n6 == 1) {
            n5 = nArray[1] - nArray[0];
            double[] dArray = new double[2 * n5];
            for (int i = 0; i < n5 * 2; ++i) {
                dArray[i] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                n2 += 8;
            }
            return JGeometry.createLinearLineString((double[])dArray, (int)2, (int)n3);
        }
        JGeometry[] jGeometryArray = new JGeometry[n6];
        for (int i = 0; i < n6; ++i) {
            n4 = nArray[i + 1] - nArray[i];
            double[] dArray = new double[2 * n4];
            for (int j = 0; j < n4 * 2; ++j) {
                dArray[j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                n2 += 8;
            }
            jGeometryArray[i] = JGeometry.createLinearLineString((double[])dArray, (int)2, (int)n3);
        }
        double[][] dArrayArray = new double[jGeometryArray.length][];
        for (n4 = 0; n4 < jGeometryArray.length; ++n4) {
            dArrayArray[n4] = jGeometryArray[n4].getOrdinatesArray();
        }
        return JGeometry.createLinearMultiLineString((Object[])dArrayArray, (int)2, (int)n3);
    }

    protected static JGeometry makePolyZ(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5 = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n2 += 32);
        int[] nArray = new int[n5 + 1];
        int n6 = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n2 += 4);
        n2 += 4;
        nArray[n5] = n6;
        for (n4 = 0; n4 < n5; ++n4) {
            nArray[n4] = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n2);
            n2 += 4;
        }
        n4 = n2 + 16 * n6;
        int n7 = n4 + 16;
        int n8 = 0;
        int n9 = n4 + 16 + 8 * n6;
        int n10 = n9 + 8;
        double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n10);
        if (Double.isNaN(d) || d <= -1.0E39) {
            int n11;
            if (n == 15) {
                int n12;
                JGeometry[] jGeometryArray = new JGeometry[n5];
                for (int i = 0; i < n5; ++i) {
                    n12 = nArray[i + 1] - nArray[i];
                    double[] dArray = new double[3 * n12];
                    for (int j = 0; j < n12 * 3; ++j) {
                        dArray[j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                        n2 += 8;
                        if (++n8 != 2) continue;
                        dArray[++j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n7);
                        n7 += 8;
                        n8 = 0;
                    }
                    jGeometryArray[i] = JGeometry.createLinearLineString((double[])dArray, (int)3, (int)n3);
                }
                double[][] dArrayArray = new double[jGeometryArray.length][];
                for (n12 = 0; n12 < jGeometryArray.length; ++n12) {
                    dArrayArray[n12] = jGeometryArray[n12].getOrdinatesArray();
                }
                JGeometry jGeometry = JGeometry.createLinearPolygon((Object[])dArrayArray, (int)3, (int)n3);
                return jGeometry;
            }
            if (n5 == 1) {
                int n13 = nArray[1] - nArray[0];
                double[] dArray = new double[3 * n13];
                for (int i = 0; i < n13 * 3; ++i) {
                    dArray[i] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                    n2 += 8;
                    if (++n8 != 2) continue;
                    dArray[++i] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n7);
                    n7 += 8;
                    n8 = 0;
                }
                return JGeometry.createLinearLineString((double[])dArray, (int)3, (int)n3);
            }
            JGeometry[] jGeometryArray = new JGeometry[n5];
            for (int i = 0; i < n5; ++i) {
                n11 = nArray[i + 1] - nArray[i];
                double[] dArray = new double[3 * n11];
                for (int j = 0; j < n11 * 3; ++j) {
                    dArray[j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                    n2 += 8;
                    if (++n8 != 2) continue;
                    dArray[++j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n7);
                    n7 += 8;
                    n8 = 0;
                }
                jGeometryArray[i] = JGeometry.createLinearLineString((double[])dArray, (int)3, (int)n3);
            }
            double[][] dArrayArray = new double[jGeometryArray.length][];
            for (n11 = 0; n11 < jGeometryArray.length; ++n11) {
                dArrayArray[n11] = jGeometryArray[n11].getOrdinatesArray();
            }
            return JGeometry.createLinearMultiLineString((Object[])dArrayArray, (int)3, (int)n3);
        }
        return ShapefileReaderJGeom.makePolyZM(byArray, n, n2, n3, nArray, n5, n6, n7, n10);
    }

    protected static JGeometry makePolyZM(byte[] byArray, int n, int n2, int n3, int[] nArray, int n4, int n5, int n6, int n7) throws IOException {
        int n8;
        int n9 = 0;
        int n10 = n7 + 8;
        if (n == 15) {
            int n11;
            JGeometry[] jGeometryArray = new JGeometry[n4];
            for (int i = 0; i < n4; ++i) {
                n11 = nArray[i + 1] - nArray[i];
                double[] dArray = new double[4 * n11];
                for (int j = 0; j < n11 * 4; ++j) {
                    dArray[j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                    n2 += 8;
                    if (++n9 != 2) continue;
                    dArray[++j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n6);
                    n6 += 8;
                    ++j;
                    double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n10);
                    if (d <= -1.0E39) {
                        d = Double.NaN;
                    }
                    dArray[j] = d;
                    n10 += 8;
                    n9 = 0;
                }
                jGeometryArray[i] = JGeometry.createLRSLinearLineString((double[])dArray, (int)3, (int)n3);
            }
            double[][] dArrayArray = new double[jGeometryArray.length][];
            for (n11 = 0; n11 < jGeometryArray.length; ++n11) {
                dArrayArray[n11] = jGeometryArray[n11].getOrdinatesArray();
            }
            JGeometry jGeometry = JGeometry.createLRSLinearPolygon((Object[])dArrayArray, (int)3, (int)n3);
            return jGeometry;
        }
        if (n4 == 1) {
            int n12 = nArray[1] - nArray[0];
            double[] dArray = new double[4 * n12];
            for (int i = 0; i < n12 * 4; ++i) {
                dArray[i] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                n2 += 8;
                if (++n9 != 2) continue;
                dArray[++i] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n6);
                n6 += 8;
                ++i;
                double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n10);
                if (d <= -1.0E39) {
                    d = Double.NaN;
                }
                dArray[i] = d;
                n10 += 8;
                n9 = 0;
            }
            return JGeometry.createLRSLinearLineString((double[])dArray, (int)3, (int)n3);
        }
        JGeometry[] jGeometryArray = new JGeometry[n4];
        for (int i = 0; i < n4; ++i) {
            n8 = nArray[i + 1] - nArray[i];
            double[] dArray = new double[4 * n8];
            for (int j = 0; j < n8 * 3; ++j) {
                dArray[j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                n2 += 8;
                if (++n9 != 2) continue;
                dArray[++j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n6);
                n6 += 8;
                ++j;
                double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n10);
                if (d <= -1.0E39) {
                    d = Double.NaN;
                }
                dArray[j] = d;
                n10 += 8;
                n9 = 0;
            }
            jGeometryArray[i] = JGeometry.createLRSLinearLineString((double[])dArray, (int)3, (int)n3);
        }
        double[][] dArrayArray = new double[jGeometryArray.length][];
        for (n8 = 0; n8 < jGeometryArray.length; ++n8) {
            dArrayArray[n8] = jGeometryArray[n8].getOrdinatesArray();
        }
        return JGeometry.createLRSLinearMultiLineString((Object[])dArrayArray, (int)3, (int)n3);
    }

    protected static JGeometry makePolyM(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n2 += 32);
        int[] nArray = new int[n6 + 1];
        int n7 = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n2 += 4);
        n2 += 4;
        nArray[n6] = n7;
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = ShapefileReaderJGeom.makeIntLittleEndian(byArray, n2);
            n2 += 4;
        }
        n5 = n2 + 16 * n7;
        int n8 = n5 + 16;
        int n9 = 0;
        if (n == 25) {
            int n10;
            JGeometry[] jGeometryArray = new JGeometry[n6];
            for (int i = 0; i < n6; ++i) {
                n10 = nArray[i + 1] - nArray[i];
                double[] dArray = new double[3 * n10];
                for (int j = 0; j < n10 * 3; ++j) {
                    dArray[j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                    n2 += 8;
                    if (++n9 != 2) continue;
                    ++j;
                    double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n8);
                    if (d <= -1.0E39) {
                        d = Double.NaN;
                    }
                    dArray[j] = d;
                    n8 += 8;
                    n9 = 0;
                }
                jGeometryArray[i] = JGeometry.createLRSLinearLineString((double[])dArray, (int)2, (int)n3);
            }
            double[][] dArrayArray = new double[jGeometryArray.length][];
            for (n10 = 0; n10 < jGeometryArray.length; ++n10) {
                dArrayArray[n10] = jGeometryArray[n10].getOrdinatesArray();
            }
            JGeometry jGeometry = JGeometry.createLRSLinearPolygon((Object[])dArrayArray, (int)2, (int)n3);
            return jGeometry;
        }
        if (n6 == 1) {
            int n11 = nArray[1] - nArray[0];
            double[] dArray = new double[3 * n11];
            for (int i = 0; i < n11 * 3; ++i) {
                dArray[i] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                n2 += 8;
                if (++n9 != 2) continue;
                ++i;
                double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n8);
                if (d <= -1.0E39) {
                    d = Double.NaN;
                }
                dArray[i] = d;
                n8 += 8;
                n9 = 0;
            }
            return JGeometry.createLRSLinearLineString((double[])dArray, (int)2, (int)n3);
        }
        JGeometry[] jGeometryArray = new JGeometry[n6];
        for (int i = 0; i < n6; ++i) {
            n4 = nArray[i + 1] - nArray[i];
            double[] dArray = new double[3 * n4];
            for (int j = 0; j < n4 * 3; ++j) {
                dArray[j] = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n2);
                n2 += 8;
                if (++n9 != 2) continue;
                ++j;
                double d = ShapefileReaderJGeom.makeDoubleLittleEndian(byArray, n8);
                if (d <= -1.0E39) {
                    d = Double.NaN;
                }
                dArray[j] = d;
                n8 += 8;
                n9 = 0;
            }
            jGeometryArray[i] = JGeometry.createLRSLinearLineString((double[])dArray, (int)2, (int)n3);
        }
        double[][] dArrayArray = new double[jGeometryArray.length][];
        for (n4 = 0; n4 < jGeometryArray.length; ++n4) {
            dArrayArray[n4] = jGeometryArray[n4].getOrdinatesArray();
        }
        return JGeometry.createLRSLinearMultiLineString((Object[])dArrayArray, (int)2, (int)n3);
    }

    public static void swapBytes(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2 / 2; ++i) {
            byte by = byArray[n + i];
            byArray[n + i] = byArray[n + n2 - 1 - i];
            byArray[n + n2 - 1 - i] = by;
        }
    }

    protected static int makeIntBigEndian(byte[] byArray, int n) {
        return byArray[n + 0] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
    }

    protected static int makeIntLittleEndian(byte[] byArray, int n) {
        return byArray[n + 3] << 24 & 0xFF000000 | byArray[n + 2] << 16 & 0xFF0000 | byArray[n + 1] << 8 & 0xFF00 | byArray[n + 0] & 0xFF;
    }

    protected static double makeDoubleBigEndian(byte[] byArray, int n) {
        long l = (long)byArray[n + 0] << 56 & 0xFF00000000000000L | (long)byArray[n + 1] << 48 & 0xFF000000000000L | (long)byArray[n + 2] << 40 & 0xFF0000000000L | (long)byArray[n + 3] << 32 & 0xFF00000000L | (long)byArray[n + 4] << 24 & 0xFF000000L | (long)byArray[n + 5] << 16 & 0xFF0000L | (long)byArray[n + 6] << 8 & 0xFF00L | (long)byArray[n + 7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    protected static double makeDoubleLittleEndian(byte[] byArray, int n) {
        try {
            long l = (long)byArray[n + 7] << 56 & 0xFF00000000000000L | (long)byArray[n + 6] << 48 & 0xFF000000000000L | (long)byArray[n + 5] << 40 & 0xFF0000000000L | (long)byArray[n + 4] << 32 & 0xFF00000000L | (long)byArray[n + 3] << 24 & 0xFF000000L | (long)byArray[n + 2] << 16 & 0xFF0000L | (long)byArray[n + 1] << 8 & 0xFF00L | (long)byArray[n + 0] & 0xFFL;
            return Double.longBitsToDouble(l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return Double.NaN;
        }
    }

    public ShapefileReaderJGeom(String string) throws IOException {
        this.partBuffer = new double[this.partBufferLen * 2];
        this.mainFileHdr = new ShapefileHdr();
        this.idxFileHdr = new ShapefileHdr();
        this.openShapefile(string);
    }

    protected void openShapefile(String string) throws IOException {
        String string2;
        this.namePrefix = new String(string);
        if (string.lastIndexOf(".shp") < 0) {
            string2 = new String(string + ".shp");
            this.namePrefix = new String(string);
        } else {
            string2 = new String(string);
            this.namePrefix = new String(string.substring(0, string.lastIndexOf(".shp")));
        }
        String string3 = new String(string2.substring(0, string2.lastIndexOf(".shp")) + ".shx");
        this.mainFIS = new RandomAccessFile(string2, "r");
        this.mainFIS.read(this.recBuffer, 0, 100);
        this.mainFileHdr.fromBuffer(this.recBuffer);
        this.idxFIS = new RandomAccessFile(string3, "r");
        this.idxFIS.read(this.recBuffer, 0, 100);
        this.idxFileHdr.fromBuffer(this.recBuffer);
        this.type = this.mainFileHdr.shapeType;
        this.nRecords = (this.idxFileHdr.fileLength * 2 - 100) / 8;
        this.xMax = this.mainFileHdr.Xmax;
        this.xMin = this.mainFileHdr.Xmin;
        this.yMax = this.mainFileHdr.Ymax;
        this.yMin = this.mainFileHdr.Ymin;
        this.zMax = this.mainFileHdr.Zmax;
        this.zMin = this.mainFileHdr.Zmin;
        this.measureMax = this.mainFileHdr.Mmax;
        this.measureMin = this.mainFileHdr.Mmin;
    }

    public void closeShapefile() throws IOException {
        if (this.mainFIS != null) {
            this.mainFIS.close();
        }
        if (this.idxFIS != null) {
            this.idxFIS.close();
        }
    }

    public byte[] getGeometryBytes(int n) throws IOException {
        IndexRecord indexRecord = new IndexRecord();
        this.mainRecordOffset(n, indexRecord);
        int n2 = indexRecord.offset;
        int n3 = indexRecord.contentLen + 8;
        byte[] byArray = new byte[n3];
        this.mainFIS.seek(n2);
        this.mainFIS.read(byArray, 0, n3);
        return byArray;
    }

    protected long idxRecordOffset(int n) {
        return 100 + n * 8;
    }

    protected boolean mainRecordOffset(int n, IndexRecord indexRecord) {
        try {
            this.idxFIS.seek(this.idxRecordOffset(n));
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException);
            return false;
        }
        try {
            indexRecord.offset = this.idxFIS.readInt() * 2;
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException);
            return false;
        }
        try {
            indexRecord.contentLen = this.idxFIS.readInt() * 2;
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException);
            return false;
        }
        return true;
    }

    public int numRecords() {
        return this.nRecords;
    }

    public int getShpFileType() {
        return this.type;
    }

    public double getMaxMeasure() {
        return this.measureMax;
    }

    public double getMinMeasure() {
        return this.measureMin;
    }

    public double getMaxZ() {
        return this.zMax;
    }

    public double getMinZ() {
        return this.zMin;
    }

    public double getMaxX() {
        return this.xMax;
    }

    public double getMinX() {
        return this.xMin;
    }

    public double getMaxY() {
        return this.yMax;
    }

    public double getMinY() {
        return this.yMin;
    }
}

