/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;

public class Util {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] convert(String string) {
        int n = 0;
        double[] dArray = new double[string.length() / 2 + 1];
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string.trim()));
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.whitespaceChars(59, 59);
        try {
            while (streamTokenizer.nextToken() == -2) {
                dArray[n++] = streamTokenizer.nval;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            double[] dArray2 = null;
            return dArray2;
        }
        finally {
            streamTokenizer = null;
        }
        if (n == 0) {
            return null;
        }
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i];
        }
        dArray = null;
        return dArray3;
    }

    public static ArrayList splitBy(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static Shape getShape(double[] dArray, boolean bl) {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo((float)dArray[0], (float)dArray[1]);
        for (int i = 1; i < dArray.length / 2; ++i) {
            generalPath.lineTo((float)dArray[i * 2], (float)dArray[i * 2 + 1]);
        }
        if (bl) {
            generalPath.closePath();
        }
        return generalPath;
    }

    public static Rectangle2D.Double mbr(double[] dArray) {
        double d;
        double d2;
        double d3 = d2 = dArray[0];
        double d4 = d = dArray[1];
        for (int i = 1; i < dArray.length / 2; ++i) {
            if (d3 > dArray[i * 2]) {
                d3 = dArray[i * 2];
            }
            if (d2 < dArray[i * 2]) {
                d2 = dArray[i * 2];
            }
            if (d4 > dArray[i * 2 + 1]) {
                d4 = dArray[i * 2 + 1];
            }
            if (!(d < dArray[i * 2 + 1])) continue;
            d = dArray[i * 2 + 1];
        }
        return new Rectangle2D.Double(d3, d4, d2 - d3, d - d4);
    }

    public static byte[] readFile(String string) throws IOException {
        Vector<byte[]> vector = new Vector<byte[]>(32);
        byte[] byArray = new byte[2048];
        int n = 0;
        int n2 = 0;
        FileInputStream fileInputStream = new FileInputStream(string);
        while ((n = fileInputStream.read(byArray)) == 2048) {
            vector.addElement(byArray);
            byArray = new byte[2048];
        }
        fileInputStream.close();
        if (n <= 0) {
            return null;
        }
        byte[] byArray2 = new byte[vector.size() * 2048 + n];
        int n3 = 0;
        while (n3 < vector.size()) {
            System.arraycopy(vector.elementAt(n3), 0, byArray2, n2, 2048);
            ++n3;
            n2 += 2048;
        }
        System.arraycopy(byArray, 0, byArray2, n2, n);
        return byArray2;
    }

    public static Connection connect(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        String string7 = Util.getConnStr(string6, string, string3, string2);
        Connection connection = null;
        if (n <= 0) {
            n = 32;
        }
        try {
            if (!DriverManager.getDrivers().hasMoreElements()) {
                DriverManager.registerDriver((Driver)new OracleDriver());
            }
            connection = DriverManager.getConnection(string7, string4, string5);
            ((OracleConnection)connection).setDefaultRowPrefetch(n);
        }
        catch (SQLException sQLException) {
            String string8 = "jdbc:oracle:thin:@(DESCRIPTION=(LOAD_BALANCE=on)(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=" + string + ") (PORT=" + string3 + ")))" + "(CONNECT_DATA=(SERVICE_NAME=" + string2 + ")))";
            try {
                OracleDataSource oracleDataSource = new OracleDataSource();
                oracleDataSource.setDriverType("thin");
                oracleDataSource.setURL(string8);
                oracleDataSource.setUser(string4);
                oracleDataSource.setPassword(string5);
                Connection connection2 = oracleDataSource.getConnection();
                connection2.setAutoCommit(false);
                if (connection2 != null) {
                    return connection2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string7 = Util.getConnStr("thin", string, string3, string2);
            try {
                if (!DriverManager.getDrivers().hasMoreElements()) {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                }
                connection = DriverManager.getConnection(string7, string4, string5);
                ((OracleConnection)connection).setDefaultRowPrefetch(n);
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
                return null;
            }
        }
        catch (Error error) {
            String string9 = "jdbc:oracle:thin:@(DESCRIPTION=(LOAD_BALANCE=on)(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=" + string + ") (PORT=" + string3 + ")))" + "(CONNECT_DATA=(SERVICE_NAME=" + string2 + ")))";
            try {
                OracleDataSource oracleDataSource = new OracleDataSource();
                oracleDataSource.setDriverType("thin");
                oracleDataSource.setURL(string9);
                oracleDataSource.setUser(string4);
                oracleDataSource.setPassword(string5);
                Connection connection3 = oracleDataSource.getConnection();
                connection3.setAutoCommit(false);
                if (connection3 != null) {
                    return connection3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string7 = Util.getConnStr("thin", string, string3, string2);
            try {
                if (!DriverManager.getDrivers().hasMoreElements()) {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                }
                connection = DriverManager.getConnection(string7, string4, string5);
                ((OracleConnection)connection).setDefaultRowPrefetch(n);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                return null;
            }
        }
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return connection;
    }

    public static String getJDBCDriverVersion(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData.getDriverVersion();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            return null;
        }
    }

    public static String getDBVersion(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            return null;
        }
    }

    public static boolean isPre9i(Connection connection) {
        String string = Util.getDBVersion(connection);
        if (string.indexOf("Oracle8i") >= 0) {
            return true;
        }
        if (string.indexOf("Oracle9i") >= 0) {
            return false;
        }
        return string.indexOf("Oracle7") >= 0;
    }

    public static boolean isGeodetic(int n) {
        return n > 0 && n < 32768;
    }

    public static String getConnStr(String string, String string2, String string3, String string4) {
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0 || string4 == null || string4.length() == 0 || string == null) {
            return "jdbc:oracle:oci8:@";
        }
        if (string.equalsIgnoreCase("default")) {
            return "jdbc:oracle:oci8:@";
        }
        if (string.equalsIgnoreCase("thin")) {
            return "jdbc:oracle:thin:@" + string2 + ":" + string3 + ":" + string4;
        }
        if (string.equalsIgnoreCase("oci8") || string.equalsIgnoreCase("oci")) {
            return "jdbc:oracle:oci8:@(DESCRIPTION = (ADDRESS_LIST = (ADDRESS = (PROTOCOL = TCP)(HOST = " + string2 + ")(PORT = " + string3 + ")))" + "(CONNECT_DATA = (SID = " + string4 + ")))";
        }
        if (string.equalsIgnoreCase("kprb")) {
            return null;
        }
        return null;
    }

    public static void center(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        component.setLocation(n, n2);
    }

    static void which(String string) {
    }

    public static void main(String[] stringArray) throws IOException, Exception, SQLException {
        int n = 3;
        double d = 1.0E-8;
        double[] dArray = new double[]{1.0, 3.0, 2.0, 3.0, 2.0, 8.0, 5.0, 8.0, 5.0, 3.0, 6.0, 3.0, 6.0, 9.0, 1.0, 9.0, 1.0, 3.0, 3.0, 1.0, 8.0, 1.0, 8.0, 6.0, 7.0, 6.0, 7.0, 2.0, 4.0, 2.0, 4.0, 6.0, 3.0, 6.0, 3.0, 1.0};
        int[] nArray = new int[]{1, 1003, 1, 19, 1003, 1};
        double[] dArray2 = new double[]{1.0, 6.0, 2.0, 6.0, 2.0, 7.0, 1.0, 7.0, 1.0, 6.0, 1.0, 3.0, 2.0, 3.0, 2.0, 4.0, 1.0, 4.0, 1.0, 3.0, 1.0, 1.0, 2.0, 1.0, 2.0, 2.0, 1.0, 2.0, 1.0, 1.0, 3.0, 2.0, 4.0, 2.0, 4.0, 4.0, 3.0, 4.0, 3.0, 2.0};
        int[] nArray2 = new int[]{1, 1003, 1, 11, 1003, 1, 21, 1003, 1, 31, 1003, 1};
    }

    public static String checkSQLName(String string, int n) throws SQLException {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() > n) {
            throw new SQLException("String length Exception!(" + string2.length() + " > " + n + ")");
        }
        block3: for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            switch (c) {
                case '#': 
                case '$': 
                case '.': 
                case '_': {
                    continue block3;
                }
                default: {
                    throw new SQLException("Illegal character [" + c + "] in string");
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String qualifiedSQLName(Connection connection, String string) throws SQLException {
        String string2 = null;
        CallableStatement callableStatement = null;
        try {
            if (string != null) {
                callableStatement = connection.prepareCall("begin ? := SYS.DBMS_ASSERT.qualified_sql_name(?); end; ");
                callableStatement.registerOutParameter(1, 12);
                callableStatement.setString(2, string);
                callableStatement.execute();
                string2 = new String(callableStatement.getString(1));
            }
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return string2;
    }
}

